/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.TokenMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkTopologyStrategy
extends AbstractReplicationStrategy {
    private final IEndpointSnitch snitch;
    private final Map<String, Integer> datacenters;
    private static final Logger logger = LoggerFactory.getLogger(NetworkTopologyStrategy.class);

    public NetworkTopologyStrategy(String table, TokenMetadata tokenMetadata, IEndpointSnitch snitch, Map<String, String> configOptions) throws ConfigurationException {
        super(table, tokenMetadata, snitch, configOptions);
        this.snitch = snitch;
        HashMap<String, Integer> newDatacenters = new HashMap<String, Integer>();
        if (configOptions != null) {
            for (Map.Entry<String, String> entry : configOptions.entrySet()) {
                String dc = entry.getKey();
                if (dc.equalsIgnoreCase("replication_factor")) {
                    throw new ConfigurationException("replication_factor is an option for SimpleStrategy, not NetworkTopologyStrategy");
                }
                Integer replicas = Integer.valueOf(entry.getValue());
                newDatacenters.put(dc, replicas);
            }
        }
        this.datacenters = Collections.unmodifiableMap(newDatacenters);
        logger.debug("Configured datacenter replicas are {}", (Object)FBUtilities.toString(this.datacenters));
    }

    @Override
    public List<InetAddress> calculateNaturalEndpoints(Token searchToken, TokenMetadata tokenMetadata) {
        HashSet<InetAddress> replicas = new HashSet<InetAddress>();
        HashMap<String, Set<InetAddress>> dcReplicas = new HashMap<String, Set<InetAddress>>(this.datacenters.size()){
            {
                for (Map.Entry dc : NetworkTopologyStrategy.this.datacenters.entrySet()) {
                    this.put(dc.getKey(), new HashSet((Integer)dc.getValue()));
                }
            }
        };
        TokenMetadata.Topology topology = tokenMetadata.getTopology();
        Multimap<String, InetAddress> allEndpoints = topology.getDatacenterEndpoints();
        Map<String, Multimap<String, InetAddress>> racks = topology.getDatacenterRacks();
        assert (!allEndpoints.isEmpty() && !racks.isEmpty()) : "not aware of any cluster members";
        HashMap<String, Set<String>> seenRacks = new HashMap<String, Set<String>>(this.datacenters.size()){
            {
                for (Map.Entry dc : NetworkTopologyStrategy.this.datacenters.entrySet()) {
                    this.put(dc.getKey(), new HashSet());
                }
            }
        };
        HashMap<String, Set<InetAddress>> skippedDcEndpoints = new HashMap<String, Set<InetAddress>>(this.datacenters.size()){
            {
                for (Map.Entry dc : NetworkTopologyStrategy.this.datacenters.entrySet()) {
                    this.put(dc.getKey(), new LinkedHashSet());
                }
            }
        };
        Iterator<Token> tokenIter = TokenMetadata.ringIterator(tokenMetadata.sortedTokens(), searchToken, false);
        while (tokenIter.hasNext() && !this.hasSufficientReplicas((Map<String, Set<InetAddress>>)dcReplicas, allEndpoints)) {
            Token next = tokenIter.next();
            InetAddress ep = tokenMetadata.getEndpoint(next);
            String dc = this.snitch.getDatacenter(ep);
            if (!this.datacenters.containsKey(dc) || this.hasSufficientReplicas(dc, (Map<String, Set<InetAddress>>)dcReplicas, allEndpoints)) continue;
            if (((Set)seenRacks.get(dc)).size() == racks.get(dc).keySet().size()) {
                ((Set)dcReplicas.get(dc)).add(ep);
                replicas.add(ep);
                continue;
            }
            String rack = this.snitch.getRack(ep);
            if (((Set)seenRacks.get(dc)).contains(rack)) {
                ((Set)skippedDcEndpoints.get(dc)).add(ep);
                continue;
            }
            ((Set)dcReplicas.get(dc)).add(ep);
            replicas.add(ep);
            ((Set)seenRacks.get(dc)).add(rack);
            if (((Set)seenRacks.get(dc)).size() != racks.get(dc).keySet().size()) continue;
            Iterator skippedIt = ((Set)skippedDcEndpoints.get(dc)).iterator();
            while (skippedIt.hasNext() && !this.hasSufficientReplicas(dc, (Map<String, Set<InetAddress>>)dcReplicas, allEndpoints)) {
                InetAddress nextSkipped = (InetAddress)skippedIt.next();
                ((Set)dcReplicas.get(dc)).add(nextSkipped);
                replicas.add(nextSkipped);
            }
        }
        return new ArrayList<InetAddress>(replicas);
    }

    private boolean hasSufficientReplicas(String dc, Map<String, Set<InetAddress>> dcReplicas, Multimap<String, InetAddress> allEndpoints) {
        return dcReplicas.get(dc).size() >= Math.min(allEndpoints.get((Object)dc).size(), this.getReplicationFactor(dc));
    }

    private boolean hasSufficientReplicas(Map<String, Set<InetAddress>> dcReplicas, Multimap<String, InetAddress> allEndpoints) {
        for (String dc : this.datacenters.keySet()) {
            if (this.hasSufficientReplicas(dc, dcReplicas, allEndpoints)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getReplicationFactor() {
        int total = 0;
        for (int repFactor : this.datacenters.values()) {
            total += repFactor;
        }
        return total;
    }

    public int getReplicationFactor(String dc) {
        return this.datacenters.get(dc);
    }

    public Set<String> getDatacenters() {
        return this.datacenters.keySet();
    }

    @Override
    public void validateOptions() throws ConfigurationException {
        for (Map.Entry e : this.configOptions.entrySet()) {
            this.validateReplicationFactor((String)e.getValue());
        }
    }
}

