/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutationSerializer;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SliceByNamesReadCommand;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.HeapAllocator;

public class CounterMutation
implements IMutation {
    public static final CounterMutationSerializer serializer = new CounterMutationSerializer();
    private final RowMutation rowMutation;
    private final ConsistencyLevel consistency;

    public CounterMutation(RowMutation rowMutation, ConsistencyLevel consistency) {
        this.rowMutation = rowMutation;
        this.consistency = consistency;
    }

    @Override
    public String getTable() {
        return this.rowMutation.getTable();
    }

    @Override
    public Collection<UUID> getColumnFamilyIds() {
        return this.rowMutation.getColumnFamilyIds();
    }

    @Override
    public ByteBuffer key() {
        return this.rowMutation.key();
    }

    public RowMutation rowMutation() {
        return this.rowMutation;
    }

    public ConsistencyLevel consistency() {
        return this.consistency;
    }

    public RowMutation makeReplicationMutation() throws IOException {
        LinkedList<ReadCommand> readCommands = new LinkedList<ReadCommand>();
        for (ColumnFamily columnFamily : this.rowMutation.getColumnFamilies()) {
            if (!columnFamily.metadata().getReplicateOnWrite()) continue;
            this.addReadCommandFromColumnFamily(this.rowMutation.getTable(), this.rowMutation.key(), columnFamily, readCommands);
        }
        RowMutation replicationMutation = new RowMutation(this.rowMutation.getTable(), this.rowMutation.key());
        for (ReadCommand readCommand : readCommands) {
            Table table;
            Row row = readCommand.getRow(table = Table.open(readCommand.table));
            if (row == null || row.cf == null) continue;
            ColumnFamily cf = row.cf;
            if (cf.isSuper()) {
                cf.retainAll(this.rowMutation.getColumnFamily(cf.metadata().cfId));
            }
            replicationMutation.add(cf);
        }
        return replicationMutation;
    }

    private void addReadCommandFromColumnFamily(String table, ByteBuffer key, ColumnFamily columnFamily, List<ReadCommand> commands) {
        QueryPath queryPath = new QueryPath(columnFamily.metadata().cfName);
        commands.add(new SliceByNamesReadCommand(table, key, queryPath, columnFamily.getColumnNames()));
    }

    public MessageOut<CounterMutation> makeMutationMessage() throws IOException {
        return new MessageOut<CounterMutation>(MessagingService.Verb.COUNTER_MUTATION, this, serializer);
    }

    public boolean shouldReplicateOnWrite() {
        for (ColumnFamily cf : this.rowMutation.getColumnFamilies()) {
            if (!cf.metadata().getReplicateOnWrite()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void apply() throws IOException {
        RowMutation rm = new RowMutation(this.rowMutation.getTable(), ByteBufferUtil.clone(this.rowMutation.key()));
        Table table = Table.open(rm.getTable());
        for (ColumnFamily cf_ : this.rowMutation.getColumnFamilies()) {
            ColumnFamily cf = cf_.cloneMeShallow();
            ColumnFamilyStore cfs = table.getColumnFamilyStore(cf.id());
            for (IColumn column : cf_) {
                cf.addColumn(column.localCopy(cfs), HeapAllocator.instance);
            }
            rm.add(cf);
        }
        rm.apply();
    }

    @Override
    public void addAll(IMutation m) {
        if (!(m instanceof CounterMutation)) {
            throw new IllegalArgumentException();
        }
        CounterMutation cm = (CounterMutation)m;
        this.rowMutation.addAll(cm.rowMutation);
    }

    public String toString() {
        return this.toString(false);
    }

    @Override
    public String toString(boolean shallow) {
        StringBuilder buff = new StringBuilder("CounterMutation(");
        buff.append(this.rowMutation.toString(shallow));
        buff.append(", ").append(this.consistency.toString());
        return buff.append(")").toString();
    }
}

