/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.cql3.Attributes;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.statements.ModificationStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.CounterMutation;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.utils.Pair;

public class BatchStatement
extends ModificationStatement {
    protected final List<ModificationStatement> statements;

    public BatchStatement(List<ModificationStatement> statements, Attributes attrs) {
        super(null, attrs);
        this.statements = statements;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.prepareKeyspace(state);
        }
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException, UnauthorizedException {
        HashSet<String> cfamsSeen = new HashSet<String>();
        for (ModificationStatement statement : this.statements) {
            if (cfamsSeen.contains(statement.columnFamily())) continue;
            state.hasColumnFamilyAccess(statement.keyspace(), statement.columnFamily(), Permission.UPDATE);
            cfamsSeen.add(statement.columnFamily());
        }
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.isSetConsistencyLevel() ? super.getConsistencyLevel() : (this.statements.isEmpty() ? ConsistencyLevel.ONE : this.statements.get(0).getConsistencyLevel());
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException {
        if (this.getTimeToLive() != 0) {
            throw new InvalidRequestException("Global TTL on the BATCH statement is not supported.");
        }
        ConsistencyLevel cLevel = null;
        for (ModificationStatement statement : this.statements) {
            if (statement.isSetConsistencyLevel()) {
                throw new InvalidRequestException("Consistency level must be set on the BATCH, not individual statements");
            }
            if (this.isSetTimestamp() && statement.isSetTimestamp()) {
                throw new InvalidRequestException("Timestamp must be set either on BATCH or individual statements");
            }
            if (statement.getTimeToLive() < 0) {
                throw new InvalidRequestException("A TTL must be greater or equal to 0");
            }
            if (this.isSetConsistencyLevel()) {
                this.getConsistencyLevel().validateForWrite(statement.keyspace());
                continue;
            }
            ConsistencyLevel stmtCL = statement.getConsistencyLevel();
            if (cLevel != null && cLevel != stmtCL) {
                throw new InvalidRequestException("The tables involved in the BATCH have different default write consistency, you must explicitely set the BATCH consitency level with USING CONSISTENCY");
            }
            cLevel = stmtCL;
        }
    }

    @Override
    public List<IMutation> getMutations(ClientState clientState, List<ByteBuffer> variables) throws RequestExecutionException, RequestValidationException {
        HashMap<Pair<String, ByteBuffer>, RowAndCounterMutation> mutations = new HashMap<Pair<String, ByteBuffer>, RowAndCounterMutation>();
        for (ModificationStatement statement : this.statements) {
            if (this.isSetTimestamp()) {
                statement.setTimestamp(this.getTimestamp(clientState));
            }
            List<IMutation> lm = statement.getMutations(clientState, variables);
            for (IMutation m : lm) {
                Pair<String, ByteBuffer> key = Pair.create(m.getTable(), m.key());
                RowAndCounterMutation racm = (RowAndCounterMutation)mutations.get(key);
                if (racm == null) {
                    racm = new RowAndCounterMutation();
                    mutations.put(key, racm);
                }
                if (m instanceof CounterMutation) {
                    if (racm.cm == null) {
                        racm.cm = (CounterMutation)m;
                        continue;
                    }
                    racm.cm.addAll(m);
                    continue;
                }
                assert (m instanceof RowMutation);
                if (racm.rm == null) {
                    racm.rm = (RowMutation)m;
                    continue;
                }
                racm.rm.addAll(m);
            }
        }
        LinkedList<IMutation> batch = new LinkedList<IMutation>();
        for (RowAndCounterMutation racm : mutations.values()) {
            if (racm.rm != null) {
                batch.add(racm.rm);
            }
            if (racm.cm == null) continue;
            batch.add(racm.cm);
        }
        return batch;
    }

    @Override
    public ParsedStatement.Prepared prepare(CFDefinition.Name[] boundNames) throws InvalidRequestException {
        for (ModificationStatement statement : this.statements) {
            statement.prepare(boundNames);
        }
        return new ParsedStatement.Prepared(this, Arrays.asList(boundNames));
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        CFDefinition.Name[] boundNames = new CFDefinition.Name[this.getBoundsTerms()];
        return this.prepare(boundNames);
    }

    public String toString() {
        return String.format("BatchStatement(statements=%s, consistency=%s)", new Object[]{this.statements, this.getConsistencyLevel()});
    }

    private static class RowAndCounterMutation {
        public RowMutation rm;
        public CounterMutation cm;

        private RowAndCounterMutation() {
        }
    }
}

