/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.operations;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.ColumnNameBuilder;
import org.apache.cassandra.cql3.Term;
import org.apache.cassandra.cql3.UpdateParameters;
import org.apache.cassandra.cql3.operations.Operation;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;

public class SetOperation
implements Operation {
    private final List<Term> values;
    private final Kind kind;

    private SetOperation(List<Term> values, Kind kind) {
        this.values = values;
        this.kind = kind;
    }

    @Override
    public void execute(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params, List<Pair<ByteBuffer, IColumn>> list) throws InvalidRequestException {
        if (validator.kind != CollectionType.Kind.SET) {
            throw new InvalidRequestException("Set operations are only supported on Set typed columns, but " + validator + " given.");
        }
        switch (this.kind) {
            case SET: {
                cf.addAtom(params.makeTombstoneForOverwrite(builder.copy().build(), builder.copy().buildAsEndOfRange()));
            }
            case ADD: {
                this.doAdd(cf, builder, validator, params);
                break;
            }
            case DISCARD: {
                this.doDiscard(cf, builder, validator, params);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unsupported Set operation: " + (Object)((Object)this.kind)));
            }
        }
    }

    @Override
    public void execute(ColumnFamily cf, ColumnNameBuilder builder, AbstractType<?> validator, UpdateParameters params) throws InvalidRequestException {
        throw new InvalidRequestException("Set operations are only supported on Set typed columns, but " + validator + " given.");
    }

    private void doAdd(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params) throws InvalidRequestException {
        for (int i = 0; i < this.values.size(); ++i) {
            ColumnNameBuilder b = i == this.values.size() - 1 ? builder : builder.copy();
            ByteBuffer name = b.add(this.values.get(i).getByteBuffer(validator.nameComparator(), params.variables)).build();
            cf.addColumn(params.makeColumn(name, ByteBufferUtil.EMPTY_BYTE_BUFFER));
        }
    }

    private void doDiscard(ColumnFamily cf, ColumnNameBuilder builder, CollectionType validator, UpdateParameters params) throws InvalidRequestException {
        for (int i = 0; i < this.values.size(); ++i) {
            ColumnNameBuilder b = i == this.values.size() - 1 ? builder : builder.copy();
            ByteBuffer name = b.add(this.values.get(i).getByteBuffer(validator.nameComparator(), params.variables)).build();
            cf.addColumn(params.makeTombstone(name));
        }
    }

    @Override
    public List<Term> getValues() {
        return this.values;
    }

    @Override
    public boolean requiresRead() {
        return false;
    }

    @Override
    public Operation.Type getType() {
        return Operation.Type.SET;
    }

    public static Operation Set(List<Term> values) {
        return new SetOperation(values, Kind.SET);
    }

    public static Operation Add(List<Term> values) {
        return new SetOperation(values, Kind.ADD);
    }

    public static Operation Discard(List<Term> values) {
        return new SetOperation(values, Kind.DISCARD);
    }

    static enum Kind {
        SET,
        ADD,
        DISCARD;

    }
}

