/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql.AbstractModification;
import org.apache.cassandra.cql.Attributes;
import org.apache.cassandra.cql.QueryProcessor;
import org.apache.cassandra.cql.Term;
import org.apache.cassandra.db.IMutation;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.thrift.ThriftValidation;

public class DeleteStatement
extends AbstractModification {
    private List<Term> columns;
    private List<Term> keys;

    public DeleteStatement(List<Term> columns, String keyspace, String columnFamily, String keyName, List<Term> keys, Attributes attrs) {
        super(keyspace, columnFamily, keyName, attrs);
        this.columns = columns;
        this.keys = keys;
    }

    public List<Term> getColumns() {
        return this.columns;
    }

    public List<Term> getKeys() {
        return this.keys;
    }

    @Override
    public List<IMutation> prepareRowMutations(String keyspace, ClientState clientState, List<ByteBuffer> variables) throws InvalidRequestException, UnauthorizedException {
        return this.prepareRowMutations(keyspace, clientState, null, variables);
    }

    @Override
    public List<IMutation> prepareRowMutations(String keyspace, ClientState clientState, Long timestamp, List<ByteBuffer> variables) throws InvalidRequestException, UnauthorizedException {
        CFMetaData metadata = ThriftValidation.validateColumnFamily(keyspace, this.columnFamily);
        clientState.hasColumnFamilyAccess(this.columnFamily, Permission.DELETE);
        AbstractType<?> keyType = Schema.instance.getCFMetaData(keyspace, this.columnFamily).getKeyValidator();
        ArrayList<IMutation> rowMutations = new ArrayList<IMutation>(this.keys.size());
        for (Term key : this.keys) {
            rowMutations.add(this.mutationForKey(key.getByteBuffer(keyType, variables), keyspace, timestamp, clientState, variables, metadata));
        }
        return rowMutations;
    }

    public RowMutation mutationForKey(ByteBuffer key, String keyspace, Long timestamp, ClientState clientState, List<ByteBuffer> variables, CFMetaData metadata) throws InvalidRequestException {
        RowMutation rm = new RowMutation(keyspace, key);
        QueryProcessor.validateKeyAlias(metadata, this.keyName);
        AbstractType<?> comparator = metadata.getComparatorFor(null);
        if (this.columns.size() < 1) {
            rm.delete(new QueryPath(this.columnFamily), timestamp == null ? this.getTimestamp(clientState) : timestamp.longValue());
        } else {
            for (Term column : this.columns) {
                ByteBuffer columnName = column.getByteBuffer(comparator, variables);
                QueryProcessor.validateColumnName(columnName);
                rm.delete(new QueryPath(this.columnFamily, null, columnName), timestamp == null ? this.getTimestamp(clientState) : timestamp.longValue());
            }
        }
        return rm;
    }

    public String toString() {
        return String.format("DeleteStatement(columns=%s, keyspace=%s, columnFamily=%s, consistency=%s keys=%s)", new Object[]{this.columns, this.keyspace, this.columnFamily, this.cLevel, this.keys});
    }
}

