/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.CreateColumnFamilyStatement;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.OnDiskAtom;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.index.SecondaryIndex;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.io.IColumnSerializer;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.SnappyCompressor;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CFMetaData {
    private static final Logger logger = LoggerFactory.getLogger(CFMetaData.class);
    public static final double DEFAULT_READ_REPAIR_CHANCE = 0.1;
    public static final double DEFAULT_DCLOCAL_READ_REPAIR_CHANCE = 0.0;
    public static final boolean DEFAULT_REPLICATE_ON_WRITE = true;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final String DEFAULT_COMPACTION_STRATEGY_CLASS = "SizeTieredCompactionStrategy";
    public static final ByteBuffer DEFAULT_KEY_NAME = ByteBufferUtil.bytes("KEY");
    public static final Caching DEFAULT_CACHING_STRATEGY = Caching.KEYS_ONLY;
    public static final Double DEFAULT_BF_FP_CHANCE = 0.01;
    public static final String DEFAULT_COMPRESSOR = SnappyCompressor.isAvailable() ? SnappyCompressor.class.getCanonicalName() : null;
    @Deprecated
    public static final CFMetaData OldStatusCf = CFMetaData.newSystemMetadata("system", "LocationInfo", 0, "unused", BytesType.instance, null);
    @Deprecated
    public static final CFMetaData OldHintsCf = CFMetaData.newSystemMetadata("system", "HintsColumnFamily", 1, "unused", BytesType.instance, BytesType.instance);
    @Deprecated
    public static final CFMetaData MigrationsCf = CFMetaData.newSystemMetadata("system", "Migrations", 2, "unused", TimeUUIDType.instance, null);
    @Deprecated
    public static final CFMetaData SchemaCf = CFMetaData.newSystemMetadata("system", "Schema", 3, "unused", UTF8Type.instance, null);
    public static final CFMetaData IndexCf = CFMetaData.compile(5, "CREATE TABLE \"IndexInfo\" (table_name text,index_name text,PRIMARY KEY (table_name, index_name)) WITH COMPACT STORAGE AND COMMENT='indexes that have been completed'");
    public static final CFMetaData CounterIdCf = CFMetaData.compile(6, "CREATE TABLE \"NodeIdInfo\" (key text,id timeuuid,PRIMARY KEY (key, id)) WITH COMPACT STORAGE AND COMMENT='counter node IDs'");
    public static final CFMetaData SchemaKeyspacesCf = CFMetaData.compile(8, "CREATE TABLE schema_keyspaces(keyspace_name text PRIMARY KEY,durable_writes boolean,strategy_class text,strategy_options text) WITH COMPACT STORAGE AND COMMENT='keyspace definitions' AND gc_grace_seconds=8640");
    public static final CFMetaData SchemaColumnFamiliesCf = CFMetaData.compile(9, "CREATE TABLE schema_columnfamilies(keyspace_name text,columnfamily_name text,id int,type text,comparator text,subcomparator text,comment text,read_repair_chance double,local_read_repair_chance double,replicate_on_write boolean,gc_grace_seconds int,default_validator text,key_validator text,min_compaction_threshold int,max_compaction_threshold int,key_alias text,key_aliases text,bloom_filter_fp_chance double,caching text,compaction_strategy_class text,compression_parameters text,value_alias text,column_aliases text,compaction_strategy_options text,default_read_consistency text,default_write_consistency text,PRIMARY KEY (keyspace_name, columnfamily_name)) WITH COMMENT='ColumnFamily definitions' AND gc_grace_seconds=8640");
    public static final CFMetaData SchemaColumnsCf = CFMetaData.compile(10, "CREATE TABLE schema_columns(keyspace_name text,columnfamily_name text,column_name text,validator text,index_type text,index_options text,index_name text,component_index int,PRIMARY KEY(keyspace_name, columnfamily_name, column_name)) WITH COMMENT='ColumnFamily column attributes' AND gc_grace_seconds=8640");
    public static final CFMetaData HintsCf = CFMetaData.compile(11, "CREATE TABLE hints (target_id uuid,hint_id timeuuid,message_version int,mutation blob,PRIMARY KEY (target_id, hint_id, message_version)) WITH COMPACT STORAGE AND COMPACTION={'class' : 'SizeTieredCompactionStrategy', 'min_threshold' : 0, 'max_threshold' : 0} AND COMMENT='hints awaiting delivery'");
    public static final CFMetaData PeersCf = CFMetaData.compile(12, "CREATE TABLE peers (token_bytes blob PRIMARY KEY,peer inet) WITH COMMENT='known peers in the cluster'");
    public static final CFMetaData LocalCf = CFMetaData.compile(13, "CREATE TABLE local (key text PRIMARY KEY,token_bytes blob,cluster_name text,gossip_generation int,bootstrapped text,ring_id uuid,release_version text,thrift_version text,cql_version text) WITH COMMENT='information about the local node'");
    public static final CFMetaData TraceSessionsCf = CFMetaData.compile(14, "CREATE TABLE sessions (  session_id uuid PRIMARY KEY,  coordinator inet,  request text,  started_at timestamp,  finished_at timestamp,  parameters map<text, text>) WITH COMMENT='traced sessions'", "system_traces");
    public static final CFMetaData TraceEventsCf = CFMetaData.compile(15, "CREATE TABLE events (  session_id uuid,  event_id timeuuid,  source inet,  thread text,  activity text,  happened_at timestamp,  source_elapsed int,  PRIMARY KEY (session_id, event_id));", "system_traces");
    public static final CFMetaData BatchlogCF = CFMetaData.compile(16, "CREATE TABLE batchlog (id uuid PRIMARY KEY,written_at timestamp,data blob) WITH COMMENT='uncommited batches' AND gc_grace_seconds=0");
    public static final CFMetaData RangeXfersCf = CFMetaData.compile(17, "CREATE TABLE range_xfers (token_bytes blob PRIMARY KEY,requested_at timestamp) WITH COMMENT='ranges requested for transfer here'");
    public final UUID cfId;
    public final String ksName;
    public final String cfName;
    public final ColumnFamilyType cfType;
    public AbstractType<?> comparator;
    public AbstractType<?> subcolumnComparator;
    private String comment;
    private double readRepairChance;
    private double dcLocalReadRepairChance;
    private boolean replicateOnWrite;
    private int gcGraceSeconds;
    private AbstractType<?> defaultValidator;
    private AbstractType<?> keyValidator;
    private int minCompactionThreshold;
    private int maxCompactionThreshold;
    private List<ByteBuffer> keyAliases = new ArrayList<ByteBuffer>();
    private List<ByteBuffer> columnAliases = new ArrayList<ByteBuffer>();
    private ByteBuffer valueAlias;
    private Double bloomFilterFpChance;
    private Caching caching;
    Map<ByteBuffer, ColumnDefinition> column_metadata;
    public Class<? extends AbstractCompactionStrategy> compactionStrategyClass;
    public Map<String, String> compactionStrategyOptions;
    public CompressionParameters compressionParameters;
    private ConsistencyLevel readConsistencyLevel;
    private ConsistencyLevel writeConsistencyLevel;
    private CFDefinition cqlCfDef;

    public CFMetaData comment(String prop) {
        this.comment = CFMetaData.enforceCommentNotNull(prop);
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.readRepairChance = prop;
        return this;
    }

    public CFMetaData dcLocalReadRepairChance(double prop) {
        this.dcLocalReadRepairChance = prop;
        return this;
    }

    public CFMetaData replicateOnWrite(boolean prop) {
        this.replicateOnWrite = prop;
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.gcGraceSeconds = prop;
        return this;
    }

    public CFMetaData defaultValidator(AbstractType<?> prop) {
        this.defaultValidator = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData keyValidator(AbstractType<?> prop) {
        this.keyValidator = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData minCompactionThreshold(int prop) {
        this.minCompactionThreshold = prop;
        return this;
    }

    public CFMetaData maxCompactionThreshold(int prop) {
        this.maxCompactionThreshold = prop;
        return this;
    }

    public CFMetaData keyAliases(List<ByteBuffer> prop) {
        this.keyAliases = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData columnAliases(List<ByteBuffer> prop) {
        this.columnAliases = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData valueAlias(ByteBuffer prop) {
        this.valueAlias = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData columnMetadata(Map<ByteBuffer, ColumnDefinition> prop) {
        this.column_metadata = prop;
        this.updateCfDef();
        return this;
    }

    public CFMetaData compactionStrategyClass(Class<? extends AbstractCompactionStrategy> prop) {
        this.compactionStrategyClass = prop;
        return this;
    }

    public CFMetaData compactionStrategyOptions(Map<String, String> prop) {
        this.compactionStrategyOptions = prop;
        return this;
    }

    public CFMetaData compressionParameters(CompressionParameters prop) {
        this.compressionParameters = prop;
        return this;
    }

    public CFMetaData bloomFilterFpChance(Double prop) {
        this.bloomFilterFpChance = prop;
        return this;
    }

    public CFMetaData caching(Caching prop) {
        this.caching = prop;
        return this;
    }

    public CFMetaData defaultReadCL(ConsistencyLevel prop) {
        this.readConsistencyLevel = prop;
        return this;
    }

    public CFMetaData defaultWriteCL(ConsistencyLevel prop) {
        this.writeConsistencyLevel = prop;
        return this;
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType<?> comp, AbstractType<?> subcc) {
        this(keyspace, name, type, comp, subcc, CFMetaData.getId(keyspace, name));
    }

    CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType<?> comp, AbstractType<?> subcc, UUID id) {
        this.ksName = keyspace;
        this.cfName = name;
        this.cfType = type;
        this.comparator = comp;
        this.subcolumnComparator = this.enforceSubccDefault(type, subcc);
        this.cfId = id;
        this.init();
    }

    private static CFMetaData compile(int id, String cql, String keyspace) {
        try {
            CreateColumnFamilyStatement statement = (CreateColumnFamilyStatement)QueryProcessor.parseStatement((String)cql).prepare().statement;
            CFMetaData cfmd = CFMetaData.newSystemMetadata(keyspace, statement.columnFamily(), id, "", statement.comparator, null);
            statement.applyPropertiesTo(cfmd);
            return cfmd;
        }
        catch (RequestValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static CFMetaData compile(int id, String cql) {
        return CFMetaData.compile(id, cql, "system");
    }

    private AbstractType<?> enforceSubccDefault(ColumnFamilyType cftype, AbstractType<?> subcc) {
        return subcc == null && cftype == ColumnFamilyType.Super ? BytesType.instance : subcc;
    }

    private static String enforceCommentNotNull(CharSequence comment) {
        return comment == null ? "" : ((Object)comment).toString();
    }

    static UUID getId(String ksName, String cfName) {
        return UUID.nameUUIDFromBytes(ArrayUtils.addAll((byte[])ksName.getBytes(), (byte[])cfName.getBytes()));
    }

    private void init() {
        this.readRepairChance = 0.1;
        this.dcLocalReadRepairChance = 0.0;
        this.replicateOnWrite = true;
        this.gcGraceSeconds = 864000;
        this.minCompactionThreshold = 4;
        this.maxCompactionThreshold = 32;
        this.caching = DEFAULT_CACHING_STRATEGY;
        this.defaultValidator = BytesType.instance;
        this.keyValidator = BytesType.instance;
        this.comment = "";
        this.valueAlias = null;
        this.column_metadata = new HashMap<ByteBuffer, ColumnDefinition>();
        try {
            this.compactionStrategyClass = CFMetaData.createCompactionStrategy(DEFAULT_COMPACTION_STRATEGY_CLASS);
        }
        catch (ConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        this.compactionStrategyOptions = new HashMap<String, String>();
        this.compressionParameters = new CompressionParameters(null);
        this.updateCfDef();
    }

    private static CFMetaData newSystemMetadata(String keyspace, String cfName, int oldCfId, String comment, AbstractType<?> comparator, AbstractType<?> subcc) {
        ColumnFamilyType type = subcc == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super;
        CFMetaData newCFMD = new CFMetaData(keyspace, cfName, type, comparator, subcc);
        Schema.instance.addOldCfIdMapping(oldCfId, newCFMD.cfId);
        return newCFMD.comment(comment).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0);
    }

    public static CFMetaData newIndexMetadata(CFMetaData parent, ColumnDefinition info, AbstractType<?> columnComparator) {
        Caching indexCaching = parent.getCaching() == Caching.ALL || parent.getCaching() == Caching.KEYS_ONLY ? Caching.KEYS_ONLY : Caching.NONE;
        return new CFMetaData(parent.ksName, parent.indexColumnFamilyName(info), ColumnFamilyType.Standard, columnComparator, null).keyValidator(info.getValidator()).readRepairChance(0.0).dcLocalReadRepairChance(0.0).gcGraceSeconds(0).caching(indexCaching).compactionStrategyClass(parent.compactionStrategyClass).compactionStrategyOptions(parent.compactionStrategyOptions).reloadSecondaryIndexMetadata(parent);
    }

    public CFMetaData reloadSecondaryIndexMetadata(CFMetaData parent) {
        this.minCompactionThreshold(parent.minCompactionThreshold);
        this.maxCompactionThreshold(parent.maxCompactionThreshold);
        this.compactionStrategyClass(parent.compactionStrategyClass);
        this.compactionStrategyOptions(parent.compactionStrategyOptions);
        this.compressionParameters(parent.compressionParameters);
        return this;
    }

    public CFMetaData clone() {
        return CFMetaData.copyOpts(new CFMetaData(this.ksName, this.cfName, this.cfType, this.comparator, this.subcolumnComparator, this.cfId), this);
    }

    public static CFMetaData rename(CFMetaData cfm, String newName) {
        return CFMetaData.copyOpts(new CFMetaData(cfm.ksName, newName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.cfId), cfm);
    }

    static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        HashMap<ByteBuffer, ColumnDefinition> clonedColumns = new HashMap<ByteBuffer, ColumnDefinition>();
        for (ColumnDefinition cd : oldCFMD.column_metadata.values()) {
            ColumnDefinition cloned = cd.clone();
            clonedColumns.put(cloned.name, cloned);
        }
        return newCFMD.comment(oldCFMD.comment).readRepairChance(oldCFMD.readRepairChance).dcLocalReadRepairChance(oldCFMD.dcLocalReadRepairChance).replicateOnWrite(oldCFMD.replicateOnWrite).gcGraceSeconds(oldCFMD.gcGraceSeconds).defaultValidator(oldCFMD.defaultValidator).keyValidator(oldCFMD.keyValidator).minCompactionThreshold(oldCFMD.minCompactionThreshold).maxCompactionThreshold(oldCFMD.maxCompactionThreshold).keyAliases(new ArrayList<ByteBuffer>(oldCFMD.keyAliases)).columnAliases(new ArrayList<ByteBuffer>(oldCFMD.columnAliases)).valueAlias(oldCFMD.valueAlias).columnMetadata(clonedColumns).compactionStrategyClass(oldCFMD.compactionStrategyClass).compactionStrategyOptions(oldCFMD.compactionStrategyOptions).compressionParameters(oldCFMD.compressionParameters).bloomFilterFpChance(oldCFMD.bloomFilterFpChance).caching(oldCFMD.caching).defaultReadCL(oldCFMD.readConsistencyLevel).defaultWriteCL(oldCFMD.writeConsistencyLevel);
    }

    public String indexColumnFamilyName(ColumnDefinition info) {
        return this.cfName + "." + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name) : info.getIndexName());
    }

    public String getComment() {
        return this.comment;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public double getDcLocalReadRepair() {
        return this.dcLocalReadRepairChance;
    }

    public boolean getReplicateOnWrite() {
        return this.replicateOnWrite;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType<?> getDefaultValidator() {
        return this.defaultValidator;
    }

    public AbstractType<?> getKeyValidator() {
        return this.keyValidator;
    }

    public Integer getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public Integer getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public ByteBuffer getKeyName() {
        if (this.keyAliases.size() > 1) {
            throw new IllegalStateException("Cannot acces column family with composite key from CQL < 3.0.0");
        }
        return this.keyAliases.isEmpty() ? DEFAULT_KEY_NAME : this.keyAliases.get(0);
    }

    public List<ByteBuffer> getKeyAliases() {
        return this.keyAliases;
    }

    public List<ByteBuffer> getColumnAliases() {
        return this.columnAliases;
    }

    public ByteBuffer getValueAlias() {
        return this.valueAlias;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.readConsistencyLevel == null ? ConsistencyLevel.ONE : this.readConsistencyLevel;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.writeConsistencyLevel == null ? ConsistencyLevel.ONE : this.writeConsistencyLevel;
    }

    public CompressionParameters compressionParameters() {
        return this.compressionParameters;
    }

    public Map<ByteBuffer, ColumnDefinition> getColumn_metadata() {
        return Collections.unmodifiableMap(this.column_metadata);
    }

    public AbstractType<?> getComparatorFor(ByteBuffer superColumnName) {
        return superColumnName == null ? this.comparator : this.subcolumnComparator;
    }

    public Double getBloomFilterFpChance() {
        return this.bloomFilterFpChance;
    }

    public Caching getCaching() {
        return this.caching;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CFMetaData rhs = (CFMetaData)obj;
        return new EqualsBuilder().append((Object)this.ksName, (Object)rhs.ksName).append((Object)this.cfName, (Object)rhs.cfName).append((Object)this.cfType, (Object)rhs.cfType).append(this.comparator, rhs.comparator).append(this.subcolumnComparator, rhs.subcolumnComparator).append((Object)this.comment, (Object)rhs.comment).append(this.readRepairChance, rhs.readRepairChance).append(this.dcLocalReadRepairChance, rhs.dcLocalReadRepairChance).append(this.replicateOnWrite, rhs.replicateOnWrite).append(this.gcGraceSeconds, rhs.gcGraceSeconds).append(this.defaultValidator, rhs.defaultValidator).append(this.keyValidator, rhs.keyValidator).append(this.minCompactionThreshold, rhs.minCompactionThreshold).append(this.maxCompactionThreshold, rhs.maxCompactionThreshold).append((Object)this.cfId, (Object)rhs.cfId).append(this.column_metadata, rhs.column_metadata).append(this.keyAliases, rhs.keyAliases).append(this.columnAliases, rhs.columnAliases).append((Object)this.valueAlias, (Object)rhs.valueAlias).append(this.compactionStrategyClass, rhs.compactionStrategyClass).append(this.compactionStrategyOptions, rhs.compactionStrategyOptions).append((Object)this.compressionParameters, (Object)rhs.compressionParameters).append((Object)this.bloomFilterFpChance, (Object)rhs.bloomFilterFpChance).append((Object)this.caching, (Object)rhs.caching).append((Object)this.readConsistencyLevel, (Object)rhs.readConsistencyLevel).append((Object)this.writeConsistencyLevel, (Object)rhs.writeConsistencyLevel).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.ksName).append((Object)this.cfName).append((Object)this.cfType).append(this.comparator).append(this.subcolumnComparator).append((Object)this.comment).append(this.readRepairChance).append(this.dcLocalReadRepairChance).append(this.replicateOnWrite).append(this.gcGraceSeconds).append(this.defaultValidator).append(this.keyValidator).append(this.minCompactionThreshold).append(this.maxCompactionThreshold).append((Object)this.cfId).append(this.column_metadata).append(this.keyAliases).append(this.columnAliases).append((Object)this.valueAlias).append(this.compactionStrategyClass).append(this.compactionStrategyOptions).append((Object)this.compressionParameters).append((Object)this.bloomFilterFpChance).append((Object)this.caching).append((Object)this.readConsistencyLevel).append((Object)this.writeConsistencyLevel).toHashCode();
    }

    public AbstractType<?> getValueValidator(ByteBuffer column) {
        return this.getValueValidator(this.column_metadata.get(column));
    }

    public AbstractType<?> getValueValidator(ColumnDefinition columnDefinition) {
        return columnDefinition == null ? this.defaultValidator : columnDefinition.getValidator();
    }

    public static void applyImplicitDefaults(CfDef cf_def) {
        if (!cf_def.isSetComment()) {
            cf_def.setComment("");
        }
        if (!cf_def.isSetReplicate_on_write()) {
            cf_def.setReplicate_on_write(true);
        }
        if (!cf_def.isSetMin_compaction_threshold()) {
            cf_def.setMin_compaction_threshold(4);
        }
        if (!cf_def.isSetMax_compaction_threshold()) {
            cf_def.setMax_compaction_threshold(32);
        }
        if (cf_def.compaction_strategy == null) {
            cf_def.compaction_strategy = DEFAULT_COMPACTION_STRATEGY_CLASS;
        }
        if (cf_def.compaction_strategy_options == null) {
            cf_def.compaction_strategy_options = Collections.emptyMap();
        }
        if (!cf_def.isSetCompression_options()) {
            cf_def.setCompression_options((Map)new HashMap<String, String>(){
                {
                    if (DEFAULT_COMPRESSOR != null) {
                        this.put("sstable_compression", DEFAULT_COMPRESSOR);
                    }
                }
            });
        }
        if (!cf_def.isSetDclocal_read_repair_chance()) {
            cf_def.setDclocal_read_repair_chance(0.0);
        }
    }

    public static CFMetaData fromThrift(CfDef cf_def) throws InvalidRequestException, ConfigurationException {
        ColumnFamilyType cfType = ColumnFamilyType.create(cf_def.column_type);
        if (cfType == null) {
            throw new InvalidRequestException("Invalid column type " + cf_def.column_type);
        }
        CFMetaData.applyImplicitDefaults(cf_def);
        try {
            CFMetaData newCFMD = new CFMetaData(cf_def.keyspace, cf_def.name, cfType, TypeParser.parse(cf_def.comparator_type), cf_def.subcomparator_type == null ? null : TypeParser.parse(cf_def.subcomparator_type));
            if (cf_def.isSetGc_grace_seconds()) {
                newCFMD.gcGraceSeconds(cf_def.gc_grace_seconds);
            }
            if (cf_def.isSetMin_compaction_threshold()) {
                newCFMD.minCompactionThreshold(cf_def.min_compaction_threshold);
            }
            if (cf_def.isSetMax_compaction_threshold()) {
                newCFMD.maxCompactionThreshold(cf_def.max_compaction_threshold);
            }
            if (cf_def.isSetKey_alias()) {
                newCFMD.keyAliases(Collections.singletonList(cf_def.key_alias));
            }
            if (cf_def.isSetKey_validation_class()) {
                newCFMD.keyValidator(TypeParser.parse(cf_def.key_validation_class));
            }
            if (cf_def.isSetCompaction_strategy()) {
                newCFMD.compactionStrategyClass = CFMetaData.createCompactionStrategy(cf_def.compaction_strategy);
            }
            if (cf_def.isSetCompaction_strategy_options()) {
                newCFMD.compactionStrategyOptions(new HashMap<String, String>(cf_def.compaction_strategy_options));
            }
            if (cf_def.isSetBloom_filter_fp_chance()) {
                newCFMD.bloomFilterFpChance(cf_def.bloom_filter_fp_chance);
            }
            if (cf_def.isSetCaching()) {
                newCFMD.caching(Caching.fromString(cf_def.caching));
            }
            if (cf_def.isSetRead_repair_chance()) {
                newCFMD.readRepairChance(cf_def.read_repair_chance);
            }
            if (cf_def.isSetDclocal_read_repair_chance()) {
                newCFMD.dcLocalReadRepairChance(cf_def.dclocal_read_repair_chance);
            }
            CompressionParameters cp = CompressionParameters.create(cf_def.compression_options);
            return newCFMD.comment(cf_def.comment).replicateOnWrite(cf_def.replicate_on_write).defaultValidator(TypeParser.parse(cf_def.default_validation_class)).keyValidator(TypeParser.parse(cf_def.key_validation_class)).columnMetadata(ColumnDefinition.fromThrift(cf_def.column_metadata)).compressionParameters(cp);
        }
        catch (SyntaxException e) {
            throw new ConfigurationException(e.getMessage());
        }
        catch (MarshalException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    public void reload() {
        Row cfDefRow = SystemTable.readSchemaRow(this.ksName, this.cfName);
        if (cfDefRow.cf == null || cfDefRow.cf.isEmpty()) {
            throw new RuntimeException(String.format("%s not found in the schema definitions table.", this.ksName + ":" + this.cfName));
        }
        try {
            this.apply(CFMetaData.fromSchema(cfDefRow));
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public void apply(CFMetaData cfm) throws ConfigurationException {
        logger.debug("applying {} to {}", (Object)cfm, (Object)this);
        if (!cfm.ksName.equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cfm.ksName, this.ksName));
        }
        if (!cfm.cfName.equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cfm.cfName, this.cfName));
        }
        if (!cfm.cfId.equals(this.cfId)) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cfm.cfId, this.cfId));
        }
        if (!cfm.cfType.equals((Object)this.cfType)) {
            throw new ConfigurationException("types do not match.");
        }
        if (!cfm.comparator.isCompatibleWith(this.comparator)) {
            throw new ConfigurationException("comparators do not match or are not compatible.");
        }
        if (cfm.subcolumnComparator == null) {
            if (this.subcolumnComparator != null) {
                throw new ConfigurationException("subcolumncomparators do not match.");
            }
        } else if (!cfm.subcolumnComparator.isCompatibleWith(this.subcolumnComparator)) {
            throw new ConfigurationException("subcolumncomparators do not match or are note compatible.");
        }
        this.comparator = cfm.comparator;
        this.subcolumnComparator = cfm.subcolumnComparator;
        this.comment = CFMetaData.enforceCommentNotNull(cfm.comment);
        this.readRepairChance = cfm.readRepairChance;
        this.dcLocalReadRepairChance = cfm.dcLocalReadRepairChance;
        this.replicateOnWrite = cfm.replicateOnWrite;
        this.gcGraceSeconds = cfm.gcGraceSeconds;
        this.defaultValidator = cfm.defaultValidator;
        this.keyValidator = cfm.keyValidator;
        this.minCompactionThreshold = cfm.minCompactionThreshold;
        this.maxCompactionThreshold = cfm.maxCompactionThreshold;
        if (!cfm.keyAliases.isEmpty()) {
            if (this.keyAliases.size() != cfm.keyAliases.size()) {
                throw new ConfigurationException("Cannot change the number of key aliases");
            }
            this.keyAliases = cfm.keyAliases;
        }
        if (!cfm.columnAliases.isEmpty()) {
            if (this.columnAliases.size() != cfm.columnAliases.size()) {
                throw new ConfigurationException("Cannot change the number of column aliases");
            }
            this.columnAliases = cfm.columnAliases;
        }
        if (cfm.valueAlias != null) {
            this.valueAlias = cfm.valueAlias;
        }
        if (cfm.readConsistencyLevel != null) {
            this.readConsistencyLevel = cfm.readConsistencyLevel;
        }
        if (cfm.writeConsistencyLevel != null) {
            this.writeConsistencyLevel = cfm.writeConsistencyLevel;
        }
        this.bloomFilterFpChance = cfm.bloomFilterFpChance;
        this.caching = cfm.caching;
        MapDifference columnDiff = Maps.difference(this.column_metadata, cfm.column_metadata);
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnLeft().values()) {
            this.column_metadata.remove(cd.name);
        }
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnRight().values()) {
            this.column_metadata.put(cd.name, cd);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition oldDef = this.column_metadata.get(name);
            ColumnDefinition def = cfm.column_metadata.get(name);
            oldDef.apply(def, this.getColumnDefinitionComparator(oldDef));
        }
        this.compactionStrategyClass = cfm.compactionStrategyClass;
        this.compactionStrategyOptions = cfm.compactionStrategyOptions;
        this.compressionParameters = cfm.compressionParameters();
        this.updateCfDef();
        logger.debug("application result is {}", (Object)this);
    }

    public static Class<? extends AbstractCompactionStrategy> createCompactionStrategy(String className) throws ConfigurationException {
        className = className.contains(".") ? className : "org.apache.cassandra.db.compaction." + className;
        return FBUtilities.classForName(className, "compaction strategy");
    }

    public AbstractCompactionStrategy createCompactionStrategyInstance(ColumnFamilyStore cfs) {
        try {
            Constructor<? extends AbstractCompactionStrategy> constructor = this.compactionStrategyClass.getConstructor(ColumnFamilyStore.class, Map.class);
            return constructor.newInstance(cfs, this.compactionStrategyOptions);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CfDef toThrift() {
        CfDef def = new CfDef(this.ksName, this.cfName);
        def.setColumn_type(this.cfType.name());
        def.setComparator_type(this.comparator.toString());
        if (this.subcolumnComparator != null) {
            assert (this.cfType == ColumnFamilyType.Super) : String.format("%s CF %s should not have subcomparator %s defined", new Object[]{this.cfType, this.cfName, this.subcolumnComparator});
            def.setSubcomparator_type(this.subcolumnComparator.toString());
        }
        def.setComment(CFMetaData.enforceCommentNotNull(this.comment));
        def.setRead_repair_chance(this.readRepairChance);
        def.setDclocal_read_repair_chance(this.dcLocalReadRepairChance);
        def.setReplicate_on_write(this.replicateOnWrite);
        def.setGc_grace_seconds(this.gcGraceSeconds);
        def.setDefault_validation_class(this.defaultValidator == null ? null : this.defaultValidator.toString());
        def.setKey_validation_class(this.keyValidator.toString());
        def.setMin_compaction_threshold(this.minCompactionThreshold);
        def.setMax_compaction_threshold(this.maxCompactionThreshold);
        if (this.keyAliases.size() == 1) {
            def.setKey_alias(this.keyAliases.get(0));
        }
        ArrayList<ColumnDef> column_meta = new ArrayList<ColumnDef>(this.column_metadata.size());
        for (ColumnDefinition cd : this.column_metadata.values()) {
            column_meta.add(cd.toThrift());
        }
        def.setColumn_metadata(column_meta);
        def.setCompaction_strategy(this.compactionStrategyClass.getName());
        def.setCompaction_strategy_options(new HashMap<String, String>(this.compactionStrategyOptions));
        def.setCompression_options(this.compressionParameters.asThriftOptions());
        if (this.bloomFilterFpChance != null) {
            def.setBloom_filter_fp_chance(this.bloomFilterFpChance.doubleValue());
        }
        def.setCaching(this.caching.toString());
        return def;
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.column_metadata.get(name);
    }

    public ColumnDefinition getColumnDefinitionForIndex(String indexName) {
        for (ColumnDefinition def : this.column_metadata.values()) {
            if (!indexName.equals(def.getIndexName())) continue;
            return def;
        }
        return null;
    }

    public void addDefaultIndexNames() throws ConfigurationException {
        UUID cfId = Schema.instance.getId(this.ksName, this.cfName);
        if (cfId != null) {
            CFMetaData cfm = Schema.instance.getCFMetaData(cfId);
            for (Map.Entry entry : this.column_metadata.entrySet()) {
                String oldIndexName;
                ColumnDefinition newDef = (ColumnDefinition)entry.getValue();
                if (!cfm.column_metadata.containsKey(entry.getKey()) || newDef.getIndexType() == null || (oldIndexName = cfm.column_metadata.get(entry.getKey()).getIndexName()) == null) continue;
                if (newDef.getIndexName() != null && !oldIndexName.equals(newDef.getIndexName())) {
                    throw new ConfigurationException("Can't modify index name: was '" + oldIndexName + "' changed to '" + newDef.getIndexName() + "'.");
                }
                newDef.setIndexName(oldIndexName);
            }
        }
        Set<String> existingNames = CFMetaData.existingIndexNames(null);
        for (ColumnDefinition columnDefinition : this.column_metadata.values()) {
            String baseName;
            if (columnDefinition.getIndexType() == null || columnDefinition.getIndexName() != null) continue;
            String indexName = baseName = CFMetaData.getDefaultIndexName(this.cfName, this.getColumnDefinitionComparator(columnDefinition), columnDefinition.name);
            int i = 0;
            while (existingNames.contains(indexName)) {
                indexName = baseName + '_' + ++i;
            }
            columnDefinition.setIndexName(indexName);
        }
    }

    public static String getDefaultIndexName(String cfName, AbstractType<?> comparator, ByteBuffer columnName) {
        return (cfName + "_" + comparator.getString(columnName) + "_idx").replaceAll("\\W", "");
    }

    public IColumnSerializer getColumnSerializer() {
        if (this.cfType == ColumnFamilyType.Standard) {
            return Column.serializer();
        }
        return SuperColumn.serializer(this.subcolumnComparator);
    }

    public OnDiskAtom.Serializer getOnDiskSerializer() {
        if (this.cfType == ColumnFamilyType.Standard) {
            return Column.onDiskSerializer();
        }
        return SuperColumn.onDiskSerializer(this.subcolumnComparator);
    }

    public static boolean isNameValid(String name) {
        return name != null && !name.isEmpty() && name.length() <= 48 && name.matches("\\w+");
    }

    public static boolean isIndexNameValid(String name) {
        return name != null && !name.isEmpty() && name.matches("\\w+");
    }

    public CFMetaData validate() throws ConfigurationException {
        if (!CFMetaData.isNameValid(this.ksName)) {
            throw new ConfigurationException(String.format("Invalid keyspace name: shouldn't be empty nor more than %s characters long (got \"%s\")", 48, this.ksName));
        }
        if (!CFMetaData.isNameValid(this.cfName)) {
            throw new ConfigurationException(String.format("Invalid keyspace name: shouldn't be empty nor more than %s characters long (got \"%s\")", 48, this.cfName));
        }
        if (this.cfType == null) {
            throw new ConfigurationException(String.format("Invalid column family type for %s", this.cfName));
        }
        if (this.cfType == ColumnFamilyType.Super) {
            if (this.subcolumnComparator == null) {
                throw new ConfigurationException(String.format("Missing subcolumn comparator for super column family %s", this.cfName));
            }
        } else if (this.subcolumnComparator != null) {
            throw new ConfigurationException(String.format("Subcolumn comparator (%s) is invalid for standard column family %s", this.subcolumnComparator, this.cfName));
        }
        if (this.comparator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid comparator");
        }
        if (this.subcolumnComparator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid sub-column comparator");
        }
        if (this.keyValidator instanceof CounterColumnType) {
            throw new ConfigurationException("CounterColumnType is not a valid key validator");
        }
        if (this.defaultValidator instanceof CounterColumnType) {
            for (ColumnDefinition def : this.column_metadata.values()) {
                if (def.getValidator() instanceof CounterColumnType) continue;
                throw new ConfigurationException("Cannot add a non counter column (" + this.comparator.getString(def.name) + ") in a counter column family");
            }
        } else {
            for (ColumnDefinition def : this.column_metadata.values()) {
                if (!(def.getValidator() instanceof CounterColumnType)) continue;
                throw new ConfigurationException("Cannot add a counter column (" + this.comparator.getString(def.name) + ") in a non counter column family");
            }
        }
        for (ColumnDefinition columndef : this.column_metadata.values()) {
            for (ByteBuffer alias : this.keyAliases) {
                if (!alias.equals(columndef.name)) continue;
                throw new ConfigurationException("Cannot have key alias equals to a column name: " + UTF8Type.instance.compose(alias));
            }
            for (ByteBuffer alias : this.columnAliases) {
                if (!alias.equals(columndef.name)) continue;
                throw new ConfigurationException("Cannot have column alias equals to a column name: " + UTF8Type.instance.compose(alias));
            }
            if (this.valueAlias == null || !this.valueAlias.equals(columndef.name)) continue;
            throw new ConfigurationException("Cannot have value alias equals to a column name: " + UTF8Type.instance.compose(this.valueAlias));
        }
        for (ByteBuffer alias : this.keyAliases) {
            CFMetaData.validateAlias(alias, "Key");
        }
        for (ByteBuffer alias : this.columnAliases) {
            CFMetaData.validateAlias(alias, "Column");
        }
        CFMetaData.validateAlias(this.valueAlias, "Value");
        Set<String> indexNames = CFMetaData.existingIndexNames(this.cfName);
        for (ColumnDefinition c : this.column_metadata.values()) {
            AbstractType<?> comparator = this.getColumnDefinitionComparator(c);
            try {
                comparator.validate(c.name);
            }
            catch (MarshalException e) {
                throw new ConfigurationException(String.format("Column name %s is not valid for comparator %s", ByteBufferUtil.bytesToHex(c.name), comparator));
            }
            if (c.getIndexType() == null) {
                if (c.getIndexName() == null) continue;
                throw new ConfigurationException("Index name cannot be set without index type");
            }
            if (this.cfType == ColumnFamilyType.Super) {
                throw new ConfigurationException("Secondary indexes are not supported on super column families");
            }
            if (!CFMetaData.isIndexNameValid(c.getIndexName())) {
                throw new ConfigurationException("Illegal index name " + c.getIndexName());
            }
            if (indexNames.contains(c.getIndexName())) {
                throw new ConfigurationException("Duplicate index name " + c.getIndexName());
            }
            indexNames.add(c.getIndexName());
            if (!(c.getIndexType() != IndexType.CUSTOM || c.getIndexOptions() != null && c.getIndexOptions().containsKey("class_name"))) {
                throw new ConfigurationException("Required index option missing: class_name");
            }
            SecondaryIndex.createInstance(null, c);
        }
        this.validateCompactionThresholds();
        return this;
    }

    private static Set<String> existingIndexNames(String cfToExclude) {
        HashSet<String> indexNames = new HashSet<String>();
        for (ColumnFamilyStore cfs : ColumnFamilyStore.all()) {
            if (cfToExclude != null && cfs.getColumnFamilyName().equals(cfToExclude)) continue;
            for (ColumnDefinition cd : cfs.metadata.getColumn_metadata().values()) {
                indexNames.add(cd.getIndexName());
            }
        }
        return indexNames;
    }

    private static void validateAlias(ByteBuffer alias, String msg) throws ConfigurationException {
        if (alias != null) {
            try {
                UTF8Type.instance.validate(alias);
            }
            catch (MarshalException e) {
                throw new ConfigurationException(msg + " alias must be UTF8");
            }
        }
    }

    private void validateCompactionThresholds() throws ConfigurationException {
        if (this.maxCompactionThreshold == 0) {
            return;
        }
        if (this.minCompactionThreshold <= 1) {
            throw new ConfigurationException(String.format("Min compaction threshold cannot be less than 2 (got %d).", this.minCompactionThreshold));
        }
        if (this.minCompactionThreshold > this.maxCompactionThreshold) {
            throw new ConfigurationException(String.format("Min compaction threshold (got %d) cannot be greater than max compaction threshold (got %d)", this.minCompactionThreshold, this.maxCompactionThreshold));
        }
    }

    public RowMutation toSchemaUpdate(CFMetaData newState, long modificationTimestamp) {
        RowMutation rm = new RowMutation("system", SystemTable.getSchemaKSKey(this.ksName));
        newState.toSchemaNoColumns(rm, modificationTimestamp);
        MapDifference columnDiff = Maps.difference(this.column_metadata, newState.column_metadata);
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnLeft().values()) {
            cd.deleteFromSchema(rm, this.cfName, this.getColumnDefinitionComparator(cd), modificationTimestamp);
        }
        for (ColumnDefinition cd : columnDiff.entriesOnlyOnRight().values()) {
            cd.toSchema(rm, this.cfName, this.getColumnDefinitionComparator(cd), modificationTimestamp);
        }
        for (ByteBuffer name : columnDiff.entriesDiffering().keySet()) {
            ColumnDefinition cd = newState.getColumnDefinition(name);
            cd.toSchema(rm, this.cfName, this.getColumnDefinitionComparator(cd), modificationTimestamp);
        }
        return rm;
    }

    public RowMutation dropFromSchema(long timestamp) {
        RowMutation rm = new RowMutation("system", SystemTable.getSchemaKSKey(this.ksName));
        ColumnFamily cf = rm.addOrGet("schema_columnfamilies");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "id"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "type"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "comparator"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "subcomparator"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "comment"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "read_repair_chance"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "local_read_repair_chance"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "replicate_on_write"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "gc_grace_seconds"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "default_validator"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "key_validator"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "min_compaction_threshold"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "max_compaction_threshold"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "key_alias"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "key_aliases"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "bloom_filter_fp_chance"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "caching"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "compaction_strategy_class"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "compression_parameters"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "value_alias"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "column_aliases"));
        cf.addColumn(DeletedColumn.create(ldt, timestamp, this.cfName, "compaction_strategy_options"));
        for (ColumnDefinition cd : this.column_metadata.values()) {
            cd.deleteFromSchema(rm, this.cfName, this.getColumnDefinitionComparator(cd), timestamp);
        }
        return rm;
    }

    public void toSchema(RowMutation rm, long timestamp) {
        this.toSchemaNoColumns(rm, timestamp);
        for (ColumnDefinition cd : this.column_metadata.values()) {
            cd.toSchema(rm, this.cfName, this.getColumnDefinitionComparator(cd), timestamp);
        }
    }

    private void toSchemaNoColumns(RowMutation rm, long timestamp) {
        ColumnFamily cf = rm.addOrGet("schema_columnfamilies");
        int ldt = (int)(System.currentTimeMillis() / 1000L);
        Integer oldId = Schema.instance.convertNewCfId(this.cfId);
        if (oldId != null) {
            cf.addColumn(Column.create(oldId, timestamp, this.cfName, "id"));
        }
        cf.addColumn(Column.create(this.cfType.toString(), timestamp, this.cfName, "type"));
        cf.addColumn(Column.create(this.comparator.toString(), timestamp, this.cfName, "comparator"));
        if (this.subcolumnComparator != null) {
            cf.addColumn(Column.create(this.subcolumnComparator.toString(), timestamp, this.cfName, "subcomparator"));
        }
        cf.addColumn(this.comment == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "comment") : Column.create(this.comment, timestamp, this.cfName, "comment"));
        cf.addColumn(Column.create(this.readRepairChance, timestamp, this.cfName, "read_repair_chance"));
        cf.addColumn(Column.create(this.dcLocalReadRepairChance, timestamp, this.cfName, "local_read_repair_chance"));
        cf.addColumn(Column.create(this.replicateOnWrite, timestamp, this.cfName, "replicate_on_write"));
        cf.addColumn(Column.create(this.gcGraceSeconds, timestamp, this.cfName, "gc_grace_seconds"));
        cf.addColumn(Column.create(this.defaultValidator.toString(), timestamp, this.cfName, "default_validator"));
        cf.addColumn(Column.create(this.keyValidator.toString(), timestamp, this.cfName, "key_validator"));
        cf.addColumn(Column.create(this.minCompactionThreshold, timestamp, this.cfName, "min_compaction_threshold"));
        cf.addColumn(Column.create(this.maxCompactionThreshold, timestamp, this.cfName, "max_compaction_threshold"));
        cf.addColumn(Column.create(FBUtilities.json(this.aliasesAsStrings(this.keyAliases)), timestamp, this.cfName, "key_aliases"));
        cf.addColumn(this.bloomFilterFpChance == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "bloomFilterFpChance") : Column.create(this.bloomFilterFpChance, timestamp, this.cfName, "bloom_filter_fp_chance"));
        cf.addColumn(Column.create(this.caching.toString(), timestamp, this.cfName, "caching"));
        cf.addColumn(Column.create(this.compactionStrategyClass.getName(), timestamp, this.cfName, "compaction_strategy_class"));
        cf.addColumn(Column.create(FBUtilities.json(this.compressionParameters.asThriftOptions()), timestamp, this.cfName, "compression_parameters"));
        cf.addColumn(this.valueAlias == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "value_alias") : Column.create(this.valueAlias, timestamp, this.cfName, "value_alias"));
        cf.addColumn(Column.create(FBUtilities.json(this.aliasesAsStrings(this.columnAliases)), timestamp, this.cfName, "column_aliases"));
        cf.addColumn(Column.create(FBUtilities.json(this.compactionStrategyOptions), timestamp, this.cfName, "compaction_strategy_options"));
        cf.addColumn(this.readConsistencyLevel == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "default_read_consistency") : Column.create(this.readConsistencyLevel.toString(), timestamp, this.cfName, "default_read_consistency"));
        cf.addColumn(this.writeConsistencyLevel == null ? DeletedColumn.create(ldt, timestamp, this.cfName, "default_write_consistency") : Column.create(this.writeConsistencyLevel.toString(), timestamp, this.cfName, "default_write_consistency"));
    }

    static CFMetaData fromSchemaNoColumns(UntypedResultSet.Row result) {
        try {
            CFMetaData cfm = new CFMetaData(result.getString("keyspace_name"), result.getString("columnfamily_name"), ColumnFamilyType.valueOf(result.getString("type")), TypeParser.parse(result.getString("comparator")), result.has("subcomparator") ? TypeParser.parse(result.getString("subcomparator")) : null);
            if (result.has("id")) {
                Schema.instance.addOldCfIdMapping(result.getInt("id"), cfm.cfId);
            }
            cfm.readRepairChance(result.getDouble("read_repair_chance"));
            cfm.dcLocalReadRepairChance(result.getDouble("local_read_repair_chance"));
            cfm.replicateOnWrite(result.getBoolean("replicate_on_write"));
            cfm.gcGraceSeconds(result.getInt("gc_grace_seconds"));
            cfm.defaultValidator(TypeParser.parse(result.getString("default_validator")));
            cfm.keyValidator(TypeParser.parse(result.getString("key_validator")));
            cfm.minCompactionThreshold(result.getInt("min_compaction_threshold"));
            cfm.maxCompactionThreshold(result.getInt("max_compaction_threshold"));
            if (result.has("comment")) {
                cfm.comment(result.getString("comment"));
            }
            if (result.has("key_aliases")) {
                cfm.keyAliases(CFMetaData.aliasesFromStrings(FBUtilities.fromJsonList(result.getString("key_aliases"))));
            } else if (result.has("key_alias")) {
                cfm.keyAliases(Collections.singletonList(result.getBytes("key_alias")));
            }
            if (result.has("bloom_filter_fp_chance")) {
                cfm.bloomFilterFpChance(result.getDouble("bloom_filter_fp_chance"));
            }
            cfm.caching(Caching.valueOf(result.getString("caching")));
            cfm.compactionStrategyClass(CFMetaData.createCompactionStrategy(result.getString("compaction_strategy_class")));
            cfm.compressionParameters(CompressionParameters.create(FBUtilities.fromJsonMap(result.getString("compression_parameters"))));
            cfm.columnAliases(CFMetaData.aliasesFromStrings(FBUtilities.fromJsonList(result.getString("column_aliases"))));
            if (result.has("value_alias")) {
                cfm.valueAlias(result.getBytes("value_alias"));
            }
            cfm.compactionStrategyOptions(FBUtilities.fromJsonMap(result.getString("compaction_strategy_options")));
            if (result.has("default_read_consistency")) {
                cfm.defaultReadCL(Enum.valueOf(ConsistencyLevel.class, result.getString("default_read_consistency")));
            }
            if (result.has("default_write_consistency")) {
                cfm.defaultWriteCL(Enum.valueOf(ConsistencyLevel.class, result.getString("default_write_consistency")));
            }
            return cfm;
        }
        catch (SyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static CFMetaData fromSchema(UntypedResultSet.Row result) {
        CFMetaData cfDef = CFMetaData.fromSchemaNoColumns(result);
        Row serializedColumnDefinitions = ColumnDefinition.readSchema(cfDef.ksName, cfDef.cfName);
        return CFMetaData.addColumnDefinitionSchema(cfDef, serializedColumnDefinitions).updateCfDef();
    }

    private static CFMetaData fromSchema(Row row) {
        UntypedResultSet.Row result = QueryProcessor.resultify("SELECT * FROM system.schema_columnfamilies", row).one();
        return CFMetaData.fromSchema(result);
    }

    private List<String> aliasesAsStrings(List<ByteBuffer> rawAliases) {
        ArrayList<String> aliases = new ArrayList<String>(rawAliases.size());
        for (ByteBuffer rawAlias : rawAliases) {
            aliases.add(UTF8Type.instance.compose(rawAlias));
        }
        return aliases;
    }

    private static List<ByteBuffer> aliasesFromStrings(List<String> aliases) {
        ArrayList<ByteBuffer> rawAliases = new ArrayList<ByteBuffer>(aliases.size());
        for (String alias : aliases) {
            rawAliases.add(UTF8Type.instance.decompose(alias));
        }
        return rawAliases;
    }

    public RowMutation toSchema(long timestamp) throws ConfigurationException {
        RowMutation rm = new RowMutation("system", SystemTable.getSchemaKSKey(this.ksName));
        this.toSchema(rm, timestamp);
        return rm;
    }

    public AbstractType<?> getColumnDefinitionComparator(ColumnDefinition def) {
        return this.getColumnDefinitionComparator(def.componentIndex);
    }

    public AbstractType<?> getColumnDefinitionComparator(Integer componentIndex) {
        AbstractType<?> cfComparator;
        AbstractType<?> abstractType = cfComparator = this.cfType == ColumnFamilyType.Super ? this.subcolumnComparator : this.comparator;
        if (cfComparator instanceof CompositeType) {
            if (componentIndex == null) {
                return cfComparator;
            }
            List<AbstractType<?>> types = ((CompositeType)cfComparator).types;
            AbstractType<?> t = types.get(componentIndex);
            assert (t != null) : "Non-sensical component index";
            return t;
        }
        return cfComparator;
    }

    static CFMetaData addColumnDefinitionSchema(CFMetaData cfDef, Row serializedColumnDefinitions) {
        for (ColumnDefinition cd : ColumnDefinition.fromSchema(serializedColumnDefinitions, cfDef)) {
            cfDef.column_metadata.put(cd.name, cd);
        }
        return cfDef;
    }

    public void addColumnDefinition(ColumnDefinition def) {
        this.column_metadata.put(def.name, def);
    }

    public boolean removeColumnDefinition(ColumnDefinition def) {
        return this.column_metadata.remove(def.name) != null;
    }

    private CFMetaData updateCfDef() {
        this.cqlCfDef = new CFDefinition(this);
        return this;
    }

    public CFDefinition getCfDef() {
        assert (this.cqlCfDef != null);
        return this.cqlCfDef;
    }

    public boolean isThriftIncompatible() {
        if (!this.cqlCfDef.isComposite) {
            return false;
        }
        for (ColumnDefinition columnDef : this.column_metadata.values()) {
            if (columnDef.componentIndex == null) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("cfType", (Object)this.cfType).append("comparator", this.comparator).append("subcolumncomparator", this.subcolumnComparator).append("comment", (Object)this.comment).append("readRepairChance", this.readRepairChance).append("dclocalReadRepairChance", this.dcLocalReadRepairChance).append("replicateOnWrite", this.replicateOnWrite).append("gcGraceSeconds", this.gcGraceSeconds).append("defaultValidator", this.defaultValidator).append("keyValidator", this.keyValidator).append("minCompactionThreshold", this.minCompactionThreshold).append("maxCompactionThreshold", this.maxCompactionThreshold).append("keyAliases", this.keyAliases).append("columnAliases", this.columnAliases).append("valueAlias", (Object)this.valueAlias).append("column_metadata", this.column_metadata).append("compactionStrategyClass", this.compactionStrategyClass).append("compactionStrategyOptions", this.compactionStrategyOptions).append("compressionOptions", this.compressionParameters.asThriftOptions()).append("bloomFilterFpChance", (Object)this.bloomFilterFpChance).append("caching", (Object)this.caching).append("readConsistencyLevel", (Object)this.readConsistencyLevel).append("writeConsistencyLevel", (Object)this.writeConsistencyLevel).toString();
    }

    public static enum Caching {
        ALL,
        KEYS_ONLY,
        ROWS_ONLY,
        NONE;


        public static Caching fromString(String cache) throws ConfigurationException {
            try {
                return Caching.valueOf(cache.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new ConfigurationException(String.format("%s not found, available types: %s.", cache, StringUtils.join((Object[])Caching.values(), (String)", ")));
            }
        }
    }
}

