/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.db.AtomicSortedColumns;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.ThreadSafeSortedColumns;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.columniterator.SimpleAbstractColumnIterator;
import org.apache.cassandra.db.commitlog.ReplayPosition;
import org.apache.cassandra.db.filter.AbstractColumnIterator;
import org.apache.cassandra.db.filter.NamesQueryFilter;
import org.apache.cassandra.db.filter.SliceQueryFilter;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SlabAllocator;
import org.apache.cassandra.utils.WrappedRunnable;
import org.cliffc.high_scale_lib.NonBlockingHashSet;
import org.github.jamm.MemoryMeter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Memtable {
    private static final Logger logger = LoggerFactory.getLogger(Memtable.class);
    private static final double MIN_SANE_LIVE_RATIO = 1.0;
    private static final double MAX_SANE_LIVE_RATIO = 64.0;
    private static final Set<ColumnFamilyStore> meteringInProgress = new NonBlockingHashSet();
    private static final ExecutorService meterExecutor = new DebuggableThreadPoolExecutor(1, 1, (long)Integer.MAX_VALUE, TimeUnit.MILLISECONDS, (BlockingQueue)new LinkedBlockingQueue(), (ThreadFactory)new NamedThreadFactory("MemoryMeter")){

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            DebuggableThreadPoolExecutor.logExceptionsAfterExecute(r, t);
        }
    };
    private final MemoryMeter meter;
    static volatile Memtable activelyMeasuring;
    private volatile boolean isFrozen;
    private final AtomicLong currentSize = new AtomicLong(0L);
    private final AtomicLong currentOperations = new AtomicLong(0L);
    private final ConcurrentNavigableMap<RowPosition, ColumnFamily> columnFamilies = new ConcurrentSkipListMap<RowPosition, ColumnFamily>();
    public final ColumnFamilyStore cfs;
    private final long creationTime;
    private final SlabAllocator allocator = new SlabAllocator();
    private final Function<IColumn, IColumn> localCopyFunction = new Function<IColumn, IColumn>(){

        public IColumn apply(IColumn c) {
            return c.localCopy(Memtable.this.cfs, Memtable.this.allocator);
        }
    };

    public Memtable(ColumnFamilyStore cfs) {
        this.cfs = cfs;
        this.creationTime = System.currentTimeMillis();
        Callable<Set<Object>> provider = new Callable<Set<Object>>(){

            @Override
            public Set<Object> call() throws Exception {
                Set<Object> set = Collections.newSetFromMap(new IdentityHashMap());
                set.add(Memtable.this.cfs.metadata);
                return set;
            }
        };
        this.meter = new MemoryMeter().omitSharedBufferOverhead().withTrackerProvider((Callable)provider);
    }

    public long getLiveSize() {
        return (long)((double)this.currentSize.get() * this.cfs.liveRatio * 1.25);
    }

    public long getSerializedSize() {
        return this.currentSize.get();
    }

    public long getOperations() {
        return this.currentOperations.get();
    }

    boolean isFrozen() {
        return this.isFrozen;
    }

    void freeze() {
        this.isFrozen = true;
    }

    void put(DecoratedKey key, ColumnFamily columnFamily) {
        assert (!this.isFrozen);
        this.resolve(key, columnFamily);
    }

    public void updateLiveRatio() throws RuntimeException {
        if (!MemoryMeter.isInitialized()) {
            logger.warn("MemoryMeter uninitialized (jamm not specified as java agent); assuming liveRatio of 10.0.  Usually this means cassandra-env.sh disabled jamm because you are using a buggy JRE; upgrade to the Sun JRE instead");
            this.cfs.liveRatio = 10.0;
            return;
        }
        if (!meteringInProgress.add(this.cfs)) {
            logger.debug("Metering already pending or active for {}; skipping liveRatio update", (Object)this.cfs);
            return;
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    activelyMeasuring = Memtable.this;
                    long start = System.currentTimeMillis();
                    long deepSize = Memtable.this.meter.measure((Object)Memtable.this.columnFamilies);
                    int objects = 0;
                    for (Map.Entry entry : Memtable.this.columnFamilies.entrySet()) {
                        deepSize += Memtable.this.meter.measureDeep(entry.getKey()) + Memtable.this.meter.measureDeep(entry.getValue());
                        objects += ((ColumnFamily)entry.getValue()).getColumnCount();
                    }
                    double newRatio = (double)deepSize / (double)Memtable.this.currentSize.get();
                    if (newRatio < 1.0) {
                        logger.warn("setting live ratio to minimum of {} instead of {}", (Object)1.0, (Object)newRatio);
                        newRatio = 1.0;
                    }
                    if (newRatio > 64.0) {
                        logger.warn("setting live ratio to maximum of {} instead of {}", (Object)64.0, (Object)newRatio);
                        newRatio = 64.0;
                    }
                    Memtable.this.cfs.liveRatio = newRatio > Memtable.this.cfs.liveRatio ? newRatio : (Memtable.this.cfs.liveRatio + newRatio) / 2.0;
                    logger.info("{} liveRatio is {} (just-counted was {}).  calculation took {}ms for {} columns", new Object[]{Memtable.this.cfs, Memtable.this.cfs.liveRatio, newRatio, System.currentTimeMillis() - start, objects});
                    activelyMeasuring = null;
                }
                finally {
                    meteringInProgress.remove(Memtable.this.cfs);
                }
            }
        };
        meterExecutor.submit(runnable);
    }

    private void resolve(DecoratedKey key, ColumnFamily cf) {
        ColumnFamily previous = (ColumnFamily)this.columnFamilies.get(key);
        if (previous == null) {
            ColumnFamily empty = cf.cloneMeShallow(cf.isSuper() ? ThreadSafeSortedColumns.factory() : AtomicSortedColumns.factory(), false);
            previous = this.columnFamilies.putIfAbsent(new DecoratedKey(key.token, this.allocator.clone(key.key)), empty);
            if (previous == null) {
                previous = empty;
            }
        }
        long sizeDelta = previous.addAllWithSizeDelta(cf, this.allocator, this.localCopyFunction);
        this.currentSize.addAndGet(sizeDelta);
        this.currentOperations.addAndGet(cf.getColumnCount() == 0 ? (cf.isMarkedForDelete() ? 1L : 0L) : (long)cf.getColumnCount());
    }

    public String contents() {
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        for (Map.Entry entry : this.columnFamilies.entrySet()) {
            builder.append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        builder.append("}");
        return builder.toString();
    }

    private SSTableReader writeSortedContents(Future<ReplayPosition> context) throws IOException, ExecutionException, InterruptedException {
        SSTableReader ssTable;
        logger.info("Writing " + this);
        long keySize = 0L;
        for (RowPosition key : this.columnFamilies.keySet()) {
            assert (key instanceof DecoratedKey);
            keySize += (long)((DecoratedKey)key).key.remaining();
        }
        long estimatedSize = (long)((double)(keySize + keySize + this.currentSize.get()) * 1.2);
        SSTableWriter writer = this.cfs.createFlushWriter(this.columnFamilies.size(), estimatedSize, context.get());
        try {
            for (Map.Entry entry : this.columnFamilies.entrySet()) {
                ColumnFamily cf = (ColumnFamily)entry.getValue();
                if (cf.isMarkedForDelete()) {
                    ColumnFamilyStore.removeDeletedColumnsOnly(cf, Integer.MIN_VALUE);
                }
                writer.append((DecoratedKey)entry.getKey(), cf);
            }
            ssTable = writer.closeAndOpenReader();
        }
        catch (Exception e) {
            writer.abort();
            throw FBUtilities.unchecked(e);
        }
        logger.info(String.format("Completed flushing %s (%d bytes) for commitlog position %s", ssTable.getFilename(), new File(ssTable.getFilename()).length(), context.get()));
        return ssTable;
    }

    public void flushAndSignal(final CountDownLatch latch, ExecutorService writer, final Future<ReplayPosition> context) {
        writer.execute(new WrappedRunnable(){

            @Override
            public void runMayThrow() throws Exception {
                SSTableReader sstable = Memtable.this.writeSortedContents(context);
                Memtable.this.cfs.replaceFlushed(Memtable.this, sstable);
                latch.countDown();
            }
        });
    }

    public String toString() {
        return String.format("Memtable-%s@%s(%s/%s serialized/live bytes, %s ops)", this.cfs.getColumnFamilyName(), this.hashCode(), this.currentSize, this.getLiveSize(), this.currentOperations);
    }

    public Iterator<Map.Entry<DecoratedKey, ColumnFamily>> getEntryIterator(final RowPosition startWith, final RowPosition stopAt) {
        return new Iterator<Map.Entry<DecoratedKey, ColumnFamily>>(){
            private Iterator<Map.Entry<RowPosition, ColumnFamily>> iter;
            {
                this.iter = stopAt.isMinimum() ? Memtable.this.columnFamilies.tailMap(startWith).entrySet().iterator() : Memtable.this.columnFamilies.subMap(startWith, true, stopAt, true).entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Map.Entry<DecoratedKey, ColumnFamily> next() {
                Map.Entry<RowPosition, ColumnFamily> entry = this.iter.next();
                assert (entry.getKey() instanceof DecoratedKey);
                return entry;
            }

            @Override
            public void remove() {
                this.iter.remove();
            }
        };
    }

    public boolean isClean() {
        return this.columnFamilies.isEmpty();
    }

    public static IColumnIterator getSliceIterator(final DecoratedKey key, final ColumnFamily cf, SliceQueryFilter filter) {
        assert (cf != null);
        final Iterator<IColumn> filteredIter = filter.reversed ? (filter.start.remaining() == 0 ? cf.reverseIterator() : cf.reverseIterator(filter.start)) : cf.iterator(filter.start);
        return new AbstractColumnIterator(){

            @Override
            public ColumnFamily getColumnFamily() {
                return cf;
            }

            @Override
            public DecoratedKey getKey() {
                return key;
            }

            @Override
            public boolean hasNext() {
                return filteredIter.hasNext();
            }

            @Override
            public IColumn next() {
                return (IColumn)filteredIter.next();
            }
        };
    }

    public static IColumnIterator getNamesIterator(final DecoratedKey key, final ColumnFamily cf, final NamesQueryFilter filter) {
        assert (cf != null);
        final boolean isStandard = !cf.isSuper();
        return new SimpleAbstractColumnIterator(){
            private Iterator<ByteBuffer> iter;
            {
                this.iter = filter.columns.iterator();
            }

            @Override
            public ColumnFamily getColumnFamily() {
                return cf;
            }

            @Override
            public DecoratedKey getKey() {
                return key;
            }

            protected IColumn computeNext() {
                while (this.iter.hasNext()) {
                    ByteBuffer current = this.iter.next();
                    IColumn column = cf.getColumn(current);
                    if (column == null) continue;
                    return isStandard ? column : ((SuperColumn)column).cloneMe();
                }
                return (IColumn)this.endOfData();
            }
        };
    }

    public ColumnFamily getColumnFamily(DecoratedKey key) {
        return (ColumnFamily)this.columnFamilies.get(key);
    }

    void clearUnsafe() {
        this.columnFamilies.clear();
    }

    public long creationTime() {
        return this.creationTime;
    }
}

