/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.compaction.ICompactionScanner;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.RandomAccessReader;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSTableScanner
implements ICompactionScanner {
    private static Logger logger = LoggerFactory.getLogger(SSTableScanner.class);
    protected final RandomAccessReader file;
    public final SSTableReader sstable;
    private IColumnIterator row;
    protected boolean exhausted = false;
    protected Iterator<IColumnIterator> iterator;
    private QueryFilter filter;

    SSTableScanner(SSTableReader sstable, boolean skipCache) {
        try {
            this.file = sstable.openDataReader(skipCache);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new IOError(e);
        }
        this.sstable = sstable;
    }

    SSTableScanner(SSTableReader sstable, QueryFilter filter) {
        try {
            this.file = sstable.openDataReader(false);
        }
        catch (IOException e) {
            sstable.markSuspect();
            throw new IOError(e);
        }
        this.sstable = sstable;
        this.filter = filter;
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    public void seekTo(RowPosition seekKey) {
        try {
            long position = this.sstable.getPosition(seekKey, SSTableReader.Operator.GE);
            if (position < 0L) {
                this.exhausted = true;
                return;
            }
            this.file.seek(position);
            this.row = null;
        }
        catch (IOException e) {
            this.sstable.markSuspect();
            throw new RuntimeException("corrupt sstable", e);
        }
    }

    @Override
    public long getLengthInBytes() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public long getCurrentPosition() {
        return this.file.getFilePointer();
    }

    @Override
    public String getBackingFiles() {
        return this.sstable.toString();
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new IColumnIterator[0]).iterator() : new KeyScanningIterator();
        }
        return this.iterator.hasNext();
    }

    @Override
    public IColumnIterator next() {
        if (this.iterator == null) {
            this.iterator = this.exhausted ? Arrays.asList(new IColumnIterator[0]).iterator() : new KeyScanningIterator();
        }
        return this.iterator.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "file=" + this.file + " sstable=" + this.sstable + " exhausted=" + this.exhausted + ")";
    }

    protected class KeyScanningIterator
    implements Iterator<IColumnIterator> {
        protected long finishedAt;

        protected KeyScanningIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                if (SSTableScanner.this.row == null) {
                    return !SSTableScanner.this.file.isEOF();
                }
                return this.finishedAt < SSTableScanner.this.file.length();
            }
            catch (IOException e) {
                SSTableScanner.this.sstable.markSuspect();
                throw new RuntimeException(e);
            }
        }

        @Override
        public IColumnIterator next() {
            try {
                if (SSTableScanner.this.row != null) {
                    SSTableScanner.this.file.seek(this.finishedAt);
                }
                assert (!SSTableScanner.this.file.isEOF());
                DecoratedKey key = SSTableReader.decodeKey(SSTableScanner.this.sstable.partitioner, SSTableScanner.this.sstable.descriptor, ByteBufferUtil.readWithShortLength(SSTableScanner.this.file));
                long dataSize = SSTableReader.readRowSize(SSTableScanner.this.file, SSTableScanner.this.sstable.descriptor);
                long dataStart = SSTableScanner.this.file.getFilePointer();
                this.finishedAt = dataStart + dataSize;
                if (SSTableScanner.this.filter == null) {
                    SSTableScanner.this.row = new SSTableIdentityIterator(SSTableScanner.this.sstable, SSTableScanner.this.file, key, dataStart, dataSize);
                    return SSTableScanner.this.row;
                }
                return SSTableScanner.this.row = SSTableScanner.this.filter.getSSTableColumnIterator(SSTableScanner.this.sstable, SSTableScanner.this.file, key);
            }
            catch (IOException e) {
                SSTableScanner.this.sstable.markSuspect();
                throw new RuntimeException(SSTableScanner.this + " failed to provide next columns from " + this, e);
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + "finishedAt:" + this.finishedAt + ")";
        }
    }
}

