/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.IOError;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql.QueryProcessor;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DefsTable;
import org.apache.cassandra.db.DeletedColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.RowPosition;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.columniterator.IdentityQueryFilter;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemTable {
    private static Logger logger = LoggerFactory.getLogger(SystemTable.class);
    public static final String STATUS_CF = "LocationInfo";
    public static final String INDEX_CF = "IndexInfo";
    public static final String NODE_ID_CF = "NodeIdInfo";
    public static final String VERSION_CF = "Versions";
    public static final String SCHEMA_KEYSPACES_CF = "schema_keyspaces";
    public static final String SCHEMA_COLUMNFAMILIES_CF = "schema_columnfamilies";
    public static final String SCHEMA_COLUMNS_CF = "schema_columns";
    private static final ByteBuffer LOCATION_KEY = ByteBufferUtil.bytes("L");
    private static final ByteBuffer RING_KEY = ByteBufferUtil.bytes("Ring");
    private static final ByteBuffer BOOTSTRAP_KEY = ByteBufferUtil.bytes("Bootstrap");
    private static final ByteBuffer COOKIE_KEY = ByteBufferUtil.bytes("Cookies");
    private static final ByteBuffer BOOTSTRAP = ByteBufferUtil.bytes("B");
    private static final ByteBuffer TOKEN = ByteBufferUtil.bytes("Token");
    private static final ByteBuffer GENERATION = ByteBufferUtil.bytes("Generation");
    private static final ByteBuffer CLUSTERNAME = ByteBufferUtil.bytes("ClusterName");
    private static final ByteBuffer CURRENT_LOCAL_NODE_ID_KEY = ByteBufferUtil.bytes("CurrentLocal");
    private static final ByteBuffer ALL_LOCAL_NODE_ID_KEY = ByteBufferUtil.bytes("Local");

    private static DecoratedKey decorate(ByteBuffer key) {
        return StorageService.getPartitioner().decorateKey(key);
    }

    public static void finishStartup() throws IOException {
        SystemTable.setupVersion();
        SystemTable.purgeIncompatibleHints();
    }

    private static void setupVersion() throws IOException {
        RowMutation rm = new RowMutation("system", ByteBufferUtil.bytes("build"));
        ColumnFamily cf = ColumnFamily.create("system", VERSION_CF);
        cf.addColumn(new Column(ByteBufferUtil.bytes("version"), ByteBufferUtil.bytes(FBUtilities.getReleaseVersionString()), FBUtilities.timestampMicros()));
        rm.add(cf);
        rm.apply();
        rm = new RowMutation("system", ByteBufferUtil.bytes("cql"));
        cf = ColumnFamily.create("system", VERSION_CF);
        cf.addColumn(new Column(ByteBufferUtil.bytes("version"), ByteBufferUtil.bytes(QueryProcessor.CQL_VERSION.toString()), FBUtilities.timestampMicros()));
        rm.add(cf);
        rm.apply();
        rm = new RowMutation("system", ByteBufferUtil.bytes("thrift"));
        cf = ColumnFamily.create("system", VERSION_CF);
        cf.addColumn(new Column(ByteBufferUtil.bytes("version"), ByteBufferUtil.bytes("19.32.0"), FBUtilities.timestampMicros()));
        rm.add(cf);
        rm.apply();
    }

    private static void purgeIncompatibleHints() throws IOException {
        ByteBuffer upgradeMarker = ByteBufferUtil.bytes("Pre-1.0 hints purged");
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(COOKIE_KEY), new QueryPath(STATUS_CF), upgradeMarker);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        if (cf != null) {
            logger.debug("Pre-1.0 hints already purged");
            return;
        }
        ColumnFamilyStore hintsCfs = Table.open("system").getColumnFamilyStore("HintsColumnFamily");
        if (hintsCfs.getSSTables().size() > 0) {
            logger.info("Possible old-format hints found. Truncating");
            try {
                hintsCfs.truncate();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        logger.debug("Marking pre-1.0 hints purged");
        RowMutation rm = new RowMutation("system", COOKIE_KEY);
        rm.add(new QueryPath(STATUS_CF, null, upgradeMarker), ByteBufferUtil.bytes("oh yes, they were purged"), FBUtilities.timestampMicros());
        rm.apply();
    }

    public static synchronized void updateToken(InetAddress ep, Token token) {
        if (ep.equals(FBUtilities.getBroadcastAddress())) {
            SystemTable.removeToken(token);
            return;
        }
        IPartitioner p = StorageService.getPartitioner();
        ColumnFamily cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(p.getTokenFactory().toByteArray(token), ByteBuffer.wrap(ep.getAddress()), FBUtilities.timestampMicros()));
        RowMutation rm = new RowMutation("system", RING_KEY);
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SystemTable.forceBlockingFlush(STATUS_CF);
    }

    public static synchronized void removeToken(Token token) {
        IPartitioner p = StorageService.getPartitioner();
        RowMutation rm = new RowMutation("system", RING_KEY);
        rm.delete(new QueryPath(STATUS_CF, null, p.getTokenFactory().toByteArray(token)), FBUtilities.timestampMicros());
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SystemTable.forceBlockingFlush(STATUS_CF);
    }

    public static synchronized void updateToken(Token token) {
        IPartitioner p = StorageService.getPartitioner();
        ColumnFamily cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(TOKEN, p.getTokenFactory().toByteArray(token), FBUtilities.timestampMicros()));
        RowMutation rm = new RowMutation("system", LOCATION_KEY);
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SystemTable.forceBlockingFlush(STATUS_CF);
    }

    private static void forceBlockingFlush(String cfname) {
        try {
            Table.open("system").getColumnFamilyStore(cfname).forceBlockingFlush();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static HashMap<Token, InetAddress> loadTokens() {
        HashMap<Token, InetAddress> tokenMap = new HashMap<Token, InetAddress>();
        IPartitioner p = StorageService.getPartitioner();
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getIdentityFilter(SystemTable.decorate(RING_KEY), new QueryPath(STATUS_CF));
        ColumnFamily cf = ColumnFamilyStore.removeDeleted(table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter), Integer.MAX_VALUE);
        if (cf != null) {
            for (IColumn column : cf.getSortedColumns()) {
                try {
                    ByteBuffer v = column.value();
                    byte[] addr = new byte[v.remaining()];
                    ByteBufferUtil.arrayCopy(v, v.position(), addr, 0, v.remaining());
                    tokenMap.put(p.getTokenFactory().fromByteArray(column.name()), InetAddress.getByAddress(addr));
                }
                catch (UnknownHostException e) {
                    throw new IOError(e);
                }
            }
        }
        return tokenMap;
    }

    public static void checkHealth() throws ConfigurationException, IOException {
        Table table = null;
        try {
            table = Table.open("system");
        }
        catch (AssertionError err) {
            ConfigurationException ex = new ConfigurationException("Could not read system table!");
            ex.initCause((Throwable)((Object)err));
            throw ex;
        }
        TreeSet<ByteBuffer> cols = new TreeSet<ByteBuffer>(BytesType.instance);
        cols.add(CLUSTERNAME);
        QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(LOCATION_KEY), new QueryPath(STATUS_CF), cols);
        ColumnFamilyStore cfs = table.getColumnFamilyStore(STATUS_CF);
        ColumnFamily cf = cfs.getColumnFamily(filter);
        if (cf == null) {
            if (!cfs.getSSTables().isEmpty()) {
                throw new ConfigurationException("Found system table files, but they couldn't be loaded!");
            }
            RowMutation rm = new RowMutation("system", LOCATION_KEY);
            cf = ColumnFamily.create("system", STATUS_CF);
            cf.addColumn(new Column(CLUSTERNAME, ByteBufferUtil.bytes(DatabaseDescriptor.getClusterName()), FBUtilities.timestampMicros()));
            rm.add(cf);
            rm.apply();
            return;
        }
        IColumn clusterCol = cf.getColumn(CLUSTERNAME);
        assert (clusterCol != null);
        String savedClusterName = ByteBufferUtil.string(clusterCol.value());
        if (!DatabaseDescriptor.getClusterName().equals(savedClusterName)) {
            throw new ConfigurationException("Saved cluster name " + savedClusterName + " != configured name " + DatabaseDescriptor.getClusterName());
        }
    }

    public static Token getSavedToken() {
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(LOCATION_KEY), new QueryPath(STATUS_CF), TOKEN);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        return cf == null ? null : StorageService.getPartitioner().getTokenFactory().fromByteArray(cf.getColumn(TOKEN).value());
    }

    public static int incrementAndGetGeneration() throws IOException {
        int generation;
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(LOCATION_KEY), new QueryPath(STATUS_CF), GENERATION);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        if (cf == null) {
            generation = (int)(System.currentTimeMillis() / 1000L);
        } else {
            int now;
            int storedGeneration = ByteBufferUtil.toInt(cf.getColumn(GENERATION).value()) + 1;
            if (storedGeneration >= (now = (int)(System.currentTimeMillis() / 1000L))) {
                logger.warn("Using stored Gossip Generation {} as it is greater than current system time {}.  See CASSANDRA-3654 if you experience problems", (Object)storedGeneration, (Object)now);
                generation = storedGeneration;
            } else {
                generation = now;
            }
        }
        RowMutation rm = new RowMutation("system", LOCATION_KEY);
        cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(GENERATION, ByteBufferUtil.bytes(generation), FBUtilities.timestampMicros()));
        rm.add(cf);
        rm.apply();
        SystemTable.forceBlockingFlush(STATUS_CF);
        return generation;
    }

    public static BootstrapState getBootstrapState() {
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getNamesFilter(SystemTable.decorate(BOOTSTRAP_KEY), new QueryPath(STATUS_CF), BOOTSTRAP);
        ColumnFamily cf = table.getColumnFamilyStore(STATUS_CF).getColumnFamily(filter);
        if (cf == null) {
            return BootstrapState.NEEDS_BOOTSTRAP;
        }
        IColumn c = cf.getColumn(BOOTSTRAP);
        return BootstrapState.values()[c.value().get(c.value().position())];
    }

    public static boolean bootstrapComplete() {
        return SystemTable.getBootstrapState() == BootstrapState.COMPLETED;
    }

    public static boolean bootstrapInProgress() {
        return SystemTable.getBootstrapState() == BootstrapState.IN_PROGRESS;
    }

    public static void setBootstrapState(BootstrapState state) {
        ColumnFamily cf = ColumnFamily.create("system", STATUS_CF);
        cf.addColumn(new Column(BOOTSTRAP, ByteBuffer.wrap(new byte[]{(byte)state.ordinal()}), FBUtilities.timestampMicros()));
        RowMutation rm = new RowMutation("system", BOOTSTRAP_KEY);
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isIndexBuilt(String table, String indexName) {
        QueryFilter filter;
        ColumnFamilyStore cfs = Table.open("system").getColumnFamilyStore(INDEX_CF);
        return ColumnFamilyStore.removeDeleted(cfs.getColumnFamily(filter = QueryFilter.getNamesFilter(SystemTable.decorate(ByteBufferUtil.bytes(table)), new QueryPath(INDEX_CF), ByteBufferUtil.bytes(indexName))), Integer.MAX_VALUE) != null;
    }

    public static void setIndexBuilt(String table, String indexName) {
        ColumnFamily cf = ColumnFamily.create("system", INDEX_CF);
        cf.addColumn(new Column(ByteBufferUtil.bytes(indexName), ByteBufferUtil.EMPTY_BYTE_BUFFER, FBUtilities.timestampMicros()));
        RowMutation rm = new RowMutation("system", ByteBufferUtil.bytes(table));
        rm.add(cf);
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SystemTable.forceBlockingFlush(INDEX_CF);
    }

    public static void setIndexRemoved(String table, String indexName) {
        RowMutation rm = new RowMutation("system", ByteBufferUtil.bytes(table));
        rm.delete(new QueryPath(INDEX_CF, null, ByteBufferUtil.bytes(indexName)), FBUtilities.timestampMicros());
        try {
            rm.apply();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SystemTable.forceBlockingFlush(INDEX_CF);
    }

    public static NodeId getCurrentLocalNodeId() {
        ByteBuffer id = null;
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getIdentityFilter(SystemTable.decorate(CURRENT_LOCAL_NODE_ID_KEY), new QueryPath(NODE_ID_CF));
        ColumnFamily cf = table.getColumnFamilyStore(NODE_ID_CF).getColumnFamily(filter);
        if (cf != null) {
            cf = ColumnFamilyStore.removeDeleted(cf, 0);
            assert (cf.getColumnCount() <= 1);
            if (cf.getColumnCount() > 0) {
                id = cf.iterator().next().name();
            }
        }
        if (id != null) {
            return NodeId.wrap(id);
        }
        return null;
    }

    public static void writeCurrentLocalNodeId(NodeId oldNodeId, NodeId newNodeId, long now) {
        ByteBuffer ip = ByteBuffer.wrap(FBUtilities.getBroadcastAddress().getAddress());
        ColumnFamily cf = ColumnFamily.create("system", NODE_ID_CF);
        cf.addColumn(new Column(newNodeId.bytes(), ip, now));
        ColumnFamily cf2 = cf.cloneMe();
        if (oldNodeId != null) {
            cf2.addColumn(new DeletedColumn(oldNodeId.bytes(), (int)(System.currentTimeMillis() / 1000L), now));
        }
        RowMutation rmCurrent = new RowMutation("system", CURRENT_LOCAL_NODE_ID_KEY);
        RowMutation rmAll = new RowMutation("system", ALL_LOCAL_NODE_ID_KEY);
        rmCurrent.add(cf2);
        rmAll.add(cf);
        try {
            rmCurrent.apply();
            rmAll.apply();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<NodeId.NodeIdRecord> getOldLocalNodeIds() {
        ArrayList<NodeId.NodeIdRecord> l = new ArrayList<NodeId.NodeIdRecord>();
        Table table = Table.open("system");
        QueryFilter filter = QueryFilter.getIdentityFilter(SystemTable.decorate(ALL_LOCAL_NODE_ID_KEY), new QueryPath(NODE_ID_CF));
        ColumnFamily cf = table.getColumnFamilyStore(NODE_ID_CF).getColumnFamily(filter);
        NodeId previous = null;
        for (IColumn c : cf) {
            if (previous != null) {
                l.add(new NodeId.NodeIdRecord(previous, c.timestamp()));
            }
            previous = NodeId.wrap(c.name());
        }
        return l;
    }

    public static ColumnFamilyStore schemaCFS(String cfName) {
        return Table.open("system").getColumnFamilyStore(cfName);
    }

    public static List<Row> serializedSchema() {
        ArrayList<Row> schema = new ArrayList<Row>(3);
        schema.addAll(SystemTable.serializedSchema(SCHEMA_KEYSPACES_CF));
        schema.addAll(SystemTable.serializedSchema(SCHEMA_COLUMNFAMILIES_CF));
        schema.addAll(SystemTable.serializedSchema(SCHEMA_COLUMNS_CF));
        return schema;
    }

    public static List<Row> serializedSchema(String schemaCfName) {
        Object minToken = StorageService.getPartitioner().getMinimumToken();
        return SystemTable.schemaCFS(schemaCfName).getRangeSlice(null, new Range<RowPosition>(((Token)minToken).minKeyBound(), ((Token)minToken).maxKeyBound()), Integer.MAX_VALUE, new IdentityQueryFilter(), null);
    }

    public static Collection<RowMutation> serializeSchema() {
        HashMap<DecoratedKey, RowMutation> mutationMap = new HashMap<DecoratedKey, RowMutation>();
        SystemTable.serializeSchema(mutationMap, SCHEMA_KEYSPACES_CF);
        SystemTable.serializeSchema(mutationMap, SCHEMA_COLUMNFAMILIES_CF);
        SystemTable.serializeSchema(mutationMap, SCHEMA_COLUMNS_CF);
        return mutationMap.values();
    }

    private static void serializeSchema(Map<DecoratedKey, RowMutation> mutationMap, String schemaCfName) {
        for (Row schemaRow : SystemTable.serializedSchema(schemaCfName)) {
            RowMutation mutation = mutationMap.get(schemaRow.key);
            if (mutation == null) {
                mutationMap.put(schemaRow.key, new RowMutation("system", schemaRow));
                continue;
            }
            mutation.add(schemaRow.cf);
        }
    }

    public static Map<DecoratedKey, ColumnFamily> getSchema(String cfName) {
        HashMap<DecoratedKey, ColumnFamily> schema = new HashMap<DecoratedKey, ColumnFamily>();
        for (Row schemaEntity : SystemTable.serializedSchema(cfName)) {
            schema.put(schemaEntity.key, schemaEntity.cf);
        }
        return schema;
    }

    public static ByteBuffer getSchemaKSKey(String ksName) {
        return AsciiType.instance.fromString(ksName);
    }

    public static Row readSchemaRow(String ksName) {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(SystemTable.getSchemaKSKey(ksName));
        ColumnFamilyStore schemaCFS = SystemTable.schemaCFS(SCHEMA_KEYSPACES_CF);
        ColumnFamily result = schemaCFS.getColumnFamily(QueryFilter.getIdentityFilter(key, new QueryPath(SCHEMA_KEYSPACES_CF)));
        return new Row(key, result);
    }

    public static Row readSchemaRow(String ksName, String cfName) {
        DecoratedKey key = StorageService.getPartitioner().decorateKey(SystemTable.getSchemaKSKey(ksName));
        ColumnFamilyStore schemaCFS = SystemTable.schemaCFS(SCHEMA_COLUMNFAMILIES_CF);
        ColumnFamily result = schemaCFS.getColumnFamily(key, new QueryPath(SCHEMA_COLUMNFAMILIES_CF), DefsTable.searchComposite(cfName, true), DefsTable.searchComposite(cfName, false), false, Integer.MAX_VALUE);
        return new Row(key, result);
    }

    public static enum BootstrapState {
        NEEDS_BOOTSTRAP,
        COMPLETED,
        IN_PROGRESS;

    }
}

