/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;

public abstract class SchemaAlteringStatement
extends CFStatement
implements CQLStatement {
    private static final long timeLimitForSchemaAgreement = 10000L;
    private final boolean isColumnFamilyLevel;

    protected SchemaAlteringStatement() {
        super(null);
        this.isColumnFamilyLevel = false;
    }

    protected SchemaAlteringStatement(CFName name) {
        super(name);
        this.isColumnFamilyLevel = true;
    }

    @Override
    public void prepareKeyspace(ClientState state) throws InvalidRequestException {
        if (this.isColumnFamilyLevel) {
            super.prepareKeyspace(state);
        }
    }

    @Override
    public ParsedStatement.Prepared prepare() throws InvalidRequestException {
        return new ParsedStatement.Prepared(this);
    }

    public abstract void announceMigration() throws InvalidRequestException, ConfigurationException;

    @Override
    public void validate(ClientState state) throws InvalidRequestException, SchemaDisagreementException {
        SchemaAlteringStatement.validateSchemaAgreement();
    }

    @Override
    public CqlResult execute(ClientState state, List<ByteBuffer> variables) throws InvalidRequestException, SchemaDisagreementException {
        try {
            this.announceMigration();
        }
        catch (ConfigurationException e) {
            InvalidRequestException ex = new InvalidRequestException(e.toString());
            ex.initCause((Throwable)e);
            throw ex;
        }
        SchemaAlteringStatement.validateSchemaIsSettled();
        return null;
    }

    private static void validateSchemaAgreement() throws SchemaDisagreementException {
        if (SchemaAlteringStatement.describeSchemaVersions().size() > 1) {
            throw new SchemaDisagreementException();
        }
    }

    private static Map<String, List<String>> describeSchemaVersions() {
        return Maps.filterKeys(StorageProxy.describeSchemaVersions(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)"UNREACHABLE")));
    }

    private static void validateSchemaIsSettled() throws SchemaDisagreementException {
        long limit = System.currentTimeMillis() + 10000L;
        block0: while (limit - System.currentTimeMillis() >= 0L) {
            String currentVersionId = Schema.instance.getVersion().toString();
            for (String version : SchemaAlteringStatement.describeSchemaVersions().keySet()) {
                if (version.equals(currentVersionId)) continue;
                continue block0;
            }
            return;
        }
        throw new SchemaDisagreementException();
    }
}

