/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.CqlLexer;
import org.apache.cassandra.cql3.CqlParser;
import org.apache.cassandra.cql3.UntypedResultSet;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SelectStatement;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.thrift.CqlPreparedResult;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.CqlResultType;
import org.apache.cassandra.thrift.CqlRow;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.SlicePredicate;
import org.apache.cassandra.thrift.SliceRange;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.SemanticVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryProcessor {
    public static final SemanticVersion CQL_VERSION = new SemanticVersion("3.0.0-beta1");
    private static final Logger logger = LoggerFactory.getLogger(QueryProcessor.class);

    public static void validateKey(ByteBuffer key) throws InvalidRequestException {
        if (key == null || key.remaining() == 0) {
            throw new InvalidRequestException("Key may not be empty");
        }
        if (key.remaining() > 65535) {
            throw new InvalidRequestException("Key length of " + key.remaining() + " is longer than maximum of " + 65535);
        }
    }

    public static void validateColumnNames(Iterable<ByteBuffer> columns) throws InvalidRequestException {
        for (ByteBuffer name : columns) {
            if (name.remaining() > 65535) {
                throw new InvalidRequestException(String.format("column name is too long (%s > %s)", name.remaining(), 65535));
            }
            if (name.remaining() != 0) continue;
            throw new InvalidRequestException("zero-length column name");
        }
    }

    public static void validateColumnName(ByteBuffer column) throws InvalidRequestException {
        QueryProcessor.validateColumnNames(Collections.singletonList(column));
    }

    public static void validateSlicePredicate(CFMetaData metadata, SlicePredicate predicate) throws InvalidRequestException {
        if (predicate.slice_range != null) {
            QueryProcessor.validateSliceRange(metadata, predicate.slice_range);
        } else {
            QueryProcessor.validateColumnNames(predicate.column_names);
        }
    }

    public static void validateSliceRange(CFMetaData metadata, SliceRange range) throws InvalidRequestException {
        QueryProcessor.validateSliceRange(metadata, range.start, range.finish, range.reversed);
    }

    public static void validateSliceRange(CFMetaData metadata, ByteBuffer start, ByteBuffer finish, boolean reversed) throws InvalidRequestException {
        Comparator<ByteBuffer> orderedComparator;
        AbstractType<?> comparator = metadata.getComparatorFor(null);
        Comparator<ByteBuffer> comparator2 = orderedComparator = reversed ? comparator.reverseComparator : comparator;
        if (start.remaining() > 0 && finish.remaining() > 0 && orderedComparator.compare(start, finish) > 0) {
            throw new InvalidRequestException("Range finish must come after start in traversal order");
        }
    }

    private static CqlResult processStatement(CQLStatement statement, ClientState clientState, List<ByteBuffer> variables) throws UnavailableException, InvalidRequestException, TimedOutException, SchemaDisagreementException {
        statement.checkAccess(clientState);
        statement.validate(clientState);
        CqlResult result = statement.execute(clientState, variables);
        if (result == null) {
            result = new CqlResult();
            result.type = CqlResultType.VOID;
        }
        return result;
    }

    public static CqlResult process(String queryString, ClientState clientState) throws RecognitionException, UnavailableException, InvalidRequestException, TimedOutException, SchemaDisagreementException {
        logger.trace("CQL QUERY: {}", (Object)queryString);
        return QueryProcessor.processStatement(QueryProcessor.getStatement((String)queryString, (ClientState)clientState).statement, clientState, Collections.<ByteBuffer>emptyList());
    }

    public static CqlResult processInternal(String query, ClientState state) {
        try {
            CQLStatement statement = QueryProcessor.getStatement((String)query, (ClientState)state).statement;
            statement.validate(state);
            CqlResult result = statement.execute(state, Collections.<ByteBuffer>emptyList());
            if (result == null || result.rows.isEmpty()) {
                result = new CqlResult();
                result.type = CqlResultType.VOID;
            }
            return result;
        }
        catch (RecognitionException e) {
            throw new RuntimeException(e);
        }
        catch (UnavailableException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidRequestException e) {
            throw new AssertionError((Object)e);
        }
        catch (TimedOutException e) {
            throw new RuntimeException(e);
        }
        catch (SchemaDisagreementException e) {
            throw new RuntimeException(e);
        }
    }

    public static UntypedResultSet resultify(String queryString, Row row) {
        List<CqlRow> cqlRows;
        SelectStatement ss;
        try {
            ss = (SelectStatement)QueryProcessor.getStatement((String)queryString, null).statement;
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        catch (RecognitionException e) {
            throw new RuntimeException(e);
        }
        try {
            cqlRows = ss.process(Collections.singletonList(row));
        }
        catch (InvalidRequestException e) {
            throw new RuntimeException(e);
        }
        return new UntypedResultSet(cqlRows);
    }

    public static CqlPreparedResult prepare(String queryString, ClientState clientState) throws RecognitionException, InvalidRequestException {
        logger.trace("CQL QUERY: {}", (Object)queryString);
        ParsedStatement.Prepared prepared = QueryProcessor.getStatement(queryString, clientState);
        int statementId = QueryProcessor.makeStatementId(queryString);
        clientState.getCQL3Prepared().put(statementId, prepared.statement);
        logger.trace(String.format("Stored prepared statement #%d with %d bind markers", statementId, prepared.statement.getBoundsTerms()));
        assert (prepared.statement.getBoundsTerms() == prepared.boundNames.size());
        ArrayList<String> var_types = new ArrayList<String>(prepared.boundNames.size());
        ArrayList<String> var_names = new ArrayList<String>(prepared.boundNames.size());
        for (CFDefinition.Name n : prepared.boundNames) {
            var_types.add(SelectStatement.getShortTypeName(n.type));
            var_names.add(n.name.toString());
        }
        CqlPreparedResult result = new CqlPreparedResult(statementId, prepared.boundNames.size());
        result.setVariable_types(var_types);
        result.setVariable_names(var_names);
        return result;
    }

    public static CqlResult processPrepared(CQLStatement statement, ClientState clientState, List<ByteBuffer> variables) throws UnavailableException, InvalidRequestException, TimedOutException, SchemaDisagreementException {
        if (!variables.isEmpty() || statement.getBoundsTerms() != 0) {
            if (variables.size() != statement.getBoundsTerms()) {
                throw new InvalidRequestException(String.format("there were %d markers(?) in CQL but %d bound variables", statement.getBoundsTerms(), variables.size()));
            }
            if (logger.isTraceEnabled()) {
                for (int i = 0; i < variables.size(); ++i) {
                    logger.trace("[{}] '{}'", (Object)(i + 1), (Object)variables.get(i));
                }
            }
        }
        return QueryProcessor.processStatement(statement, clientState, variables);
    }

    private static final int makeStatementId(String cql) {
        return cql.hashCode();
    }

    private static ParsedStatement.Prepared getStatement(String queryStr, ClientState clientState) throws InvalidRequestException, RecognitionException {
        ParsedStatement statement = QueryProcessor.parseStatement(queryStr);
        if (statement instanceof CFStatement) {
            ((CFStatement)statement).prepareKeyspace(clientState);
        }
        return statement.prepare();
    }

    private static ParsedStatement parseStatement(String queryStr) throws InvalidRequestException, RecognitionException {
        try {
            ANTLRStringStream stream = new ANTLRStringStream(queryStr);
            CqlLexer lexer = new CqlLexer((CharStream)stream);
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            CqlParser parser = new CqlParser((TokenStream)tokenStream);
            ParsedStatement statement = parser.query();
            lexer.throwLastRecognitionError();
            parser.throwLastRecognitionError();
            return statement;
        }
        catch (RuntimeException re) {
            InvalidRequestException ire = new InvalidRequestException("Failed parsing statement: [" + queryStr + "] reason: " + re.getClass().getSimpleName() + " " + re.getMessage());
            ire.initCause((Throwable)re);
            throw ire;
        }
    }
}

