/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.concurrent.locks.Condition;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.apache.cassandra.service.AntiEntropyService;
import org.apache.cassandra.service.StorageServiceMBean;
import org.apache.cassandra.utils.SimpleCondition;

class RepairRunner
implements NotificationListener {
    private final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
    private final Condition condition = new SimpleCondition();
    private final PrintStream out;
    private final String keyspace;
    private final String[] columnFamilies;
    private int cmd;
    private boolean success = true;

    RepairRunner(PrintStream out, String keyspace, String ... columnFamilies) {
        this.out = out;
        this.keyspace = keyspace;
        this.columnFamilies = columnFamilies;
    }

    public boolean repairAndWait(StorageServiceMBean ssProxy, boolean isSequential, boolean primaryRangeOnly) throws InterruptedException {
        this.cmd = ssProxy.forceRepairAsync(this.keyspace, isSequential, primaryRangeOnly, this.columnFamilies);
        if (this.cmd > 0) {
            this.condition.await();
        } else {
            String message = String.format("[%s] Nothing to repair for keyspace '%s'", this.format.format(System.currentTimeMillis()), this.keyspace);
            this.out.println(message);
        }
        return this.success;
    }

    public boolean repairRangeAndWait(StorageServiceMBean ssProxy, boolean isSequential, String startToken, String endToken) throws InterruptedException {
        this.cmd = ssProxy.forceRepairRangeAsync(startToken, endToken, this.keyspace, isSequential, this.columnFamilies);
        if (this.cmd > 0) {
            this.condition.await();
        } else {
            String message = String.format("[%s] Nothing to repair for keyspace '%s'", this.format.format(System.currentTimeMillis()), this.keyspace);
            this.out.println(message);
        }
        return this.success;
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if ("repair".equals(notification.getType())) {
            int[] status = (int[])notification.getUserData();
            assert (status.length == 2);
            if (this.cmd == status[0]) {
                String message = String.format("[%s] %s", this.format.format(notification.getTimeStamp()), notification.getMessage());
                this.out.println(message);
                if (status[1] == AntiEntropyService.Status.SESSION_FAILED.ordinal()) {
                    this.success = false;
                } else if (status[1] == AntiEntropyService.Status.FINISHED.ordinal()) {
                    this.condition.signalAll();
                }
            }
        }
    }
}

