/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import javax.management.NotificationEmitter;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.UnavailableException;

public interface StorageServiceMBean
extends NotificationEmitter {
    public List<String> getLiveNodes();

    public List<String> getUnreachableNodes();

    public List<String> getJoiningNodes();

    public List<String> getLeavingNodes();

    public List<String> getMovingNodes();

    public String getToken();

    public String getReleaseVersion();

    public String getSchemaVersion();

    public String[] getAllDataFileLocations();

    public String getCommitLogLocation();

    public String getSavedCachesLocation();

    public Map<List<String>, List<String>> getRangeToEndpointMap(String var1);

    public Map<List<String>, List<String>> getRangeToRpcaddressMap(String var1);

    public List<String> describeRingJMX(String var1) throws InvalidRequestException;

    public List<String> getPrimaryRange();

    public Map<List<String>, List<String>> getPendingRangeToEndpointMap(String var1);

    public Map<String, String> getTokenToEndpointMap();

    public double getLoad();

    public String getLoadString();

    public Map<String, String> getLoadMap();

    public int getCurrentGenerationNumber();

    public List<InetAddress> getNaturalEndpoints(String var1, String var2, String var3);

    public List<InetAddress> getNaturalEndpoints(String var1, ByteBuffer var2);

    public void takeSnapshot(String var1, String ... var2) throws IOException;

    public void takeColumnFamilySnapshot(String var1, String var2, String var3) throws IOException;

    public void clearSnapshot(String var1, String ... var2) throws IOException;

    public void forceTableCompaction(String var1, String ... var2) throws IOException, ExecutionException, InterruptedException;

    public void forceTableCleanup(String var1, String ... var2) throws IOException, ExecutionException, InterruptedException;

    public void scrub(String var1, String ... var2) throws IOException, ExecutionException, InterruptedException;

    public void upgradeSSTables(String var1, String ... var2) throws IOException, ExecutionException, InterruptedException;

    public void forceTableFlush(String var1, String ... var2) throws IOException, ExecutionException, InterruptedException;

    public int forceRepairAsync(String var1, boolean var2, boolean var3, String ... var4);

    public int forceRepairRangeAsync(String var1, String var2, String var3, boolean var4, String ... var5);

    public void forceTableRepair(String var1, boolean var2, String ... var3) throws IOException;

    public void forceTableRepairPrimaryRange(String var1, boolean var2, String ... var3) throws IOException;

    public void forceTableRepairRange(String var1, String var2, String var3, boolean var4, String ... var5) throws IOException;

    public void forceTerminateAllRepairSessions();

    public void decommission() throws InterruptedException;

    public void move(String var1) throws IOException, InterruptedException, ConfigurationException;

    public void removeToken(String var1);

    public String getRemovalStatus();

    public void forceRemoveCompletion();

    public void setLog4jLevel(String var1, String var2);

    public String getOperationMode();

    public String getDrainProgress();

    public void drain() throws IOException, InterruptedException, ExecutionException;

    public void truncate(String var1, String var2) throws UnavailableException, TimeoutException, IOException;

    public Map<String, Float> getOwnership();

    public Map<String, Float> effectiveOwnership(String var1) throws ConfigurationException;

    public List<String> getKeyspaces();

    public void updateSnitch(String var1, Boolean var2, Integer var3, Integer var4, Double var5) throws ConfigurationException;

    public void stopGossiping();

    public void startGossiping();

    public boolean isInitialized();

    public void stopRPCServer();

    public void startRPCServer();

    public boolean isRPCServerRunning();

    public void joinRing() throws IOException, ConfigurationException;

    public boolean isJoined();

    public int getExceptionCount();

    public void setStreamThroughputMbPerSec(int var1);

    public int getStreamThroughputMbPerSec();

    public int getCompactionThroughputMbPerSec();

    public void setCompactionThroughputMbPerSec(int var1);

    public boolean isIncrementalBackupsEnabled();

    public void setIncrementalBackupsEnabled(boolean var1);

    public void rebuild(String var1);

    public void bulkLoad(String var1);

    public void rescheduleFailedDeletions();

    public void loadNewSSTables(String var1, String var2);

    public List<String> sampleKeyRange();

    public void rebuildSecondaryIndex(String var1, String var2, String ... var3);

    public void resetLocalSchema() throws IOException;
}

