/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.OutboundTcpConnection;
import org.apache.cassandra.security.SSLFactory;
import org.apache.cassandra.utils.FBUtilities;

public class OutboundTcpConnectionPool {
    private IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private final InetAddress id;
    public final OutboundTcpConnection cmdCon;
    public final OutboundTcpConnection ackCon;
    private InetAddress resetedEndpoint;

    OutboundTcpConnectionPool(InetAddress remoteEp) {
        this.id = remoteEp;
        this.cmdCon = new OutboundTcpConnection(this);
        this.cmdCon.start();
        this.ackCon = new OutboundTcpConnection(this);
        this.ackCon.start();
    }

    OutboundTcpConnection getConnection(Message msg) {
        Stage stage = msg.getMessageType();
        return stage == Stage.REQUEST_RESPONSE || stage == Stage.INTERNAL_RESPONSE || stage == Stage.GOSSIP ? this.ackCon : this.cmdCon;
    }

    synchronized void reset() {
        for (OutboundTcpConnection con : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            con.closeSocket(false);
        }
    }

    public void reset(InetAddress remoteEP) {
        this.resetedEndpoint = remoteEP;
        for (OutboundTcpConnection con : new OutboundTcpConnection[]{this.cmdCon, this.ackCon}) {
            con.softCloseSocket();
        }
    }

    public Socket newSocket() throws IOException {
        if (this.isEncryptedChannel()) {
            if (Config.getOutboundBindAny()) {
                return SSLFactory.getSocket(DatabaseDescriptor.getEncryptionOptions(), this.endPoint(), DatabaseDescriptor.getSSLStoragePort());
            }
            return SSLFactory.getSocket(DatabaseDescriptor.getEncryptionOptions(), this.endPoint(), DatabaseDescriptor.getSSLStoragePort(), FBUtilities.getLocalAddress(), 0);
        }
        if (Config.getOutboundBindAny()) {
            return new Socket(this.endPoint(), DatabaseDescriptor.getStoragePort());
        }
        return new Socket(this.endPoint(), DatabaseDescriptor.getStoragePort(), FBUtilities.getLocalAddress(), 0);
    }

    InetAddress endPoint() {
        return this.resetedEndpoint == null ? this.id : this.resetedEndpoint;
    }

    boolean isEncryptedChannel() {
        switch (DatabaseDescriptor.getEncryptionOptions().internode_encryption) {
            case none: {
                return false;
            }
            case all: {
                break;
            }
            case dc: {
                if (!this.snitch.getDatacenter(this.id).equals(this.snitch.getDatacenter(FBUtilities.getBroadcastAddress()))) break;
                return false;
            }
            case rack: {
                if (!this.snitch.getRack(this.id).equals(this.snitch.getRack(FBUtilities.getBroadcastAddress())) || !this.snitch.getDatacenter(this.id).equals(this.snitch.getDatacenter(FBUtilities.getBroadcastAddress()))) break;
                return false;
            }
        }
        return true;
    }
}

