/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.locator.AbstractNetworkTopologySnitch;
import org.apache.cassandra.locator.PropertyFileSnitch;
import org.apache.cassandra.locator.SnitchProperties;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GossipingPropertyFileSnitch
extends AbstractNetworkTopologySnitch {
    private static final Logger logger = LoggerFactory.getLogger(GossipingPropertyFileSnitch.class);
    private PropertyFileSnitch psnitch;
    private String myDC = SnitchProperties.get("dc", null);
    private String myRack = SnitchProperties.get("rack", null);

    public GossipingPropertyFileSnitch() throws ConfigurationException {
        if (this.myDC == null || this.myRack == null) {
            throw new ConfigurationException("DC or rack not found in snitch properties, Plz check your configuration in: cassandra-rackdc.properties");
        }
        try {
            this.psnitch = new PropertyFileSnitch();
            logger.info("Loaded cassandra-topology.properties for compatibility");
        }
        catch (ConfigurationException e) {
            logger.info("Unable to load cassandra-topology.properties; compatibility mode disabled");
        }
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.DC) == null) {
            if (this.psnitch == null) {
                throw new RuntimeException("Could not retrieve DC for " + endpoint + " from gossip and PFS compatibility is disabled");
            }
            return this.psnitch.getDatacenter(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.DC).value;
    }

    @Override
    public String getRack(InetAddress endpoint) {
        EndpointState epState = Gossiper.instance.getEndpointStateForEndpoint(endpoint);
        if (epState == null || epState.getApplicationState(ApplicationState.RACK) == null) {
            if (this.psnitch == null) {
                throw new RuntimeException("Could not retrieve rack for " + endpoint + " from gossip and PFS compatibility is disabled");
            }
            return this.psnitch.getRack(endpoint);
        }
        return epState.getApplicationState((ApplicationState)ApplicationState.RACK).value;
    }

    @Override
    public void gossiperStarting() {
        logger.info("Adding ApplicationState DC=" + this.myDC + " rack=" + this.myRack);
        Gossiper.instance.addLocalApplicationState(ApplicationState.DC, StorageService.instance.valueFactory.datacenter(this.myDC));
        Gossiper.instance.addLocalApplicationState(ApplicationState.RACK, StorageService.instance.valueFactory.rack(this.myRack));
    }
}

