/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.SequentialWriter;
import org.apache.cassandra.utils.CLibrary;

public class RandomAccessReader
extends RandomAccessFile
implements FileDataInput {
    public static final long CACHE_FLUSH_INTERVAL_IN_BYTES = (long)Math.pow(2.0, 27.0);
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    private final String filePath;
    protected byte[] buffer;
    protected long bufferOffset;
    protected long current = 0L;
    protected long markedPointer;
    protected int validBufferBytes = 0;
    protected final FileChannel channel = super.getChannel();
    private final boolean skipIOCache;
    private final int fd;
    private long bytesSinceCacheFlush = 0L;
    private final long fileLength;

    public RandomAccessReader(File file, int bufferSize, boolean skipIOCache) throws IOException {
        super(file, "r");
        this.filePath = file.getAbsolutePath();
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize must be positive");
        }
        this.buffer = new byte[bufferSize];
        this.skipIOCache = skipIOCache;
        this.fd = CLibrary.getfd(this.getFD());
        this.fileLength = this.channel.size();
        this.validBufferBytes = -1;
    }

    public static RandomAccessReader open(File file, boolean skipIOCache) throws IOException {
        return RandomAccessReader.open(file, 65536, skipIOCache);
    }

    public static RandomAccessReader open(File file) throws IOException {
        return RandomAccessReader.open(file, 65536, false);
    }

    public static RandomAccessReader open(File file, int bufferSize) throws IOException {
        return RandomAccessReader.open(file, bufferSize, false);
    }

    public static RandomAccessReader open(File file, int bufferSize, boolean skipIOCache) throws IOException {
        return new RandomAccessReader(file, bufferSize, skipIOCache);
    }

    public static RandomAccessReader open(SequentialWriter writer) throws IOException {
        return RandomAccessReader.open(new File(writer.getPath()), 65536);
    }

    protected void reBuffer() throws IOException {
        int read;
        int n;
        this.resetBuffer();
        if (this.bufferOffset >= this.channel.size()) {
            return;
        }
        this.channel.position(this.bufferOffset);
        for (read = 0; read < this.buffer.length && (n = super.read(this.buffer, read, this.buffer.length - read)) >= 0; read += n) {
        }
        this.validBufferBytes = read;
        this.bytesSinceCacheFlush += (long)read;
        if (this.skipIOCache && this.bytesSinceCacheFlush >= CACHE_FLUSH_INTERVAL_IN_BYTES) {
            CLibrary.trySkipCache(this.fd, 0L, 0);
            this.bytesSinceCacheFlush = 0L;
        }
    }

    @Override
    public long getFilePointer() {
        return this.current;
    }

    @Override
    public String getPath() {
        return this.filePath;
    }

    public void reset() throws IOException {
        this.seek(this.markedPointer);
    }

    public long bytesPastMark() {
        long bytes = this.current - this.markedPointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public FileMark mark() {
        this.markedPointer = this.current;
        return new BufferedRandomAccessFileMark(this.markedPointer);
    }

    @Override
    public void reset(FileMark mark) throws IOException {
        assert (mark instanceof BufferedRandomAccessFileMark);
        this.seek(((BufferedRandomAccessFileMark)mark).pointer);
    }

    @Override
    public long bytesPastMark(FileMark mark) {
        assert (mark instanceof BufferedRandomAccessFileMark);
        long bytes = this.current - ((BufferedRandomAccessFileMark)mark).pointer;
        assert (bytes >= 0L);
        return bytes;
    }

    @Override
    public boolean isEOF() throws IOException {
        return this.getFilePointer() == this.length();
    }

    @Override
    public long bytesRemaining() throws IOException {
        return this.length() - this.getFilePointer();
    }

    protected int bufferCursor() {
        return (int)(this.current - this.bufferOffset);
    }

    protected void resetBuffer() {
        this.bufferOffset = this.current;
        this.validBufferBytes = 0;
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
        if (this.skipIOCache && this.bytesSinceCacheFlush > 0L) {
            CLibrary.trySkipCache(this.fd, 0L, 0);
        }
        super.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + "filePath='" + this.filePath + "'" + ", skipIOCache=" + this.skipIOCache + ")";
    }

    @Override
    public void seek(long newPosition) throws IOException {
        if (newPosition < 0L) {
            throw new IllegalArgumentException("new position should not be negative");
        }
        if (newPosition > this.length()) {
            throw new EOFException(String.format("unable to seek to position %d in %s (%d bytes) in read-only mode", newPosition, this.getPath(), this.length()));
        }
        this.current = newPosition;
        if (newPosition > this.bufferOffset + (long)this.validBufferBytes || newPosition < this.bufferOffset) {
            this.reBuffer();
        }
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new ClosedChannelException();
        }
        if (this.isEOF()) {
            return -1;
        }
        if (this.current >= this.bufferOffset + (long)this.buffer.length || this.validBufferBytes == -1) {
            this.reBuffer();
        }
        assert (this.current >= this.bufferOffset && this.current < this.bufferOffset + (long)this.validBufferBytes);
        return this.buffer[(int)(this.current++ - this.bufferOffset)] & 0xFF;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read(byte[] buff, int offset, int length) throws IOException {
        if (this.buffer == null) {
            throw new ClosedChannelException();
        }
        if (length == 0) {
            return 0;
        }
        if (this.isEOF()) {
            return -1;
        }
        if (this.current >= this.bufferOffset + (long)this.buffer.length || this.validBufferBytes == -1) {
            this.reBuffer();
        }
        assert (this.current >= this.bufferOffset && this.current < this.bufferOffset + (long)this.validBufferBytes) : String.format("File (%s), current offset %d, buffer offset %d, buffer limit %d", this.getPath(), this.current, this.bufferOffset, this.validBufferBytes);
        int toCopy = Math.min(length, this.validBufferBytes - this.bufferCursor());
        System.arraycopy(this.buffer, this.bufferCursor(), buff, offset, toCopy);
        this.current += (long)toCopy;
        return toCopy;
    }

    @Override
    public ByteBuffer readBytes(int length) throws IOException {
        assert (length >= 0) : "buffer length should not be negative: " + length;
        byte[] buff = new byte[length];
        this.readFully(buff);
        return ByteBuffer.wrap(buff);
    }

    @Override
    public long length() throws IOException {
        return this.fileLength;
    }

    @Override
    public void write(int value) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected static class BufferedRandomAccessFileMark
    implements FileMark {
        long pointer;

        public BufferedRandomAccessFileMark(long pointer) {
            this.pointer = pointer;
        }
    }
}

