/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.PropertyDefinitions;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CFPropDefs
extends PropertyDefinitions {
    private static Logger logger = LoggerFactory.getLogger(CFPropDefs.class);
    public static final String KW_COMMENT = "comment";
    public static final String KW_READREPAIRCHANCE = "read_repair_chance";
    public static final String KW_DCLOCALREADREPAIRCHANCE = "dclocal_read_repair_chance";
    public static final String KW_GCGRACESECONDS = "gc_grace_seconds";
    public static final String KW_MINCOMPACTIONTHRESHOLD = "min_compaction_threshold";
    public static final String KW_MAXCOMPACTIONTHRESHOLD = "max_compaction_threshold";
    public static final String KW_REPLICATEONWRITE = "replicate_on_write";
    public static final String KW_COMPACTION_STRATEGY_CLASS = "compaction_strategy_class";
    public static final String KW_CACHING = "caching";
    public static final String KW_BF_FP_CHANCE = "bloom_filter_fp_chance";
    public static final Map<String, String> comparators = new HashMap<String, String>();
    public static final Set<String> keywords = new HashSet<String>();
    public static final Set<String> obsoleteKeywords = new HashSet<String>();
    public static final Set<String> allowedKeywords = new HashSet<String>();
    public static final String COMPACTION_OPTIONS_PREFIX = "compaction_strategy_options";
    public static final String COMPRESSION_PARAMETERS_PREFIX = "compression_parameters";
    private Class<? extends AbstractCompactionStrategy> compactionStrategyClass = null;
    public final Map<String, String> compactionStrategyOptions = new HashMap<String, String>();
    public final Map<String, String> compressionParameters = new HashMap<String, String>();

    public static AbstractType<?> parseType(String type) throws InvalidRequestException {
        try {
            String className = comparators.get(type.toLowerCase());
            if (className == null) {
                className = type;
            }
            return TypeParser.parse(className);
        }
        catch (ConfigurationException e) {
            InvalidRequestException ex = new InvalidRequestException(e.toString());
            ex.initCause((Throwable)e);
            throw ex;
        }
    }

    public void validate() throws ConfigurationException, InvalidRequestException {
        this.validate(keywords, obsoleteKeywords);
        if (this.properties.containsKey(KW_COMPACTION_STRATEGY_CLASS)) {
            this.compactionStrategyClass = CFMetaData.createCompactionStrategy((String)this.properties.get(KW_COMPACTION_STRATEGY_CLASS));
            this.compactionStrategyOptions.remove(KW_COMPACTION_STRATEGY_CLASS);
        }
    }

    @Override
    public void addProperty(String name, String value) throws InvalidRequestException {
        String[] composite = name.split(":");
        if (composite.length > 1) {
            if (composite[0].equals(COMPACTION_OPTIONS_PREFIX)) {
                this.compactionStrategyOptions.put(composite[1], value);
                return;
            }
            if (composite[0].equals(COMPRESSION_PARAMETERS_PREFIX)) {
                this.compressionParameters.put(composite[1], value);
                return;
            }
        }
        super.addProperty(name, value);
    }

    public void applyToCFMetadata(CFMetaData cfm) throws ConfigurationException, InvalidRequestException {
        if (this.hasProperty(KW_COMMENT).booleanValue()) {
            cfm.comment(this.getString(KW_COMMENT, ""));
        }
        cfm.readRepairChance(this.getDouble(KW_READREPAIRCHANCE, cfm.getReadRepairChance()));
        cfm.dcLocalReadRepairChance(this.getDouble(KW_DCLOCALREADREPAIRCHANCE, cfm.getDcLocalReadRepair()));
        cfm.gcGraceSeconds(this.getInt(KW_GCGRACESECONDS, cfm.getGcGraceSeconds()));
        cfm.replicateOnWrite(this.getBoolean(KW_REPLICATEONWRITE, cfm.getReplicateOnWrite()));
        cfm.minCompactionThreshold(CFPropDefs.toInt(KW_MINCOMPACTIONTHRESHOLD, this.compactionStrategyOptions.get(KW_MINCOMPACTIONTHRESHOLD), cfm.getMinCompactionThreshold()));
        cfm.maxCompactionThreshold(CFPropDefs.toInt(KW_MAXCOMPACTIONTHRESHOLD, this.compactionStrategyOptions.get(KW_MAXCOMPACTIONTHRESHOLD), cfm.getMaxCompactionThreshold()));
        cfm.caching(CFMetaData.Caching.fromString(this.getString(KW_CACHING, cfm.getCaching().toString())));
        cfm.bloomFilterFpChance(this.getDouble(KW_BF_FP_CHANCE, cfm.getBloomFilterFpChance()));
        if (this.compactionStrategyClass != null) {
            cfm.compactionStrategyClass(this.compactionStrategyClass);
            cfm.compactionStrategyOptions(new HashMap<String, String>(this.compactionStrategyOptions));
        }
        if (!this.compressionParameters.isEmpty()) {
            cfm.compressionParameters(CompressionParameters.create(this.compressionParameters));
        }
    }

    public String toString() {
        return String.format("CFPropDefs(%s, compaction: %s, compression: %s)", this.properties.toString(), this.compactionStrategyOptions.toString(), this.compressionParameters.toString());
    }

    static {
        comparators.put("ascii", "AsciiType");
        comparators.put("bigint", "LongType");
        comparators.put("blob", "BytesType");
        comparators.put("boolean", "BooleanType");
        comparators.put("counter", "CounterColumnType");
        comparators.put("decimal", "DecimalType");
        comparators.put("double", "DoubleType");
        comparators.put("float", "FloatType");
        comparators.put("int", "Int32Type");
        comparators.put("text", "UTF8Type");
        comparators.put("timestamp", "DateType");
        comparators.put("uuid", "UUIDType");
        comparators.put("varchar", "UTF8Type");
        comparators.put("varint", "IntegerType");
        comparators.put("timeuuid", "TimeUUIDType");
        keywords.add(KW_COMMENT);
        keywords.add(KW_READREPAIRCHANCE);
        keywords.add(KW_DCLOCALREADREPAIRCHANCE);
        keywords.add(KW_GCGRACESECONDS);
        keywords.add(KW_REPLICATEONWRITE);
        keywords.add(KW_COMPACTION_STRATEGY_CLASS);
        keywords.add(KW_CACHING);
        keywords.add(KW_BF_FP_CHANCE);
        allowedKeywords.addAll(keywords);
        allowedKeywords.addAll(obsoleteKeywords);
    }
}

