/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.compaction.AbstractCompactedRow;
import org.apache.cassandra.db.compaction.AbstractCompactionIterable;
import org.apache.cassandra.db.compaction.CompactionController;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.io.sstable.SSTableIdentityIterator;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.sstable.SSTableScanner;
import org.apache.cassandra.utils.CloseableIterator;
import org.apache.cassandra.utils.MergeIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionIterable
extends AbstractCompactionIterable {
    private static Logger logger = LoggerFactory.getLogger(CompactionIterable.class);
    private long row;
    private final List<SSTableScanner> scanners;
    private static final Comparator<IColumnIterator> comparator = new Comparator<IColumnIterator>(){

        @Override
        public int compare(IColumnIterator i1, IColumnIterator i2) {
            return i1.getKey().compareTo(i2.getKey());
        }
    };

    public CompactionIterable(OperationType type, Iterable<SSTableReader> sstables, CompactionController controller) throws IOException {
        this(type, CompactionIterable.getScanners(sstables), controller);
    }

    protected CompactionIterable(OperationType type, List<SSTableScanner> scanners, CompactionController controller) {
        super(controller, type);
        this.scanners = scanners;
        this.row = 0L;
        this.bytesRead = 0L;
        this.totalBytes = 0L;
        for (SSTableScanner scanner : scanners) {
            this.totalBytes += scanner.getFileLength();
        }
    }

    protected static List<SSTableScanner> getScanners(Iterable<SSTableReader> sstables) throws IOException {
        ArrayList<SSTableScanner> scanners = new ArrayList<SSTableScanner>();
        for (SSTableReader sstable : sstables) {
            scanners.add(sstable.getDirectScanner());
        }
        return scanners;
    }

    @Override
    public CloseableIterator<AbstractCompactedRow> iterator() {
        return MergeIterator.get(this.scanners, comparator, new Reducer());
    }

    public String toString() {
        return this.getCompactionInfo().toString();
    }

    protected class Reducer
    extends MergeIterator.Reducer<IColumnIterator, AbstractCompactedRow> {
        protected final List<SSTableIdentityIterator> rows = new ArrayList<SSTableIdentityIterator>();

        protected Reducer() {
        }

        @Override
        public void reduce(IColumnIterator current) {
            this.rows.add((SSTableIdentityIterator)current);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected AbstractCompactedRow getReduced() {
            assert (!this.rows.isEmpty());
            try {
                AbstractCompactedRow compactedRow = CompactionIterable.this.controller.getCompactedRow(new ArrayList<SSTableIdentityIterator>(this.rows));
                if (compactedRow.isEmpty()) {
                    CompactionIterable.this.controller.invalidateCachedRow(compactedRow.key);
                    AbstractCompactedRow abstractCompactedRow = null;
                    return abstractCompactedRow;
                }
                CompactionIterable.this.controller.invalidateCachedRow(compactedRow.key);
                AbstractCompactedRow abstractCompactedRow = compactedRow;
                return abstractCompactedRow;
            }
            finally {
                this.rows.clear();
                if (CompactionIterable.this.row++ % 1000L == 0L) {
                    long n = 0L;
                    for (SSTableScanner scanner : CompactionIterable.this.scanners) {
                        n += scanner.getFilePointer();
                    }
                    CompactionIterable.this.bytesRead = n;
                    CompactionIterable.this.throttle.throttle(CompactionIterable.this.bytesRead);
                }
            }
        }
    }
}

