/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.base.Function;
import java.util.Iterator;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.utils.Allocator;

public abstract class AbstractThreadUnsafeSortedColumns
implements ISortedColumns {
    private ISortedColumns.DeletionInfo deletionInfo = new ISortedColumns.DeletionInfo();

    @Override
    public ISortedColumns.DeletionInfo getDeletionInfo() {
        return this.deletionInfo;
    }

    @Override
    public void delete(ISortedColumns.DeletionInfo newInfo) {
        if (this.deletionInfo.markedForDeleteAt < newInfo.markedForDeleteAt) {
            this.deletionInfo = newInfo;
        }
    }

    @Override
    public void maybeResetDeletionTimes(int gcBefore) {
        if (this.deletionInfo.localDeletionTime <= gcBefore) {
            this.deletionInfo = new ISortedColumns.DeletionInfo();
        }
    }

    @Override
    public void retainAll(ISortedColumns columns) {
        Iterator iter = this.iterator();
        Iterator toRetain = columns.iterator();
        IColumn current = iter.hasNext() ? (IColumn)iter.next() : null;
        IColumn retain = toRetain.hasNext() ? (IColumn)toRetain.next() : null;
        AbstractType<?> comparator = this.getComparator();
        while (current != null && retain != null) {
            int c = comparator.compare(current.name(), retain.name());
            if (c == 0) {
                if (current instanceof SuperColumn) {
                    assert (retain instanceof SuperColumn);
                    ((SuperColumn)current).retainAll((SuperColumn)retain);
                }
                current = iter.hasNext() ? (IColumn)iter.next() : null;
                retain = toRetain.hasNext() ? (IColumn)toRetain.next() : null;
                continue;
            }
            if (c < 0) {
                iter.remove();
                current = iter.hasNext() ? (IColumn)iter.next() : null;
                continue;
            }
            retain = toRetain.hasNext() ? (IColumn)toRetain.next() : null;
        }
        while (current != null) {
            iter.remove();
            current = iter.hasNext() ? (IColumn)iter.next() : null;
        }
    }

    protected abstract void addAllColumns(ISortedColumns var1, Allocator var2, Function<IColumn, IColumn> var3);

    @Override
    public void addAll(ISortedColumns columns, Allocator allocator, Function<IColumn, IColumn> transformation) {
        this.addAllColumns(columns, allocator, transformation);
        this.delete(columns.getDeletionInfo());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int getEstimatedColumnCount() {
        return this.size();
    }
}

