/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.SchemaDisagreementException;
import org.apache.cassandra.thrift.ThriftValidation;

public class CreateKeyspaceStatement
extends SchemaAlteringStatement {
    private final String name;
    private final Map<String, String> attrs;
    private String strategyClass;
    private Map<String, String> strategyOptions = new HashMap<String, String>();

    public CreateKeyspaceStatement(String name, Map<String, String> attrs) {
        this.name = name;
        this.attrs = attrs;
    }

    @Override
    public void validate(ClientState state) throws InvalidRequestException, SchemaDisagreementException {
        super.validate(state);
        ThriftValidation.validateKeyspaceNotSystem(this.name);
        if (!this.name.matches("\\w+")) {
            throw new InvalidRequestException(String.format("\"%s\" is not a valid keyspace name", this.name));
        }
        if (this.name.length() > 32) {
            throw new InvalidRequestException(String.format("Keyspace names shouldn't be more than 32 character long (got \"%s\")", this.name));
        }
        if (!this.attrs.containsKey("strategy_class")) {
            throw new InvalidRequestException("missing required argument \"strategy_class\"");
        }
        this.strategyClass = this.attrs.get("strategy_class");
        for (String key : this.attrs.keySet()) {
            if (!key.contains(":") || !key.startsWith("strategy_options")) continue;
            this.strategyOptions.put(key.split(":")[1], this.attrs.get(key));
        }
        try {
            AbstractReplicationStrategy.createReplicationStrategy(this.name, AbstractReplicationStrategy.getClass(this.strategyClass), StorageService.instance.getTokenMetadata(), DatabaseDescriptor.getEndpointSnitch(), this.strategyOptions);
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        KsDef ksd = new KsDef(this.name, this.strategyClass, Collections.emptyList());
        ksd.setStrategy_options(this.strategyOptions);
        ThriftValidation.validateKsDef(ksd);
        ThriftValidation.validateKeyspaceNotYetExisting(this.name);
        MigrationManager.announceNewKeyspace(KSMetaData.fromThrift(ksd, new CFMetaData[0]));
    }
}

