/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CFPropDefs;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.CqlResult;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.commons.lang.StringUtils;

public class CreateColumnFamilyStatement
extends SchemaAlteringStatement {
    private AbstractType<?> comparator;
    private AbstractType<?> defaultValidator;
    private AbstractType<?> keyValidator;
    private ByteBuffer keyAlias;
    private List<ByteBuffer> columnAliases = new ArrayList<ByteBuffer>();
    private ByteBuffer valueAlias;
    private final Map<ColumnIdentifier, String> columns = new HashMap<ColumnIdentifier, String>();
    private final CFPropDefs properties;

    public CreateColumnFamilyStatement(CFName name, CFPropDefs properties) {
        super(name);
        this.properties = properties;
    }

    private Map<ByteBuffer, ColumnDefinition> getColumns() throws InvalidRequestException {
        HashMap<ByteBuffer, ColumnDefinition> columnDefs = new HashMap<ByteBuffer, ColumnDefinition>();
        for (Map.Entry<ColumnIdentifier, String> col : this.columns.entrySet()) {
            AbstractType<?> validator = CFPropDefs.parseType(col.getValue());
            columnDefs.put(col.getKey().key, new ColumnDefinition(col.getKey().key, validator, null, null, null));
        }
        return columnDefs;
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        CFMetaData cfmd = this.getCFMetaData();
        ThriftValidation.validateCfDef(cfmd.toThrift(), null);
        MigrationManager.announceNewColumnFamily(cfmd);
    }

    public CFMetaData getCFMetaData() throws InvalidRequestException {
        CFMetaData newCFMD;
        try {
            newCFMD = new CFMetaData(this.keyspace(), this.columnFamily(), ColumnFamilyType.Standard, this.comparator, null);
            newCFMD.comment(this.properties.get("comment")).readRepairChance(this.properties.getDouble("read_repair_chance", 0.1)).dcLocalReadRepairChance(this.properties.getDouble("dclocal_read_repair_chance", 0.0)).replicateOnWrite(this.properties.getBoolean("replicate_on_write", true)).gcGraceSeconds(this.properties.getInt("gc_grace_seconds", 864000)).defaultValidator(this.defaultValidator).minCompactionThreshold(this.properties.getInt("min_compaction_threshold", 4)).maxCompactionThreshold(this.properties.getInt("max_compaction_threshold", 32)).columnMetadata(this.getColumns()).keyValidator(this.keyValidator).keyAlias(this.keyAlias).columnAliases(this.columnAliases).valueAlias(this.valueAlias).compactionStrategyOptions(this.properties.compactionStrategyOptions).compressionParameters(CompressionParameters.create(this.properties.compressionParameters)).validate();
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        return newCFMD;
    }

    public static class RawStatement
    extends CFStatement {
        private final Map<ColumnIdentifier, String> definitions = new HashMap<ColumnIdentifier, String>();
        private final CFPropDefs properties = new CFPropDefs();
        private final List<ColumnIdentifier> keyAliases = new ArrayList<ColumnIdentifier>();
        private List<ColumnIdentifier> columnAliases = new ArrayList<ColumnIdentifier>();
        private boolean useCompactStorage;
        private Multiset<ColumnIdentifier> definedNames = HashMultiset.create((int)1);

        public RawStatement(CFName name) {
            super(name);
        }

        @Override
        public ParsedStatement.Prepared prepare() throws InvalidRequestException {
            try {
                if (!this.columnFamily().matches("\\w+")) {
                    throw new InvalidRequestException(String.format("\"%s\" is not a valid column family name (must be alphanumeric character only: [0-9A-Za-z]+)", this.columnFamily()));
                }
                if (this.columnFamily().length() > 32) {
                    throw new InvalidRequestException(String.format("Column family names shouldn't be more than 32 character long (got \"%s\")", this.columnFamily()));
                }
                for (Multiset.Entry entry : this.definedNames.entrySet()) {
                    if (entry.getCount() <= 1) continue;
                    throw new InvalidRequestException(String.format("Multiple definition of identifier %s", entry.getElement()));
                }
                this.properties.validate();
                CreateColumnFamilyStatement stmt = new CreateColumnFamilyStatement(this.cfName, this.properties);
                stmt.setBoundTerms(this.getBoundsTerms());
                stmt.columns.putAll(this.definitions);
                if (this.keyAliases.size() == 0) {
                    throw new InvalidRequestException("You must specify a PRIMARY KEY");
                }
                if (this.keyAliases.size() > 1) {
                    throw new InvalidRequestException("You may only specify one PRIMARY KEY");
                }
                stmt.keyAlias = this.keyAliases.get((int)0).key;
                stmt.keyValidator = RawStatement.getTypeAndRemove(stmt.columns, this.keyAliases.get(0));
                if (this.columnAliases != null && !this.columnAliases.isEmpty()) {
                    if (this.useCompactStorage && this.columnAliases.size() == 1) {
                        stmt.columnAliases.add(this.columnAliases.get((int)0).key);
                        stmt.comparator = RawStatement.getTypeAndRemove(stmt.columns, this.columnAliases.get(0));
                    } else {
                        ArrayList types = new ArrayList();
                        for (ColumnIdentifier t : this.columnAliases) {
                            stmt.columnAliases.add(t.key);
                            types.add(RawStatement.getTypeAndRemove(stmt.columns, t));
                        }
                        if (!this.useCompactStorage) {
                            types.add(CFDefinition.definitionType);
                        }
                        if (types.isEmpty()) {
                            throw new IllegalStateException("Nonsensical empty parameter list for CompositeType");
                        }
                        stmt.comparator = CompositeType.getInstance(types);
                    }
                } else {
                    stmt.comparator = CFDefinition.definitionType;
                }
                if (this.useCompactStorage) {
                    if (stmt.columns.isEmpty()) {
                        throw new InvalidRequestException("COMPACT STORAGE requires one definition not part of the PRIMARY KEY, none found");
                    }
                    if (stmt.columns.size() > 1) {
                        throw new InvalidRequestException(String.format("COMPACT STORAGE allows only one column not part of the PRIMARY KEY (got: %s)", StringUtils.join(stmt.columns.keySet(), (String)", ")));
                    }
                    Map.Entry lastEntry = stmt.columns.entrySet().iterator().next();
                    stmt.defaultValidator = CFPropDefs.parseType((String)lastEntry.getValue());
                    stmt.valueAlias = ((ColumnIdentifier)lastEntry.getKey()).key;
                    stmt.columns.remove(lastEntry.getKey());
                } else {
                    if (stmt.columns.isEmpty()) {
                        throw new InvalidRequestException("No definition found that is not part of the PRIMARY KEY");
                    }
                    stmt.defaultValidator = CFDefinition.definitionType;
                }
                return new ParsedStatement.Prepared(stmt);
            }
            catch (ConfigurationException e) {
                throw new InvalidRequestException(e.getMessage());
            }
        }

        private static AbstractType<?> getTypeAndRemove(Map<ColumnIdentifier, String> columns, ColumnIdentifier t) throws InvalidRequestException, ConfigurationException {
            String typeStr = columns.get(t);
            if (typeStr == null) {
                throw new InvalidRequestException(String.format("Unkown definition %s referenced in PRIMARY KEY", t));
            }
            columns.remove(t);
            return CFPropDefs.parseType(typeStr);
        }

        public void addDefinition(ColumnIdentifier def, String type) {
            this.definedNames.add((Object)def);
            this.definitions.put(def, type);
        }

        public void setKeyAlias(ColumnIdentifier alias) {
            this.keyAliases.add(alias);
        }

        public void addColumnAlias(ColumnIdentifier alias) {
            this.columnAliases.add(alias);
        }

        public void addProperty(String name, String value) {
            this.properties.addProperty(name, value);
        }

        public void setCompactStorage() {
            this.useCompactStorage = true;
        }

        public void checkAccess(ClientState state) {
            throw new UnsupportedOperationException();
        }

        public CqlResult execute(ClientState state, List<ByteBuffer> variables) {
            throw new UnsupportedOperationException();
        }
    }
}

