/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.cql3.CFDefinition;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CFPropDefs;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.ThriftValidation;

public class AlterTableStatement
extends SchemaAlteringStatement {
    public final Type oType;
    public final String validator;
    public final ColumnIdentifier columnName;
    private final CFPropDefs cfProps = new CFPropDefs();

    public AlterTableStatement(CFName name, Type type, ColumnIdentifier columnName, String validator, Map<String, String> propertyMap) {
        super(name);
        this.oType = type;
        this.columnName = null;
        this.validator = validator;
        this.cfProps.addAll(propertyMap);
    }

    @Override
    public void announceMigration() throws InvalidRequestException, ConfigurationException {
        CFMetaData meta = ThriftValidation.validateColumnFamily(this.keyspace(), this.columnFamily());
        CfDef thriftDef = meta.toThrift();
        CFDefinition cfDef = meta.getCfDef();
        CFDefinition.Name name = this.oType == Type.OPTS ? null : cfDef.get(this.columnName);
        switch (this.oType) {
            case ADD: {
                if (cfDef.isCompact) {
                    throw new InvalidRequestException("Cannot add new column to a compact CF");
                }
                if (name != null) {
                    switch (name.kind) {
                        case KEY_ALIAS: 
                        case COLUMN_ALIAS: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with a PRIMARY KEY part", this.columnName));
                        }
                        case COLUMN_METADATA: {
                            throw new InvalidRequestException(String.format("Invalid column name %s because it conflicts with an existing column", this.columnName));
                        }
                    }
                }
                thriftDef.column_metadata.add(new ColumnDefinition(this.columnName.key, CFPropDefs.parseType(this.validator), null, null, null).toThrift());
                break;
            }
            case ALTER: {
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in CF %s", this.columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: {
                        thriftDef.key_validation_class = CFPropDefs.parseType(this.validator).toString();
                        break;
                    }
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("Cannot alter PRIMARY KEY part %s", this.columnName));
                    }
                    case VALUE_ALIAS: {
                        thriftDef.default_validation_class = CFPropDefs.parseType(this.validator).toString();
                        break;
                    }
                    case COLUMN_METADATA: {
                        ColumnDefinition column = meta.getColumnDefinition(this.columnName.key);
                        column.setValidator(CFPropDefs.parseType(this.validator));
                        thriftDef.column_metadata.add(column.toThrift());
                    }
                }
                break;
            }
            case DROP: {
                if (cfDef.isCompact) {
                    throw new InvalidRequestException("Cannot drop columns from a compact CF");
                }
                if (name == null) {
                    throw new InvalidRequestException(String.format("Column %s was not found in CF %s", this.columnName, this.columnFamily()));
                }
                switch (name.kind) {
                    case KEY_ALIAS: 
                    case COLUMN_ALIAS: {
                        throw new InvalidRequestException(String.format("Cannot drop PRIMARY KEY part %s", this.columnName));
                    }
                    case COLUMN_METADATA: {
                        ColumnDef toDelete = null;
                        for (ColumnDef columnDef : thriftDef.column_metadata) {
                            if (!columnDef.name.equals(this.columnName.key)) continue;
                            toDelete = columnDef;
                        }
                        assert (toDelete != null);
                        thriftDef.column_metadata.remove(toDelete);
                    }
                }
                break;
            }
            case OPTS: {
                if (this.cfProps == null) {
                    throw new InvalidRequestException(String.format("ALTER COLUMNFAMILY WITH invoked, but no parameters found", new Object[0]));
                }
                this.cfProps.validate();
                AlterTableStatement.applyPropertiesToCfDef(thriftDef, this.cfProps);
            }
        }
        MigrationManager.announceColumnFamilyUpdate(CFMetaData.fromThrift(thriftDef));
    }

    public static void applyPropertiesToCfDef(CfDef cfDef, CFPropDefs cfProps) throws InvalidRequestException {
        if (cfProps.hasProperty("comment").booleanValue()) {
            cfDef.comment = cfProps.get("comment");
        }
        cfDef.read_repair_chance = cfProps.getDouble("read_repair_chance", cfDef.read_repair_chance);
        cfDef.dclocal_read_repair_chance = cfProps.getDouble("dclocal_read_repair_chance", cfDef.dclocal_read_repair_chance);
        cfDef.gc_grace_seconds = cfProps.getInt("gc_grace_seconds", cfDef.gc_grace_seconds);
        cfDef.replicate_on_write = cfProps.getBoolean("replicate_on_write", cfDef.replicate_on_write);
        cfDef.min_compaction_threshold = cfProps.getInt("min_compaction_threshold", cfDef.min_compaction_threshold);
        cfDef.max_compaction_threshold = cfProps.getInt("max_compaction_threshold", cfDef.max_compaction_threshold);
        if (!cfProps.compactionStrategyOptions.isEmpty()) {
            cfDef.compaction_strategy_options = new HashMap<String, String>(cfProps.compactionStrategyOptions);
        }
        if (!cfProps.compressionParameters.isEmpty()) {
            cfDef.compression_options = new HashMap<String, String>(cfProps.compressionParameters);
        }
    }

    public String toString() {
        return String.format("AlterTableStatement(name=%s, type=%s, column=%s, validator=%s)", new Object[]{this.cfName, this.oType, this.columnName, this.validator});
    }

    public static enum Type {
        ADD,
        ALTER,
        DROP,
        OPTS;

    }
}

