/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.utils.Pair;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    private static final Logger logger = LoggerFactory.getLogger(Schema.class);
    public static final Schema instance = new Schema();
    private static final int MIN_CF_ID = 1000;
    private final AtomicInteger cfIdGen = new AtomicInteger(1000);
    private final Map<String, KSMetaData> tables = new NonBlockingHashMap();
    private final Map<String, Table> tableInstances = new NonBlockingHashMap();
    private final BiMap<Pair<String, String>, Integer> cfIdMap = HashBiMap.create();
    private volatile UUID version;
    private final ReadWriteLock versionLock = new ReentrantReadWriteLock();

    public Schema load(Collection<KSMetaData> tableDefs) {
        for (KSMetaData def : tableDefs) {
            this.load(def);
        }
        return this;
    }

    public Schema load(KSMetaData keyspaceDef) {
        for (CFMetaData cfm : keyspaceDef.cfMetaData().values()) {
            this.load(cfm);
        }
        this.setTableDefinition(keyspaceDef);
        this.fixCFMaxId();
        return this;
    }

    public Table getTableInstance(String tableName) {
        return this.tableInstances.get(tableName);
    }

    public void storeTableInstance(Table table) {
        if (this.tableInstances.containsKey(table.name)) {
            throw new IllegalArgumentException(String.format("Table %s was already initialized.", table.name));
        }
        this.tableInstances.put(table.name, table);
    }

    public Table removeTableInstance(String tableName) {
        return this.tableInstances.remove(tableName);
    }

    public void clearTableDefinition(KSMetaData ksm) {
        this.tables.remove(ksm.name);
    }

    public CFMetaData getCFMetaData(String tableName, String cfName) {
        assert (tableName != null);
        KSMetaData ksm = this.tables.get(tableName);
        return ksm == null ? null : ksm.cfMetaData().get(cfName);
    }

    public CFMetaData getCFMetaData(Integer cfId) {
        Pair<String, String> cf = this.getCF(cfId);
        return cf == null ? null : this.getCFMetaData((String)cf.left, (String)cf.right);
    }

    public CFMetaData getCFMetaData(Descriptor descriptor) {
        return this.getCFMetaData(descriptor.ksname, descriptor.cfname);
    }

    public ColumnFamilyType getColumnFamilyType(String ksName, String cfName) {
        assert (ksName != null && cfName != null);
        CFMetaData cfMetaData = this.getCFMetaData(ksName, cfName);
        return cfMetaData == null ? null : cfMetaData.cfType;
    }

    public AbstractType<?> getComparator(String ksName, String cfName) {
        assert (ksName != null);
        CFMetaData cfmd = this.getCFMetaData(ksName, cfName);
        if (cfmd == null) {
            throw new IllegalArgumentException("Unknown ColumnFamily " + cfName + " in keyspace " + ksName);
        }
        return cfmd.comparator;
    }

    public AbstractType<?> getSubComparator(String ksName, String cfName) {
        assert (ksName != null);
        return this.getCFMetaData((String)ksName, (String)cfName).subcolumnComparator;
    }

    public AbstractType<?> getValueValidator(String ksName, String cfName, ByteBuffer column) {
        return this.getCFMetaData(ksName, cfName).getValueValidator(column);
    }

    public KSMetaData getKSMetaData(String table) {
        assert (table != null);
        return this.tables.get(table);
    }

    public List<String> getNonSystemTables() {
        ArrayList<String> tablesList = new ArrayList<String>(this.tables.keySet());
        tablesList.remove("system");
        return Collections.unmodifiableList(tablesList);
    }

    public KSMetaData getTableDefinition(String table) {
        return this.getKSMetaData(table);
    }

    public Map<String, CFMetaData> getTableMetaData(String tableName) {
        assert (tableName != null);
        KSMetaData ksm = this.tables.get(tableName);
        assert (ksm != null);
        return ksm.cfMetaData();
    }

    public Set<String> getTables() {
        return this.tables.keySet();
    }

    public Collection<KSMetaData> getTableDefinitions() {
        return this.tables.values();
    }

    public void setTableDefinition(KSMetaData ksm) {
        if (ksm != null) {
            this.tables.put(ksm.name, ksm);
        }
    }

    public void addSystemTable(KSMetaData systemTable) {
        this.tables.put(systemTable.name, systemTable);
    }

    public Pair<String, String> getCF(Integer cfId) {
        return (Pair)this.cfIdMap.inverse().get((Object)cfId);
    }

    public Integer getId(String ksName, String cfName) {
        return (Integer)this.cfIdMap.get(new Pair<String, String>(ksName, cfName));
    }

    public void load(CFMetaData cfm) {
        Pair<String, String> key = new Pair<String, String>(cfm.ksName, cfm.cfName);
        if (this.cfIdMap.containsKey(key)) {
            throw new RuntimeException(String.format("Attempting to load already loaded column family %s.%s", cfm.ksName, cfm.cfName));
        }
        logger.debug("Adding {} to cfIdMap", (Object)cfm);
        this.cfIdMap.put(key, (Object)cfm.cfId);
        this.fixCFMaxId();
    }

    public void purge(CFMetaData cfm) {
        this.cfIdMap.remove(new Pair<String, String>(cfm.ksName, cfm.cfName));
    }

    public void fixCFMaxId() {
        int inMap;
        int nval;
        int cval;
        while (!this.cfIdGen.compareAndSet(cval = this.cfIdGen.get(), nval = Math.max(Math.max(inMap = this.cfIdMap.isEmpty() ? 0 : (Integer)Collections.max(this.cfIdMap.values()) + 1, cval), 1000))) {
        }
    }

    public int nextCFId() {
        return this.cfIdGen.getAndIncrement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getVersion() {
        this.versionLock.readLock().lock();
        try {
            UUID uUID = this.version;
            return uUID;
        }
        finally {
            this.versionLock.readLock().unlock();
        }
    }

    public void updateVersion() {
        this.versionLock.writeLock().lock();
        try {
            MessageDigest versionDigest = MessageDigest.getInstance("MD5");
            for (Row row : SystemTable.serializedSchema()) {
                if (row.cf == null || row.cf.isMarkedForDelete() || row.cf.isEmpty()) continue;
                row.cf.updateDigest(versionDigest);
            }
            this.version = UUID.nameUUIDFromBytes(versionDigest.digest());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.versionLock.writeLock().unlock();
        }
    }

    public void updateVersionAndAnnounce() {
        this.updateVersion();
        MigrationManager.passiveAnnounce(this.version);
    }

    public synchronized void clear() {
        for (String table : this.getNonSystemTables()) {
            KSMetaData ksm = this.getTableDefinition(table);
            for (CFMetaData cfm : ksm.cfMetaData().values()) {
                this.purge(cfm);
            }
            this.clearTableDefinition(ksm);
        }
        this.updateVersionAndAnnounce();
        this.fixCFMaxId();
    }
}

