/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

public class BigLongArray {
    private static final int DEFAULT_PAGE_SIZE = 4096;
    private final long[][] pages;
    public final int size;
    private final int pageSize;
    private final int pageCount;

    public BigLongArray(int size) {
        this(size, 4096);
    }

    public BigLongArray(int size, int pageSize) {
        this.size = size;
        this.pageSize = pageSize;
        int lastPageSize = size % pageSize;
        int fullPageCount = size / pageSize;
        this.pageCount = fullPageCount + (lastPageSize == 0 ? 0 : 1);
        this.pages = new long[this.pageCount][];
        for (int i = 0; i < fullPageCount; ++i) {
            this.pages[i] = new long[pageSize];
        }
        if (lastPageSize != 0) {
            this.pages[this.pages.length - 1] = new long[lastPageSize];
        }
    }

    public void set(int idx, long value) {
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException(String.format("%d is not whithin [0, %d)", idx, this.size));
        }
        int page = idx / this.pageSize;
        int pageIdx = idx % this.pageSize;
        this.pages[page][pageIdx] = value;
    }

    public long get(int idx) {
        if (idx < 0 || idx > this.size) {
            throw new IndexOutOfBoundsException(String.format("%d is not whithin [0, %d)", idx, this.size));
        }
        int page = idx / this.pageSize;
        int pageIdx = idx % this.pageSize;
        return this.pages[page][pageIdx];
    }
}

