/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.CreationTimeAwareFuture;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.SimpleCondition;

public abstract class AbstractWriteResponseHandler
implements IWriteResponseHandler {
    protected final SimpleCondition condition = new SimpleCondition();
    protected final long startTime = System.currentTimeMillis();
    protected final Collection<InetAddress> writeEndpoints;
    protected final ConsistencyLevel consistencyLevel;
    protected List<CreationTimeAwareFuture<?>> hintFutures;

    protected AbstractWriteResponseHandler(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        this.writeEndpoints = writeEndpoints;
    }

    @Override
    public void get() throws TimeoutException {
        boolean success;
        if (this.hintFutures != null) {
            AbstractWriteResponseHandler.waitForHints(this.hintFutures);
        }
        long timeout = DatabaseDescriptor.getRpcTimeout() - (System.currentTimeMillis() - this.startTime);
        try {
            success = this.condition.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new AssertionError((Object)ex);
        }
        if (!success) {
            throw new TimeoutException();
        }
    }

    @Override
    public void addFutureForHint(CreationTimeAwareFuture<?> hintFuture) {
        if (this.hintFutures == null) {
            this.hintFutures = new ArrayList(this.writeEndpoints.size());
        }
        this.hintFutures.add(hintFuture);
    }

    protected static void waitForHints(List<CreationTimeAwareFuture<?>> hintFutures) throws TimeoutException {
        try {
            FBUtilities.waitOnFutures(hintFutures, DatabaseDescriptor.getRpcTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException e) {
            if (e.getCause() != null && e.getCause() instanceof ExecutionException) {
                throw new TimeoutException();
            }
            throw e;
        }
    }

    @Override
    public abstract void response(Message var1);

    @Override
    public abstract void assureSufficientLiveNodes() throws UnavailableException;
}

