/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.AbstractColumnContainer;
import org.apache.cassandra.db.Column;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.CounterColumn;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.ExpiringColumn;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.context.CounterContext;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.io.sstable.Component;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableMetadata;
import org.apache.cassandra.io.sstable.SSTableWriter;
import org.apache.cassandra.utils.NodeId;
import org.apache.cassandra.utils.Pair;

public abstract class AbstractSSTableSimpleWriter {
    protected final File directory;
    protected final CFMetaData metadata;
    protected DecoratedKey currentKey;
    protected ColumnFamily columnFamily;
    protected SuperColumn currentSuperColumn;
    protected final NodeId nodeid = NodeId.generate();

    public AbstractSSTableSimpleWriter(File directory, CFMetaData metadata, IPartitioner partitioner) {
        this.metadata = metadata;
        this.directory = directory;
        DatabaseDescriptor.setPartitioner(partitioner);
    }

    protected SSTableWriter getWriter() throws IOException {
        return new SSTableWriter(AbstractSSTableSimpleWriter.makeFilename(this.directory, this.metadata.ksName, this.metadata.cfName), 0L, this.metadata, DatabaseDescriptor.getPartitioner(), SSTableMetadata.createCollector());
    }

    private static String makeFilename(File directory, String keyspace, final String columnFamily) {
        final HashSet existing = new HashSet();
        directory.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Descriptor desc;
                Pair<Descriptor, Component> p = SSTable.tryComponentFromFilename(dir, name);
                Descriptor descriptor = desc = p == null ? null : (Descriptor)p.left;
                if (desc == null) {
                    return false;
                }
                if (desc.cfname.equals(columnFamily)) {
                    existing.add(desc);
                }
                return false;
            }
        });
        int maxGen = 0;
        for (Descriptor desc : existing) {
            maxGen = Math.max(maxGen, desc.generation);
        }
        return new Descriptor(directory, keyspace, columnFamily, maxGen + 1, false).filenameFor(Component.DATA);
    }

    public void newRow(ByteBuffer key) throws IOException {
        if (this.currentKey != null && !this.columnFamily.isEmpty()) {
            this.writeRow(this.currentKey, this.columnFamily);
        }
        this.currentKey = DatabaseDescriptor.getPartitioner().decorateKey(key);
        this.columnFamily = this.getColumnFamily();
    }

    public void newSuperColumn(ByteBuffer name) {
        if (!this.columnFamily.isSuper()) {
            throw new IllegalStateException("Cannot add a super column to a standard column family");
        }
        this.currentSuperColumn = new SuperColumn(name, this.metadata.subcolumnComparator);
        this.columnFamily.addColumn(this.currentSuperColumn);
    }

    private void addColumn(IColumn column) {
        if (this.columnFamily.isSuper() && this.currentSuperColumn == null) {
            throw new IllegalStateException("Trying to add a column to a super column family, but no super column has been started.");
        }
        AbstractColumnContainer container = this.columnFamily.isSuper() ? this.currentSuperColumn : this.columnFamily;
        container.addColumn(column);
    }

    public void addColumn(ByteBuffer name, ByteBuffer value, long timestamp) {
        this.addColumn(new Column(name, value, timestamp));
    }

    public void addExpiringColumn(ByteBuffer name, ByteBuffer value, long timestamp, int ttl, long expirationTimestampMS) {
        this.addColumn(new ExpiringColumn(name, value, timestamp, ttl, (int)(expirationTimestampMS / 1000L)));
    }

    public void addCounterColumn(ByteBuffer name, long value) {
        this.addColumn(new CounterColumn(name, CounterContext.instance().create(this.nodeid, 1L, value, false), System.currentTimeMillis()));
    }

    public abstract void close() throws IOException;

    protected abstract void writeRow(DecoratedKey var1, ColumnFamily var2) throws IOException;

    protected abstract ColumnFamily getColumnFamily();
}

