/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.MigrationHelper;
import org.apache.cassandra.thrift.KsDef;

public class UpdateKeyspace
extends Migration {
    private final KsDef newState;

    public UpdateKeyspace(KsDef newState) throws ConfigurationException {
        super(System.nanoTime());
        if (newState.isSetCf_defs() && newState.getCf_defs().size() > 0) {
            throw new ConfigurationException("Updated keyspace must not contain any column families.");
        }
        if (Schema.instance.getKSMetaData(newState.name) == null) {
            throw new ConfigurationException(newState.name + " cannot be updated because it doesn't exist.");
        }
        this.newState = newState;
    }

    @Override
    protected void applyImpl() throws ConfigurationException, IOException {
        MigrationHelper.updateKeyspace(this.newState, this.timestamp);
        logger.info("Keyspace updated. Please perform any manual operations.");
    }

    public String toString() {
        return String.format("Update keyspace %s with %s", this.newState.name, this.newState);
    }
}

