/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.migration.Migration;
import org.apache.cassandra.db.migration.MigrationHelper;
import org.apache.cassandra.thrift.CfDef;

public class UpdateColumnFamily
extends Migration {
    private final CfDef newState;

    public UpdateColumnFamily(CfDef newState) throws ConfigurationException {
        super(System.nanoTime());
        if (Schema.instance.getCFMetaData(newState.keyspace, newState.name) == null) {
            throw new ConfigurationException(String.format("(ks=%s, cf=%s) cannot be updated because it doesn't exist.", newState.keyspace, newState.name));
        }
        this.newState = newState;
    }

    @Override
    protected void applyImpl() throws ConfigurationException, IOException {
        MigrationHelper.updateColumnFamily(this.newState, this.timestamp);
    }

    public String toString() {
        return String.format("Update column family with %s", this.newState);
    }
}

