/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.migration;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.migration.MigrationHelper;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.UUIDGen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Migration {
    protected static final Logger logger = LoggerFactory.getLogger(Migration.class);
    public static final String NAME_VALIDATOR_REGEX = "\\w+";
    public static final String MIGRATIONS_CF = "Migrations";
    public static final String SCHEMA_CF = "Schema";
    public static final ByteBuffer LAST_MIGRATION_KEY = ByteBufferUtil.bytes("Last Migration");
    protected final long timestamp;

    Migration(long modificationTimestamp) {
        this.timestamp = modificationTimestamp;
    }

    public final void apply() throws ConfigurationException, IOException {
        this.applyImpl();
        if (!StorageService.instance.isClientMode()) {
            MigrationHelper.flushSchemaCFs();
        }
        Schema.instance.updateVersion();
    }

    protected abstract void applyImpl() throws ConfigurationException, IOException;

    public final void announce() {
        assert (!StorageService.instance.isClientMode());
        MigrationManager.announce(SystemTable.serializeSchema());
        this.passiveAnnounce();
    }

    public final void passiveAnnounce() {
        MigrationManager.passiveAnnounce(Schema.instance.getVersion());
    }

    @Deprecated
    public static UUID getLastMigrationId() {
        QueryFilter filter;
        DecoratedKey dkey = StorageService.getPartitioner().decorateKey(LAST_MIGRATION_KEY);
        Table defs = Table.open("system");
        ColumnFamilyStore cfStore = defs.getColumnFamilyStore(SCHEMA_CF);
        ColumnFamily cf = cfStore.getColumnFamily(filter = QueryFilter.getNamesFilter(dkey, new QueryPath(SCHEMA_CF), LAST_MIGRATION_KEY));
        if (cf == null || cf.getColumnNames().size() == 0) {
            return null;
        }
        return UUIDGen.getUUID(cf.getColumn(LAST_MIGRATION_KEY).value());
    }

    public static boolean isLegalName(String s) {
        return s.matches(NAME_VALIDATOR_REGEX);
    }
}

