/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.columniterator;

import com.google.common.collect.AbstractIterator;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.columniterator.IColumnIterator;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.sstable.IndexHelper;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.io.util.FileDataInput;
import org.apache.cassandra.io.util.FileMark;

class SimpleSliceReader
extends AbstractIterator<IColumn>
implements IColumnIterator {
    private final FileDataInput file;
    private final ByteBuffer finishColumn;
    private final AbstractType<?> comparator;
    private final ColumnFamily emptyColumnFamily;
    private final int columns;
    private int i;
    private FileMark mark;

    public SimpleSliceReader(SSTableReader sstable, FileDataInput input, ByteBuffer finishColumn) {
        this.file = input;
        this.finishColumn = finishColumn;
        this.comparator = sstable.metadata.comparator;
        try {
            IndexHelper.skipBloomFilter(this.file);
            IndexHelper.skipIndex(this.file);
            this.emptyColumnFamily = ColumnFamily.serializer().deserializeFromSSTableNoColumns(ColumnFamily.create(sstable.metadata), this.file);
            this.columns = this.file.readInt();
            this.mark = this.file.mark();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected IColumn computeNext() {
        IColumn column;
        if (this.i++ >= this.columns) {
            return (IColumn)this.endOfData();
        }
        try {
            this.file.reset(this.mark);
            column = (IColumn)this.emptyColumnFamily.getColumnSerializer().deserialize(this.file);
        }
        catch (IOException e) {
            throw new RuntimeException("error reading " + this.i + " of " + this.columns, e);
        }
        if (this.finishColumn.remaining() > 0 && this.comparator.compare(column.name(), this.finishColumn) > 0) {
            return (IColumn)this.endOfData();
        }
        this.mark = this.file.mark();
        return column;
    }

    @Override
    public ColumnFamily getColumnFamily() {
        return this.emptyColumnFamily;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public DecoratedKey getKey() {
        throw new UnsupportedOperationException();
    }
}

