/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificRecord;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.migration.MigrationHelper;
import org.apache.cassandra.db.migration.avro.KsDef;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefsTable {
    private static final Logger logger = LoggerFactory.getLogger(DefsTable.class);
    private static final DecoderFactory DIRECT_DECODERS = new DecoderFactory().configureDirectDecoder(true);
    public static final ByteBuffer DEFINITION_SCHEMA_COLUMN_NAME = ByteBufferUtil.bytes("Avro/Schema");

    public static synchronized void dumpToStorage(Collection<KSMetaData> keyspaces) throws IOException {
        long timestamp = System.currentTimeMillis();
        for (KSMetaData ksMetaData : keyspaces) {
            ksMetaData.toSchema(timestamp).apply();
        }
    }

    public static Collection<KSMetaData> loadFromTable() throws IOException {
        List<Row> serializedSchema = SystemTable.serializedSchema("schema_keyspaces");
        ArrayList<KSMetaData> keyspaces = new ArrayList<KSMetaData>();
        for (Row row : serializedSchema) {
            if (row.cf == null || row.cf.isEmpty() || row.cf.isMarkedForDelete()) continue;
            keyspaces.add(KSMetaData.fromSchema(row.cf, DefsTable.serializedColumnFamilies(row.key)));
        }
        return keyspaces;
    }

    private static ColumnFamily serializedColumnFamilies(DecoratedKey ksNameKey) {
        ColumnFamilyStore cfsStore = SystemTable.schemaCFS("schema_columnfamilies");
        return cfsStore.getColumnFamily(QueryFilter.getIdentityFilter(ksNameKey, new QueryPath("schema_columnfamilies")));
    }

    public static synchronized Collection<KSMetaData> loadFromStorage(UUID version) throws IOException {
        DecoratedKey vkey = StorageService.getPartitioner().decorateKey(DefsTable.toUTF8Bytes(version));
        Table defs = Table.open("system");
        ColumnFamilyStore cfStore = defs.getColumnFamilyStore("Schema");
        ColumnFamily cf = cfStore.getColumnFamily(QueryFilter.getIdentityFilter(vkey, new QueryPath("Schema")));
        IColumn avroschema = cf.getColumn(DEFINITION_SCHEMA_COLUMN_NAME);
        List<KSMetaData> keyspaces = Collections.emptyList();
        if (avroschema != null) {
            ByteBuffer value = avroschema.value();
            Schema schema = Schema.parse((String)ByteBufferUtil.string(value));
            keyspaces = new ArrayList<KSMetaData>();
            for (IColumn column : cf.getSortedColumns()) {
                if (column.name().equals(DEFINITION_SCHEMA_COLUMN_NAME)) continue;
                KsDef ks = DefsTable.deserializeAvro(schema, column.value(), new KsDef());
                keyspaces.add(KSMetaData.fromAvro(ks));
            }
            DefsTable.dumpToStorage(keyspaces);
            logger.info("Truncating deprecated system column families (migrations, schema)...");
            MigrationHelper.dropColumnFamily("system", "Migrations");
            MigrationHelper.dropColumnFamily("system", "Schema");
        }
        return keyspaces;
    }

    public static void mergeRemoteSchema(byte[] data, int version) throws ConfigurationException, IOException {
        Map<DecoratedKey, ColumnFamily> oldKeyspaces = SystemTable.getSchema("schema_keyspaces");
        Map<DecoratedKey, ColumnFamily> oldColumnFamilies = SystemTable.getSchema("schema_columnfamilies");
        for (RowMutation mutation : MigrationManager.deserializeMigrationMessage(data, version)) {
            mutation.apply();
        }
        if (!StorageService.instance.isClientMode()) {
            MigrationHelper.flushSchemaCFs();
        }
        org.apache.cassandra.config.Schema.instance.updateVersion();
        Set<String> keyspacesToDrop = DefsTable.mergeKeyspaces(oldKeyspaces, SystemTable.getSchema("schema_keyspaces"));
        DefsTable.mergeColumnFamilies(oldColumnFamilies, SystemTable.getSchema("schema_columnfamilies"));
        for (String keyspaceToDrop : keyspacesToDrop) {
            MigrationHelper.dropKeyspace(keyspaceToDrop);
        }
    }

    private static Set<String> mergeKeyspaces(Map<DecoratedKey, ColumnFamily> old, Map<DecoratedKey, ColumnFamily> updated) throws ConfigurationException, IOException {
        MapDifference diff = Maps.difference(old, updated);
        for (Map.Entry entry : diff.entriesOnlyOnRight().entrySet()) {
            ColumnFamily ksAttrs = (ColumnFamily)entry.getValue();
            if (ksAttrs.isEmpty()) continue;
            MigrationHelper.addKeyspace(KSMetaData.fromSchema((ColumnFamily)entry.getValue(), null));
        }
        Map modifiedEntries = diff.entriesDiffering();
        ArrayList leftToProcess = new ArrayList();
        for (Map.Entry entry : modifiedEntries.entrySet()) {
            ColumnFamily prevValue = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).leftValue();
            ColumnFamily newValue = (ColumnFamily)((MapDifference.ValueDifference)entry.getValue()).rightValue();
            if (prevValue.isEmpty()) {
                MigrationHelper.addKeyspace(KSMetaData.fromSchema(newValue, null));
                continue;
            }
            leftToProcess.add(entry.getKey());
        }
        if (leftToProcess.size() == 0) {
            return Collections.emptySet();
        }
        HashSet<String> keyspacesToDrop = new HashSet<String>();
        for (DecoratedKey key : leftToProcess) {
            MapDifference.ValueDifference valueDiff = (MapDifference.ValueDifference)modifiedEntries.get(key);
            ColumnFamily newState = (ColumnFamily)valueDiff.rightValue();
            if (newState.isEmpty()) {
                keyspacesToDrop.add(AsciiType.instance.getString(key.key));
                continue;
            }
            MigrationHelper.updateKeyspace(KSMetaData.fromSchema(newState));
        }
        return keyspacesToDrop;
    }

    private static void mergeColumnFamilies(Map<DecoratedKey, ColumnFamily> old, Map<DecoratedKey, ColumnFamily> updated) throws ConfigurationException, IOException {
        MapDifference diff = Maps.difference(old, updated);
        for (Map.Entry entry : diff.entriesOnlyOnRight().entrySet()) {
            ColumnFamily cfAttrs = (ColumnFamily)entry.getValue();
            if (cfAttrs.isEmpty()) continue;
            Map<String, CfDef> cfDefs = KSMetaData.deserializeColumnFamilies(cfAttrs);
            for (CfDef cfDef : cfDefs.values()) {
                MigrationHelper.addColumnFamily(cfDef);
            }
        }
        Map modifiedEntries = diff.entriesDiffering();
        for (DecoratedKey keyspace : modifiedEntries.keySet()) {
            MapDifference.ValueDifference valueDiff = (MapDifference.ValueDifference)modifiedEntries.get(keyspace);
            ColumnFamily prevValue = (ColumnFamily)valueDiff.leftValue();
            ColumnFamily newValue = (ColumnFamily)valueDiff.rightValue();
            if (prevValue.isEmpty()) {
                for (CfDef cfDef : KSMetaData.deserializeColumnFamilies(newValue).values()) {
                    MigrationHelper.addColumnFamily(cfDef);
                }
                continue;
            }
            if (newValue.isEmpty()) {
                for (CfDef cfDef : KSMetaData.deserializeColumnFamilies(prevValue).values()) {
                    MigrationHelper.dropColumnFamily(cfDef.keyspace, cfDef.name);
                }
                continue;
            }
            String ksName = AsciiType.instance.getString(keyspace.key);
            HashMap<String, CfDef> oldCfDefs = new HashMap<String, CfDef>();
            for (CFMetaData cfm : org.apache.cassandra.config.Schema.instance.getKSMetaData(ksName).cfMetaData().values()) {
                oldCfDefs.put(cfm.cfName, cfm.toThrift());
            }
            Map<String, CfDef> newCfDefs = KSMetaData.deserializeColumnFamilies(newValue);
            MapDifference cfDefDiff = Maps.difference(oldCfDefs, newCfDefs);
            for (CfDef cfDef : cfDefDiff.entriesOnlyOnRight().values()) {
                MigrationHelper.addColumnFamily(cfDef);
            }
            for (CfDef cfDef : cfDefDiff.entriesOnlyOnLeft().values()) {
                MigrationHelper.dropColumnFamily(cfDef.keyspace, cfDef.name);
            }
            for (CfDef cfDef : cfDefDiff.entriesDiffering().values()) {
                MigrationHelper.updateColumnFamily((CfDef)cfDef.rightValue());
            }
        }
    }

    private static ByteBuffer toUTF8Bytes(UUID version) {
        return ByteBufferUtil.bytes(version.toString());
    }

    public static <T extends SpecificRecord> T deserializeAvro(Schema writer, ByteBuffer bytes, T ob) throws IOException {
        BinaryDecoder dec = DIRECT_DECODERS.createBinaryDecoder(ByteBufferUtil.getArray(bytes), null);
        SpecificDatumReader reader = new SpecificDatumReader(writer);
        reader.setExpected(ob.getSchema());
        return (T)((SpecificRecord)reader.read(ob, (Decoder)dec));
    }
}

