/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.base.Objects;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.RowMutation;
import org.apache.cassandra.db.SystemTable;
import org.apache.cassandra.db.filter.QueryPath;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.migration.MigrationHelper;
import org.apache.cassandra.db.migration.avro.KsDef;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;

public final class KSMetaData {
    public final String name;
    public final Class<? extends AbstractReplicationStrategy> strategyClass;
    public final Map<String, String> strategyOptions;
    private final Map<String, CFMetaData> cfMetaData;
    public final boolean durableWrites;

    private KSMetaData(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, boolean durableWrites, Iterable<CFMetaData> cfDefs) {
        this.name = name;
        this.strategyClass = strategyClass == null ? NetworkTopologyStrategy.class : strategyClass;
        this.strategyOptions = strategyOptions;
        HashMap<String, CFMetaData> cfmap = new HashMap<String, CFMetaData>();
        for (CFMetaData cfm : cfDefs) {
            cfmap.put(cfm.cfName, cfm);
        }
        this.cfMetaData = Collections.unmodifiableMap(cfmap);
        this.durableWrites = durableWrites;
    }

    public static KSMetaData cloneWith(KSMetaData ksm, Iterable<CFMetaData> cfDefs) {
        return new KSMetaData(ksm.name, ksm.strategyClass, ksm.strategyOptions, ksm.durableWrites, cfDefs);
    }

    public static KSMetaData systemKeyspace() {
        List<CFMetaData> cfDefs = Arrays.asList(CFMetaData.StatusCf, CFMetaData.HintsCf, CFMetaData.MigrationsCf, CFMetaData.SchemaCf, CFMetaData.IndexCf, CFMetaData.NodeIdCf, CFMetaData.VersionCf, CFMetaData.SchemaKeyspacesCf, CFMetaData.SchemaColumnFamiliesCf, CFMetaData.SchemaColumnsCf);
        return new KSMetaData("system", LocalStrategy.class, KSMetaData.optsWithRF(1), true, cfDefs);
    }

    public static KSMetaData testMetadata(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, true, Arrays.asList(cfDefs));
    }

    public static KSMetaData testMetadataNotDurable(String name, Class<? extends AbstractReplicationStrategy> strategyClass, Map<String, String> strategyOptions, CFMetaData ... cfDefs) {
        return new KSMetaData(name, strategyClass, strategyOptions, false, Arrays.asList(cfDefs));
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KSMetaData)) {
            return false;
        }
        KSMetaData other = (KSMetaData)obj;
        return other.name.equals(this.name) && ObjectUtils.equals(other.strategyClass, this.strategyClass) && ObjectUtils.equals(other.strategyOptions, this.strategyOptions) && ((Object)other.cfMetaData).equals(this.cfMetaData) && other.durableWrites == this.durableWrites;
    }

    public Map<String, CFMetaData> cfMetaData() {
        return this.cfMetaData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(", rep strategy:").append(this.strategyClass.getSimpleName()).append("{").append(StringUtils.join(this.cfMetaData.values(), (String)", ")).append("}").append(", durable_writes: ").append(this.durableWrites);
        return sb.toString();
    }

    @Deprecated
    public static KSMetaData fromAvro(KsDef ks) {
        Class<?> repStratClass;
        try {
            String strategyClassName = KSMetaData.convertOldStrategyName(((Object)ks.strategy_class).toString());
            repStratClass = Class.forName(strategyClassName);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not create ReplicationStrategy of type " + ks.strategy_class, ex);
        }
        HashMap<String, String> strategyOptions = new HashMap<String, String>();
        if (ks.strategy_options != null) {
            for (Map.Entry<CharSequence, CharSequence> e : ks.strategy_options.entrySet()) {
                String name = ((Object)e.getKey()).toString();
                if (repStratClass == NetworkTopologyStrategy.class && name.trim().toLowerCase().equals("replication_factor")) continue;
                strategyOptions.put(name, ((Object)e.getValue()).toString());
            }
        }
        int cfsz = ks.cf_defs.size();
        ArrayList<CFMetaData> cfMetaData = new ArrayList<CFMetaData>(cfsz);
        Iterator<org.apache.cassandra.db.migration.avro.CfDef> cfiter = ks.cf_defs.iterator();
        for (int i = 0; i < cfsz; ++i) {
            cfMetaData.add(CFMetaData.fromAvro(cfiter.next()));
        }
        return new KSMetaData(((Object)ks.name).toString(), repStratClass, strategyOptions, ks.durable_writes, cfMetaData);
    }

    public static String convertOldStrategyName(String name) {
        return name.replace("RackUnawareStrategy", "SimpleStrategy").replace("RackAwareStrategy", "OldNetworkTopologyStrategy");
    }

    public static Map<String, String> optsWithRF(Integer rf) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("replication_factor", rf.toString());
        return ret;
    }

    public static KSMetaData fromThrift(org.apache.cassandra.thrift.KsDef ksd, CFMetaData ... cfDefs) throws ConfigurationException {
        return new KSMetaData(ksd.name, AbstractReplicationStrategy.getClass(ksd.strategy_class), ksd.strategy_options == null ? Collections.emptyMap() : ksd.strategy_options, ksd.durable_writes, Arrays.asList(cfDefs));
    }

    public org.apache.cassandra.thrift.KsDef toThrift() {
        ArrayList<CfDef> cfDefs = new ArrayList<CfDef>();
        for (CFMetaData cfm : this.cfMetaData().values()) {
            cfDefs.add(cfm.toThrift());
        }
        org.apache.cassandra.thrift.KsDef ksdef = new org.apache.cassandra.thrift.KsDef(this.name, this.strategyClass.getName(), cfDefs);
        ksdef.setStrategy_options(this.strategyOptions);
        ksdef.setDurable_writes(this.durableWrites);
        return ksdef;
    }

    public RowMutation diff(org.apache.cassandra.thrift.KsDef newState, long modificationTimestamp) {
        org.apache.cassandra.thrift.KsDef curState = this.toThrift();
        RowMutation m = new RowMutation("system", SystemTable.getSchemaKSKey(this.name));
        for (KsDef._Fields field : KsDef._Fields.values()) {
            Object newValue;
            Object curValue;
            if (field.equals((Object)KsDef._Fields.CF_DEFS) || Objects.equal((Object)(curValue = curState.getFieldValue(field)), (Object)(newValue = newState.getFieldValue(field)))) continue;
            m.add(new QueryPath("schema_keyspaces", null, AsciiType.instance.fromString(field.getFieldName())), MigrationHelper.valueAsBytes(newValue), modificationTimestamp);
        }
        return m;
    }

    public KSMetaData reloadAttributes() throws IOException {
        Row ksDefRow = SystemTable.readSchemaRow(this.name);
        if (ksDefRow.cf == null || ksDefRow.cf.isEmpty()) {
            throw new IOException(String.format("%s not found in the schema definitions table (%s).", this.name, "schema_keyspaces"));
        }
        return KSMetaData.fromSchema(ksDefRow.cf, null);
    }

    public List<RowMutation> dropFromSchema(long timestamp) {
        ArrayList<RowMutation> mutations = new ArrayList<RowMutation>();
        RowMutation ksMutation = new RowMutation("system", SystemTable.getSchemaKSKey(this.name));
        ksMutation.delete(new QueryPath("schema_keyspaces"), timestamp);
        mutations.add(ksMutation);
        for (CFMetaData cfm : this.cfMetaData.values()) {
            mutations.add(cfm.dropFromSchema(timestamp));
        }
        return mutations;
    }

    public static RowMutation toSchema(org.apache.cassandra.thrift.KsDef ksDef, long timestamp) throws IOException {
        RowMutation mutation = new RowMutation("system", SystemTable.getSchemaKSKey(ksDef.name));
        for (KsDef._Fields field : KsDef._Fields.values()) {
            if (field.equals((Object)KsDef._Fields.CF_DEFS)) continue;
            mutation.add(new QueryPath("schema_keyspaces", null, AsciiType.instance.fromString(field.getFieldName())), MigrationHelper.valueAsBytes(ksDef.getFieldValue(field)), timestamp);
        }
        if (!ksDef.isSetCf_defs()) {
            return mutation;
        }
        for (CfDef cf : ksDef.cf_defs) {
            try {
                CFMetaData.toSchema(mutation, cf, timestamp);
            }
            catch (ConfigurationException e) {
                throw new IOException(e);
            }
        }
        return mutation;
    }

    public RowMutation toSchema(long timestamp) throws IOException {
        return KSMetaData.toSchema(this.toThrift(), timestamp);
    }

    public static org.apache.cassandra.thrift.KsDef fromSchema(ColumnFamily serializedKsDef) throws IOException {
        org.apache.cassandra.thrift.KsDef ksDef = new org.apache.cassandra.thrift.KsDef();
        AbstractType<?> comparator = serializedKsDef.getComparator();
        for (IColumn ksAttr : serializedKsDef.getSortedColumns()) {
            if (ksAttr == null || ksAttr.isMarkedForDelete()) continue;
            KsDef._Fields field = KsDef._Fields.findByName((String)comparator.getString(ksAttr.name()));
            ksDef.setFieldValue(field, MigrationHelper.deserializeValue(ksAttr.value(), MigrationHelper.getValueClass(org.apache.cassandra.thrift.KsDef.class, field.getFieldName())));
        }
        return ksDef.name == null ? null : ksDef;
    }

    public static KSMetaData fromSchema(ColumnFamily serializedKsDef, ColumnFamily serializedCFs) throws IOException {
        org.apache.cassandra.thrift.KsDef ksDef = KSMetaData.fromSchema(serializedKsDef);
        assert (ksDef != null);
        Map<String, CfDef> cfs = KSMetaData.deserializeColumnFamilies(serializedCFs);
        try {
            CFMetaData[] cfms = new CFMetaData[cfs.size()];
            int index = 0;
            for (CfDef cfDef : cfs.values()) {
                cfms[index++] = CFMetaData.fromThrift(cfDef);
            }
            return KSMetaData.fromThrift(ksDef, cfms);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static Map<String, CfDef> deserializeColumnFamilies(ColumnFamily serializedColumnFamilies) {
        HashMap<String, CfDef> cfs = new HashMap<String, CfDef>();
        if (serializedColumnFamilies == null) {
            return cfs;
        }
        AbstractType<?> comparator = serializedColumnFamilies.getComparator();
        for (IColumn column : serializedColumnFamilies.getSortedColumns()) {
            if (column == null || column.isMarkedForDelete()) continue;
            String[] attr = comparator.getString(column.name()).split(":");
            assert (attr.length == 2);
            CfDef cfDef = (CfDef)cfs.get(attr[0]);
            if (cfDef == null) {
                cfDef = new CfDef();
                cfs.put(attr[0], cfDef);
            }
            CfDef._Fields field = CfDef._Fields.findByName((String)attr[1]);
            cfDef.setFieldValue(field, MigrationHelper.deserializeValue(column.value(), MigrationHelper.getValueClass(CfDef.class, field.getFieldName())));
        }
        for (CfDef cfDef : cfs.values()) {
            for (ColumnDef columnDef : ColumnDefinition.fromSchema(ColumnDefinition.readSchema(cfDef.keyspace, cfDef.name))) {
                cfDef.addToColumn_metadata(columnDef);
            }
        }
        return cfs;
    }
}

