/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.cache.ICache;

public class InstrumentingCache<K, V> {
    private final AtomicLong requests = new AtomicLong(0L);
    private final AtomicLong hits = new AtomicLong(0L);
    private final AtomicLong lastRequests = new AtomicLong(0L);
    private final AtomicLong lastHits = new AtomicLong(0L);
    private volatile boolean capacitySetManually;
    private final ICache<K, V> map;

    public InstrumentingCache(ICache<K, V> map) {
        this.map = map;
    }

    public void put(K key, V value) {
        this.map.put(key, value);
    }

    public V get(K key) {
        V v = this.map.get(key);
        this.requests.incrementAndGet();
        if (v != null) {
            this.hits.incrementAndGet();
        }
        return v;
    }

    public V getInternal(K key) {
        return this.map.get(key);
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public int getCapacity() {
        return this.map.capacity();
    }

    public boolean isCapacitySetManually() {
        return this.capacitySetManually;
    }

    public void updateCapacity(int capacity) {
        this.map.setCapacity(capacity);
    }

    public void setCapacity(int capacity) {
        this.updateCapacity(capacity);
        this.capacitySetManually = true;
    }

    public int size() {
        return this.map.size();
    }

    public int weightedSize() {
        return this.map.weightedSize();
    }

    public long getHits() {
        return this.hits.get();
    }

    public long getRequests() {
        return this.requests.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getRecentHitRate() {
        long r = this.requests.get();
        long h = this.hits.get();
        try {
            double d = (double)(h - this.lastHits.get()) / (double)(r - this.lastRequests.get());
            return d;
        }
        finally {
            this.lastRequests.set(r);
            this.lastHits.set(h);
        }
    }

    public void clear() {
        this.map.clear();
        this.requests.set(0L);
        this.hits.set(0L);
    }

    public Set<K> getKeySet() {
        return this.map.keySet();
    }

    public Set<K> hotKeySet(int n) {
        return this.map.hotKeySet(n);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean isPutCopying() {
        return this.map.isPutCopying();
    }
}

