/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cassandra.config.EncryptionOptions;
import org.apache.cassandra.io.util.FileUtils;

public final class SSLFactory {
    private static final String PROTOCOL = "TLS";
    private static final String ALGORITHM = "SunX509";
    private static final String STORE_TYPE = "JKS";

    public static SSLServerSocket getServerSocket(EncryptionOptions options, InetAddress address, int port) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options);
        SSLServerSocket serverSocket = (SSLServerSocket)ctx.getServerSocketFactory().createServerSocket();
        serverSocket.setReuseAddress(true);
        serverSocket.setEnabledCipherSuites(options.cipherSuites);
        serverSocket.bind(new InetSocketAddress(address, port), 100);
        return serverSocket;
    }

    public static SSLSocket getSocket(EncryptionOptions options, InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options);
        SSLSocket socket = (SSLSocket)ctx.getSocketFactory().createSocket(address, port, localAddress, localPort);
        socket.setEnabledCipherSuites(options.cipherSuites);
        return socket;
    }

    public static SSLSocket getSocket(EncryptionOptions options) throws IOException {
        SSLContext ctx = SSLFactory.createSSLContext(options);
        SSLSocket socket = (SSLSocket)ctx.getSocketFactory().createSocket();
        socket.setEnabledCipherSuites(options.cipherSuites);
        return socket;
    }

    private static SSLContext createSSLContext(EncryptionOptions options) throws IOException {
        SSLContext ctx;
        FileInputStream tsf = new FileInputStream(options.truststore);
        FileInputStream ksf = new FileInputStream(options.keystore);
        try {
            ctx = SSLContext.getInstance(PROTOCOL);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(ALGORITHM);
            KeyStore ts = KeyStore.getInstance(STORE_TYPE);
            ts.load(tsf, options.truststore_password.toCharArray());
            tmf.init(ts);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(ALGORITHM);
            KeyStore ks = KeyStore.getInstance(STORE_TYPE);
            ks.load(ksf, options.keystore_password.toCharArray());
            kmf.init(ks, options.keystore_password.toCharArray());
            ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new IOException("Error creating the initializing the SSL Context", e);
        }
        finally {
            FileUtils.closeQuietly(tsf);
            FileUtils.closeQuietly(ksf);
        }
        return ctx;
    }
}

