/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.Header;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.net.OutboundTcpConnectionPool;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundTcpConnection
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(OutboundTcpConnection.class);
    private static final Message CLOSE_SENTINEL = new Message(FBUtilities.getBroadcastAddress(), StorageService.Verb.INTERNAL_RESPONSE, ArrayUtils.EMPTY_BYTE_ARRAY, 3);
    private static final int OPEN_RETRY_DELAY = 100;
    private final BlockingQueue<Pair<Message, String>> queue = new LinkedBlockingQueue<Pair<Message, String>>();
    private final OutboundTcpConnectionPool poolReference;
    private DataOutputStream out;
    private Socket socket;
    private long completedCount;

    public OutboundTcpConnection(OutboundTcpConnectionPool pool) {
        super("WRITE-" + pool.endPoint());
        this.poolReference = pool;
    }

    public void enqueue(Message message, String id) {
        try {
            this.queue.put(Pair.create(message, id));
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    void closeSocket() {
        this.queue.clear();
        this.enqueue(CLOSE_SENTINEL, null);
    }

    @Override
    public void run() {
        while (true) {
            Pair<Message, String> pair = this.take();
            Message m = (Message)pair.left;
            String id = (String)pair.right;
            if (m == CLOSE_SENTINEL) {
                this.disconnect();
                continue;
            }
            if (this.socket != null || this.connect()) {
                this.writeConnected(m, id);
                continue;
            }
            this.queue.clear();
        }
    }

    public int getPendingMessages() {
        return this.queue.size();
    }

    public long getCompletedMesssages() {
        return this.completedCount;
    }

    private void writeConnected(Message message, String id) {
        try {
            OutboundTcpConnection.write(message, id, this.out);
            if (this.queue.peek() == null) {
                this.out.flush();
            }
        }
        catch (Exception e) {
            if (!(e instanceof IOException)) {
                logger.error("error writing to " + this.poolReference.endPoint(), (Throwable)e);
            } else if (logger.isDebugEnabled()) {
                logger.debug("error writing to " + this.poolReference.endPoint(), (Throwable)e);
            }
            this.disconnect();
        }
    }

    static void write(Message message, String id, DataOutputStream out) throws IOException {
        int header = 0;
        header |= MessagingService.serializerType_.ordinal();
        out.writeInt(-900387334);
        out.writeInt(header |= message.getVersion() << 8);
        byte[] bytes = message.getMessageBody();
        int total = OutboundTcpConnection.messageLength(message.header_, id, bytes);
        out.writeInt(total);
        out.writeUTF(id);
        Header.serializer().serialize(message.header_, out, message.getVersion());
        out.writeInt(bytes.length);
        out.write(bytes);
    }

    public static int messageLength(Header header, String id, byte[] bytes) {
        return 2 + FBUtilities.encodedUTF8Length(id) + header.serializedSize() + 4 + bytes.length;
    }

    private void disconnect() {
        if (this.socket != null) {
            block3: {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    if (!logger.isDebugEnabled()) break block3;
                    logger.debug("exception closing connection to " + this.poolReference.endPoint(), (Throwable)e);
                }
            }
            this.out = null;
            this.socket = null;
        }
    }

    private Pair<Message, String> take() {
        Pair<Message, String> pair;
        try {
            pair = this.queue.take();
            ++this.completedCount;
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        return pair;
    }

    private boolean connect() {
        if (logger.isDebugEnabled()) {
            logger.debug("attempting to connect to " + this.poolReference.endPoint());
        }
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + DatabaseDescriptor.getRpcTimeout()) {
            try {
                this.socket = this.poolReference.newSocket();
                this.socket.setKeepAlive(true);
                this.socket.setTcpNoDelay(true);
                this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 4096));
                return true;
            }
            catch (IOException e) {
                this.socket = null;
                if (logger.isTraceEnabled()) {
                    logger.trace("unable to connect to " + this.poolReference.endPoint(), (Throwable)e);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    throw new AssertionError((Object)e1);
                }
            }
        }
        return false;
    }
}

