/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.LeveledCompactionTask;
import org.apache.cassandra.db.compaction.LeveledManifest;
import org.apache.cassandra.io.sstable.SSTable;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.notifications.INotification;
import org.apache.cassandra.notifications.INotificationConsumer;
import org.apache.cassandra.notifications.SSTableAddedNotification;
import org.apache.cassandra.notifications.SSTableListChangedNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeveledCompactionStrategy
extends AbstractCompactionStrategy
implements INotificationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(LeveledCompactionStrategy.class);
    private final LeveledManifest manifest;
    private final String SSTABLE_SIZE_OPTION = "sstable_size_in_mb";
    private final int maxSSTableSizeInMB;
    private final AtomicReference<LeveledCompactionTask> task = new AtomicReference();

    public LeveledCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options) {
        super(cfs, options);
        int configuredMaxSSTableSize = 5;
        if (options != null) {
            String value;
            String string = value = options.containsKey("sstable_size_in_mb") ? options.get("sstable_size_in_mb") : null;
            if (null != value) {
                try {
                    configuredMaxSSTableSize = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    logger.warn(String.format("%s is not a parsable int (base10) for %s using default value", value, "sstable_size_in_mb"));
                }
            }
        }
        this.maxSSTableSizeInMB = configuredMaxSSTableSize;
        cfs.getDataTracker().subscribe(this);
        logger.debug("{} subscribed to the data tracker.", (Object)this);
        this.manifest = LeveledManifest.create(cfs, this.maxSSTableSizeInMB);
        logger.debug("Created {}", (Object)this.manifest);
        cfs.setMaximumCompactionThreshold(Integer.MAX_VALUE);
        cfs.setMinimumCompactionThreshold(1);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.cfs.getDataTracker().unsubscribe(this);
    }

    public int getLevelSize(int i) {
        return this.manifest.getLevelSize(i);
    }

    @Override
    public List<AbstractCompactionTask> getBackgroundTasks(int gcBefore) {
        LeveledCompactionTask currentTask = this.task.get();
        if (currentTask != null && !currentTask.isDone()) {
            logger.debug("Compaction still in progress for {}", (Object)this);
            return Collections.emptyList();
        }
        Collection<SSTableReader> sstables = this.manifest.getCompactionCandidates();
        if (sstables.isEmpty()) {
            logger.debug("No compaction necessary for {}", (Object)this);
            return Collections.emptyList();
        }
        LeveledCompactionTask newTask = new LeveledCompactionTask(this.cfs, sstables, gcBefore, this.maxSSTableSizeInMB);
        return this.task.compareAndSet(currentTask, newTask) ? Collections.singletonList(newTask) : Collections.emptyList();
    }

    @Override
    public List<AbstractCompactionTask> getMaximalTasks(int gcBefore) {
        return this.getBackgroundTasks(gcBefore);
    }

    @Override
    public AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> sstables, int gcBefore) {
        throw new UnsupportedOperationException("LevelDB compaction strategy does not allow user-specified compactions");
    }

    @Override
    public int getEstimatedRemainingTasks() {
        return this.manifest.getEstimatedTasks();
    }

    @Override
    public void handleNotification(INotification notification, Object sender) {
        if (notification instanceof SSTableAddedNotification) {
            SSTableAddedNotification flushedNotification = (SSTableAddedNotification)notification;
            this.manifest.add(flushedNotification.added);
        } else if (notification instanceof SSTableListChangedNotification) {
            SSTableListChangedNotification listChangedNotification = (SSTableListChangedNotification)notification;
            this.manifest.promote(listChangedNotification.removed, listChangedNotification.added);
        }
    }

    @Override
    public long getMaxSSTableSize() {
        return (long)this.maxSSTableSizeInMB * 1024L * 1024L;
    }

    @Override
    public boolean isKeyExistenceExpensive(Set<? extends SSTable> sstablesToIgnore) {
        ImmutableSet L0 = ImmutableSet.copyOf(this.manifest.getLevel(0));
        return Sets.difference((Set)L0, sstablesToIgnore).size() + this.manifest.getLevelCount() > 20;
    }

    public String toString() {
        return String.format("LCS@%d(%s)", this.hashCode(), this.cfs.columnFamily);
    }
}

