/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql.jdbc;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.cassandra.cql.jdbc.AbstractJdbcType;
import org.apache.cassandra.utils.ByteBufferUtil;

public class JdbcInteger
extends AbstractJdbcType<BigInteger> {
    public static final JdbcInteger instance = new JdbcInteger();

    JdbcInteger() {
    }

    @Override
    public boolean isCaseSensitive() {
        return false;
    }

    @Override
    public int getScale(BigInteger obj) {
        return 0;
    }

    @Override
    public int getPrecision(BigInteger obj) {
        return obj.toString().length();
    }

    @Override
    public boolean isCurrency() {
        return false;
    }

    @Override
    public boolean isSigned() {
        return true;
    }

    @Override
    public String toString(BigInteger obj) {
        return obj.toString();
    }

    @Override
    public boolean needsQuotes() {
        return false;
    }

    @Override
    public String getString(ByteBuffer bytes) {
        if (bytes == null) {
            return "null";
        }
        if (bytes.remaining() == 0) {
            return "empty";
        }
        return new BigInteger(ByteBufferUtil.getArray(bytes)).toString(10);
    }

    @Override
    public Class<BigInteger> getType() {
        return BigInteger.class;
    }

    @Override
    public int getJdbcType() {
        return -5;
    }

    @Override
    public BigInteger compose(ByteBuffer bytes) {
        return new BigInteger(ByteBufferUtil.getArray(bytes));
    }
}

