/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.marshal;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.db.marshal.AbstractCompositeType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.MarshalException;
import org.apache.cassandra.db.marshal.TypeParser;

public class CompositeType
extends AbstractCompositeType {
    final List<AbstractType> types;
    private static final Map<List<AbstractType>, CompositeType> instances = new HashMap<List<AbstractType>, CompositeType>();

    public static CompositeType getInstance(TypeParser parser) throws ConfigurationException {
        return CompositeType.getInstance(parser.getTypeParameters());
    }

    public static synchronized CompositeType getInstance(List<AbstractType> types) throws ConfigurationException {
        if (types == null || types.isEmpty()) {
            throw new ConfigurationException("Nonsensical empty parameter list for CompositeType");
        }
        CompositeType ct = instances.get(types);
        if (ct == null) {
            ct = new CompositeType(types);
            instances.put(types, ct);
        }
        return ct;
    }

    private CompositeType(List<AbstractType> types) {
        this.types = types;
    }

    @Override
    protected AbstractType getNextComparator(int i, ByteBuffer bb) {
        return this.types.get(i);
    }

    @Override
    protected AbstractType getNextComparator(int i, ByteBuffer bb1, ByteBuffer bb2) {
        return this.types.get(i);
    }

    @Override
    protected AbstractType getAndAppendNextComparator(int i, ByteBuffer bb, StringBuilder sb) {
        return this.types.get(i);
    }

    @Override
    protected AbstractCompositeType.ParsedComparator parseNextComparator(int i, String part) {
        return new StaticParsedComparator(this.types.get(i), part);
    }

    @Override
    protected AbstractType validateNextComparator(int i, ByteBuffer bb) throws MarshalException {
        if (i >= this.types.size()) {
            throw new MarshalException("Too many bytes for comparator");
        }
        return this.types.get(i);
    }

    @Override
    public String toString() {
        return this.getClass().getName() + TypeParser.stringifyTypeParameters(this.types);
    }

    private static class StaticParsedComparator
    implements AbstractCompositeType.ParsedComparator {
        final AbstractType type;
        final String part;

        StaticParsedComparator(AbstractType type, String part) {
            this.type = type;
            this.part = part;
        }

        @Override
        public AbstractType getAbstractType() {
            return this.type;
        }

        @Override
        public String getRemainingPart() {
            return this.part;
        }

        @Override
        public int getComparatorSerializedSize() {
            return 0;
        }

        @Override
        public void serializeComparator(ByteBuffer bb) {
        }
    }
}

