/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.lang.StringUtils;

public class RangeSliceReply {
    public final List<Row> rows;

    public RangeSliceReply(List<Row> rows) {
        this.rows = rows;
    }

    public Message getReply(Message originalMessage) throws IOException {
        int size = 4;
        for (Row row : this.rows) {
            size = (int)((long)size + Row.serializer().serializedSize(row, originalMessage.getVersion()));
        }
        DataOutputBuffer buffer = new DataOutputBuffer(size);
        buffer.writeInt(this.rows.size());
        for (Row row : this.rows) {
            Row.serializer().serialize(row, (DataOutput)buffer, originalMessage.getVersion());
        }
        assert (buffer.getLength() == buffer.getData().length);
        return originalMessage.getReply(FBUtilities.getBroadcastAddress(), buffer.getData(), originalMessage.getVersion());
    }

    public String toString() {
        return "RangeSliceReply{rows=" + StringUtils.join(this.rows, (String)",") + '}';
    }

    public static RangeSliceReply read(byte[] body, int version) throws IOException {
        FastByteArrayInputStream bufIn = new FastByteArrayInputStream(body);
        DataInputStream dis = new DataInputStream(bufIn);
        int rowCount = dis.readInt();
        ArrayList<Row> rows = new ArrayList<Row>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            rows.add(Row.serializer().deserialize(dis, version));
        }
        return new RangeSliceReply(rows);
    }
}

