/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.compress;

import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.compress.CompressionParameters;
import org.apache.cassandra.io.compress.CorruptedBlockException;
import org.apache.cassandra.io.compress.ICompressor;
import org.apache.cassandra.io.util.FileMark;
import org.apache.cassandra.io.util.SequentialWriter;

public class CompressedSequentialWriter
extends SequentialWriter {
    private long chunkOffset = 0L;
    private final CompressionMetadata.Writer metadataWriter;
    private final ICompressor compressor;
    private final ICompressor.WrappedArray compressed;
    private int chunkCount = 0;
    private final Checksum checksum = new CRC32();

    public static SequentialWriter open(String dataFilePath, String indexFilePath, boolean skipIOCache, CompressionParameters parameters) throws IOException {
        return new CompressedSequentialWriter(new File(dataFilePath), indexFilePath, skipIOCache, parameters);
    }

    public CompressedSequentialWriter(File file, String indexFilePath, boolean skipIOCache, CompressionParameters parameters) throws IOException {
        super(file, parameters.chunkLength(), skipIOCache);
        this.compressor = parameters.sstableCompressor;
        this.compressed = new ICompressor.WrappedArray(new byte[this.compressor.initialCompressedBufferLength(this.buffer.length)]);
        this.metadataWriter = new CompressionMetadata.Writer(indexFilePath);
        this.metadataWriter.writeHeader(parameters);
    }

    @Override
    public void sync() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void flushData() throws IOException {
        this.seekToChunkStart();
        int compressedLength = this.compressor.compress(this.buffer, 0, this.validBufferBytes, this.compressed, 0);
        this.checksum.update(this.buffer, 0, this.validBufferBytes);
        this.metadataWriter.writeLong(this.chunkOffset);
        ++this.chunkCount;
        assert (compressedLength <= this.compressed.buffer.length);
        this.out.write(this.compressed.buffer, 0, compressedLength);
        this.out.writeInt((int)this.checksum.getValue());
        this.checksum.reset();
        this.chunkOffset += (long)(compressedLength + 4);
    }

    @Override
    public FileMark mark() {
        return new CompressedFileWriterMark(this.chunkOffset, this.current, this.validBufferBytes, this.chunkCount + 1);
    }

    @Override
    public synchronized void resetAndTruncate(FileMark mark) throws IOException {
        assert (mark instanceof CompressedFileWriterMark);
        CompressedFileWriterMark realMark = (CompressedFileWriterMark)mark;
        this.current = realMark.uncDataOffset;
        if (realMark.chunkOffset == this.chunkOffset) {
            this.validBufferBytes = realMark.bufferOffset;
            return;
        }
        this.syncInternal();
        this.chunkOffset = realMark.chunkOffset;
        int chunkSize = (int)(this.metadataWriter.chunkOffsetBy(realMark.nextChunkIndex) - this.chunkOffset - 4L);
        if (this.compressed.buffer.length < chunkSize) {
            this.compressed.buffer = new byte[chunkSize];
        }
        this.out.seek(this.chunkOffset);
        this.out.readFully(this.compressed.buffer, 0, chunkSize);
        int validBytes = this.compressor.uncompress(this.compressed.buffer, 0, chunkSize, this.buffer, 0);
        this.checksum.update(this.buffer, 0, validBytes);
        if (this.out.readInt() != (int)this.checksum.getValue()) {
            throw new CorruptedBlockException(this.getPath(), this.chunkOffset, chunkSize);
        }
        this.checksum.reset();
        this.validBufferBytes = realMark.bufferOffset;
        this.bufferOffset = this.current - (long)this.validBufferBytes;
        this.chunkCount = realMark.nextChunkIndex - 1;
        this.truncate(this.chunkOffset);
        this.metadataWriter.resetAndTruncate(realMark.nextChunkIndex);
    }

    private void seekToChunkStart() throws IOException {
        if (this.out.getFilePointer() != this.chunkOffset) {
            this.out.seek(this.chunkOffset);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.buffer == null) {
            return;
        }
        super.close();
        this.metadataWriter.finalizeHeader(this.current, this.chunkCount);
        this.metadataWriter.close();
    }

    protected static class CompressedFileWriterMark
    implements FileMark {
        long chunkOffset;
        long uncDataOffset;
        int bufferOffset;
        int nextChunkIndex;

        public CompressedFileWriterMark(long chunkOffset, long uncDataOffset, int bufferOffset, int nextChunkIndex) {
            this.chunkOffset = chunkOffset;
            this.uncDataOffset = uncDataOffset;
            this.bufferOffset = bufferOffset;
            this.nextChunkIndex = nextChunkIndex;
        }
    }
}

