/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.cassandra.db.IColumn;
import org.apache.cassandra.db.IColumnContainer;
import org.apache.cassandra.db.ISortedColumns;
import org.apache.cassandra.db.SuperColumn;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.io.util.IIterableColumns;
import org.apache.cassandra.utils.Allocator;
import org.apache.cassandra.utils.HeapAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractColumnContainer
implements IColumnContainer,
IIterableColumns {
    private static Logger logger = LoggerFactory.getLogger(AbstractColumnContainer.class);
    protected final AtomicReference<DeletionInfo> deletionInfo = new AtomicReference<DeletionInfo>(new DeletionInfo());
    protected final ISortedColumns columns;

    protected AbstractColumnContainer(ISortedColumns columns) {
        this.columns = columns;
    }

    @Deprecated
    public void delete(int localtime, long timestamp) {
        this.deletionInfo.set(new DeletionInfo(timestamp, localtime));
    }

    public void delete(AbstractColumnContainer cc2) {
        DeletionInfo current;
        DeletionInfo cc2Info = cc2.deletionInfo.get();
        do {
            current = this.deletionInfo.get();
        } while (current.markedForDeleteAt < cc2Info.markedForDeleteAt && !this.deletionInfo.compareAndSet(current, cc2Info));
    }

    @Override
    public boolean isMarkedForDelete() {
        return this.getMarkedForDeleteAt() > Long.MIN_VALUE;
    }

    @Override
    public long getMarkedForDeleteAt() {
        return this.deletionInfo.get().markedForDeleteAt;
    }

    public int getLocalDeletionTime() {
        return this.deletionInfo.get().localDeletionTime;
    }

    @Override
    public AbstractType getComparator() {
        return this.columns.getComparator();
    }

    public void maybeResetDeletionTimes(int gcBefore) {
        DeletionInfo current;
        do {
            current = this.deletionInfo.get();
        } while (current.localDeletionTime != Integer.MIN_VALUE && current.localDeletionTime <= gcBefore && !this.deletionInfo.compareAndSet(current, new DeletionInfo()));
    }

    public void addAll(AbstractColumnContainer cc, Allocator allocator) {
        this.columns.addAll(cc.columns, allocator);
        this.delete(cc);
    }

    @Override
    public void addColumn(IColumn column) {
        this.addColumn(column, HeapAllocator.instance);
    }

    @Override
    public void addColumn(IColumn column, Allocator allocator) {
        this.columns.addColumn(column, allocator);
    }

    public IColumn getColumn(ByteBuffer name) {
        return this.columns.getColumn(name);
    }

    @Override
    public boolean replace(IColumn oldColumn, IColumn newColumn) {
        return this.columns.replace(oldColumn, newColumn);
    }

    public SortedSet<ByteBuffer> getColumnNames() {
        return this.columns.getColumnNames();
    }

    @Override
    public Collection<IColumn> getSortedColumns() {
        return this.columns.getSortedColumns();
    }

    public Collection<IColumn> getReverseSortedColumns() {
        return this.columns.getReverseSortedColumns();
    }

    @Override
    public void remove(ByteBuffer columnName) {
        this.columns.removeColumn(columnName);
    }

    public void retainAll(AbstractColumnContainer container) {
        Iterator<IColumn> iter = this.iterator();
        Iterator<IColumn> toRetain = container.iterator();
        IColumn current = iter.hasNext() ? iter.next() : null;
        IColumn retain = toRetain.hasNext() ? toRetain.next() : null;
        AbstractType comparator = this.getComparator();
        while (current != null && retain != null) {
            int c = comparator.compare(current.name(), retain.name());
            if (c == 0) {
                if (current instanceof SuperColumn) {
                    assert (retain instanceof SuperColumn);
                    ((SuperColumn)current).retainAll((SuperColumn)retain);
                }
                current = iter.hasNext() ? iter.next() : null;
                retain = toRetain.hasNext() ? toRetain.next() : null;
                continue;
            }
            if (c < 0) {
                iter.remove();
                current = iter.hasNext() ? iter.next() : null;
                continue;
            }
            retain = toRetain.hasNext() ? toRetain.next() : null;
        }
        while (current != null) {
            iter.remove();
            current = iter.hasNext() ? iter.next() : null;
        }
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public boolean isEmpty() {
        return this.columns.isEmpty();
    }

    @Override
    public int getEstimatedColumnCount() {
        return this.getColumnCount();
    }

    public int getLiveColumnCount() {
        int count = 0;
        for (IColumn column : this.columns) {
            if (!column.isLive()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<IColumn> iterator() {
        return this.columns.iterator();
    }

    @Override
    public boolean hasExpiredTombstones(int gcBefore) {
        if (this.isMarkedForDelete() && this.getLocalDeletionTime() < gcBefore) {
            return true;
        }
        for (IColumn column : this.columns) {
            if (!column.hasExpiredTombstones(gcBefore)) continue;
            return true;
        }
        return false;
    }

    protected static class DeletionInfo {
        public final long markedForDeleteAt;
        public final int localDeletionTime;

        public DeletionInfo() {
            this(Long.MIN_VALUE, Integer.MIN_VALUE);
        }

        public DeletionInfo(long markedForDeleteAt, int localDeletionTime) {
            this.markedForDeleteAt = markedForDeleteAt;
            this.localDeletionTime = localDeletionTime;
        }
    }
}

