/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.IntervalTree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cassandra.utils.IntervalTree.Interval;

public class IntervalNode {
    Comparable v_pt;
    Comparable v_min;
    Comparable v_max;
    List<Interval> intersects_left;
    List<Interval> intersects_right;
    IntervalNode left = null;
    IntervalNode right = null;

    public IntervalNode(List<Interval> toBisect) {
        if (toBisect.size() > 0) {
            this.findMinMedianMax(toBisect);
            List<Interval> intersects = this.getIntersectingIntervals(toBisect);
            this.intersects_left = Interval.minOrdering.sortedCopy(intersects);
            this.intersects_right = Interval.maxOrdering.reverse().sortedCopy(intersects);
            List<Interval> leftSegment = this.getLeftIntervals(toBisect);
            List<Interval> rightSegment = this.getRightIntervals(toBisect);
            if (leftSegment.size() > 0) {
                this.left = new IntervalNode(leftSegment);
            }
            if (rightSegment.size() > 0) {
                this.right = new IntervalNode(rightSegment);
            }
        }
    }

    public List<Interval> getLeftIntervals(List<Interval> candidates) {
        ArrayList<Interval> retval = new ArrayList<Interval>();
        for (Interval candidate : candidates) {
            if (candidate.max.compareTo(this.v_pt) >= 0) continue;
            retval.add(candidate);
        }
        return retval;
    }

    public List<Interval> getRightIntervals(List<Interval> candidates) {
        ArrayList<Interval> retval = new ArrayList<Interval>();
        for (Interval candidate : candidates) {
            if (candidate.min.compareTo(this.v_pt) <= 0) continue;
            retval.add(candidate);
        }
        return retval;
    }

    public List<Interval> getIntersectingIntervals(List<Interval> candidates) {
        ArrayList<Interval> retval = new ArrayList<Interval>();
        for (Interval candidate : candidates) {
            if (candidate.min.compareTo(this.v_pt) > 0 || candidate.max.compareTo(this.v_pt) < 0) continue;
            retval.add(candidate);
        }
        return retval;
    }

    public void findMinMedianMax(List<Interval> intervals) {
        if (intervals.size() > 0) {
            ArrayList<Comparable> allEndpoints = new ArrayList<Comparable>(intervals.size() * 2);
            for (Interval interval : intervals) {
                allEndpoints.add(interval.min);
                allEndpoints.add(interval.max);
            }
            Collections.sort(allEndpoints);
            this.v_pt = (Comparable)allEndpoints.get(intervals.size());
            this.v_min = (Comparable)allEndpoints.get(0);
            this.v_max = (Comparable)allEndpoints.get(allEndpoints.size() - 1);
        }
    }
}

