/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.dht.Range;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.io.sstable.SSTableLoader;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.PendingFile;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.TokenRange;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class BulkLoader {
    private static final String TOOL_NAME = "sstableloader";
    private static final String VERBOSE_OPTION = "verbose";
    private static final String DEBUG_OPTION = "debug";
    private static final String HELP_OPTION = "help";
    private static final String NOPROGRESS_OPTION = "no-progress";
    private static final String IGNORE_NODES_OPTION = "ignore";

    public static void main(String[] args) throws IOException {
        LoaderOptions options = LoaderOptions.parseArgs(args);
        try {
            SSTableLoader loader = new SSTableLoader(options.directory, new ExternalClient(options), options);
            SSTableLoader.LoaderFuture future = loader.stream(options.ignores);
            if (options.noProgress) {
                future.get();
            } else {
                ProgressIndicator indicator = new ProgressIndicator(future.getPendingFiles());
                indicator.start();
                System.out.println("");
                while (!future.isDone()) {
                    if (indicator.printProgress()) {
                        System.out.println("\nWaiting for targets to rebuild indexes ...");
                        future.get();
                        assert (future.isDone());
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception e) {}
                }
            }
            System.exit(0);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            if (options.debug) {
                e.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static class CmdLineOptions
    extends Options {
        private CmdLineOptions() {
        }

        public Options addOption(String opt, String longOpt, String argName, String description) {
            Option option = new Option(opt, longOpt, true, description);
            option.setArgName(argName);
            return this.addOption(option);
        }

        public Options addOption(String opt, String longOpt, String description) {
            return this.addOption(new Option(opt, longOpt, false, description));
        }
    }

    static class LoaderOptions
    implements SSTableLoader.OutputHandler {
        public final File directory;
        public boolean debug;
        public boolean verbose;
        public boolean noProgress;
        public Set<InetAddress> ignores = new HashSet<InetAddress>();

        LoaderOptions(File directory) {
            this.directory = directory;
        }

        public static LoaderOptions parseArgs(String[] cmdArgs) {
            GnuParser parser = new GnuParser();
            CmdLineOptions options = LoaderOptions.getCmdLineOptions();
            try {
                String dirname;
                File dir;
                String[] args;
                CommandLine cmd = parser.parse((Options)options, cmdArgs, false);
                if (cmd.hasOption(BulkLoader.HELP_OPTION)) {
                    LoaderOptions.printUsage(options);
                    System.exit(0);
                }
                if ((args = cmd.getArgs()).length == 0) {
                    System.err.println("Missing sstable directory argument");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (args.length > 1) {
                    System.err.println("Too many arguments");
                    LoaderOptions.printUsage(options);
                    System.exit(1);
                }
                if (!(dir = new File(dirname = args[0])).exists()) {
                    LoaderOptions.errorMsg("Unknown directory: " + dirname, options);
                }
                if (!dir.isDirectory()) {
                    LoaderOptions.errorMsg(dirname + " is not a directory", options);
                }
                LoaderOptions opts = new LoaderOptions(dir);
                opts.debug = cmd.hasOption(BulkLoader.DEBUG_OPTION);
                opts.verbose = cmd.hasOption(BulkLoader.VERBOSE_OPTION);
                opts.noProgress = cmd.hasOption(BulkLoader.NOPROGRESS_OPTION);
                if (cmd.hasOption(BulkLoader.IGNORE_NODES_OPTION)) {
                    String[] nodes = cmd.getOptionValue(BulkLoader.IGNORE_NODES_OPTION).split(",");
                    try {
                        for (String node : nodes) {
                            opts.ignores.add(InetAddress.getByName(node));
                        }
                    }
                    catch (UnknownHostException e) {
                        LoaderOptions.errorMsg(e.getMessage(), options);
                    }
                }
                return opts;
            }
            catch (ParseException e) {
                LoaderOptions.errorMsg(e.getMessage(), options);
                return null;
            }
        }

        private static void errorMsg(String msg, CmdLineOptions options) {
            System.err.println(msg);
            LoaderOptions.printUsage(options);
            System.exit(1);
        }

        @Override
        public void output(String msg) {
            System.out.println(msg);
        }

        @Override
        public void debug(String msg) {
            if (this.verbose) {
                System.out.println(msg);
            }
        }

        private static CmdLineOptions getCmdLineOptions() {
            CmdLineOptions options = new CmdLineOptions();
            options.addOption(null, BulkLoader.DEBUG_OPTION, "display stack traces");
            options.addOption("v", BulkLoader.VERBOSE_OPTION, "verbose output");
            options.addOption("h", BulkLoader.HELP_OPTION, "display this help message");
            options.addOption(null, BulkLoader.NOPROGRESS_OPTION, "don't display progress");
            options.addOption("i", BulkLoader.IGNORE_NODES_OPTION, "don't stream to this (comma separated) list of nodes");
            return options;
        }

        public static void printUsage(Options options) {
            String usage = String.format("%s [options] <dir_path>", BulkLoader.TOOL_NAME);
            StringBuilder header = new StringBuilder();
            header.append("--\n");
            header.append("Bulk load the sstables find in the directory <dir_path> to the configured cluster.");
            header.append("The last directory of <dir_path> is used as the keyspace name. ");
            header.append("So for instance, to load a sstable named Standard1-g-1-Data.db into keyspace Keyspace1, ");
            header.append("you will need to have the files Standard1-g-1-Data.db and Standard1-g-1-Index.db in a ");
            header.append("directory Keyspace1/ in the current directory and call: sstableloader Keyspace1");
            header.append("\n--\n");
            header.append("Options are:");
            new HelpFormatter().printHelp(usage, header.toString(), options, "");
        }
    }

    static class ExternalClient
    extends SSTableLoader.Client {
        private final Map<String, Set<String>> knownCfs = new HashMap<String, Set<String>>();
        private final SSTableLoader.OutputHandler outputHandler;

        public ExternalClient(SSTableLoader.OutputHandler outputHandler) {
            this.outputHandler = outputHandler;
        }

        @Override
        public void init(String keyspace) {
            this.outputHandler.output(String.format("Starting client (and waiting %d seconds for gossip) ...", 30));
            try {
                StorageService.instance.initClient();
                Set<InetAddress> hosts = Gossiper.instance.getLiveMembers();
                hosts.remove(FBUtilities.getBroadcastAddress());
                if (hosts.isEmpty()) {
                    throw new IllegalStateException("Cannot load any sstable, no live member found in the cluster");
                }
                String host = hosts.iterator().next().toString().substring(1);
                int port = DatabaseDescriptor.getRpcPort();
                Cassandra.Client client = ExternalClient.createThriftClient(host, port);
                List tokenRanges = client.describe_ring(keyspace);
                List ksDefs = client.describe_keyspaces();
                Token.TokenFactory tkFactory = StorageService.getPartitioner().getTokenFactory();
                try {
                    for (TokenRange tr : tokenRanges) {
                        Range range = new Range(tkFactory.fromString(tr.start_token), tkFactory.fromString(tr.end_token));
                        for (String ep : tr.endpoints) {
                            this.addRangeForEndpoint(range, InetAddress.getByName(ep));
                        }
                    }
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException("Got an unknow host from describe_ring()", e);
                }
                for (KsDef ksDef : ksDefs) {
                    HashSet<String> cfs = new HashSet<String>();
                    for (CfDef cfDef : ksDef.cf_defs) {
                        cfs.add(cfDef.name);
                    }
                    this.knownCfs.put(ksDef.name, cfs);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void stop() {
            StorageService.instance.stopClient();
        }

        @Override
        public boolean validateColumnFamily(String keyspace, String cfName) {
            Set<String> cfs = this.knownCfs.get(keyspace);
            return cfs != null && cfs.contains(cfName);
        }

        private static Cassandra.Client createThriftClient(String host, int port) throws TTransportException {
            TSocket socket = new TSocket(host, port);
            TFramedTransport trans = new TFramedTransport((TTransport)socket);
            trans.open();
            TBinaryProtocol protocol = new TBinaryProtocol((TTransport)trans);
            return new Cassandra.Client((TProtocol)protocol);
        }
    }

    static class ProgressIndicator {
        private final Map<InetAddress, Collection<PendingFile>> filesByHost;
        private long startTime;
        private long lastProgress;
        private long lastTime;

        public ProgressIndicator(Map<InetAddress, Collection<PendingFile>> filesByHost) {
            this.filesByHost = new HashMap<InetAddress, Collection<PendingFile>>(filesByHost);
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public boolean printProgress() {
            boolean done = true;
            StringBuilder sb = new StringBuilder();
            sb.append("\rprogress: ");
            long totalProgress = 0L;
            long totalSize = 0L;
            for (Map.Entry<InetAddress, Collection<PendingFile>> entry : this.filesByHost.entrySet()) {
                long progress = 0L;
                long size = 0L;
                int completed = 0;
                Collection<PendingFile> pendings = entry.getValue();
                for (PendingFile f : pendings) {
                    progress += f.progress;
                    size += f.size;
                    if (f.progress != f.size) continue;
                    ++completed;
                }
                totalProgress += progress;
                totalSize += size;
                if (completed != pendings.size()) {
                    done = false;
                }
                sb.append("[").append(entry.getKey());
                sb.append(" ").append(completed).append("/").append(pendings.size());
                sb.append(" (").append(size == 0L ? 100L : progress * 100L / size).append(")] ");
            }
            long time = System.currentTimeMillis();
            long deltaTime = time - this.lastTime;
            this.lastTime = time;
            long deltaProgress = totalProgress - this.lastProgress;
            this.lastProgress = totalProgress;
            sb.append("[total: ").append(totalSize == 0L ? 100L : totalProgress * 100L / totalSize).append(" - ");
            sb.append(this.mbPerSec(deltaProgress, deltaTime)).append("MB/s");
            sb.append(" (avg: ").append(this.mbPerSec(totalProgress, time - this.startTime)).append("MB/s)]");
            System.out.print(sb.toString());
            return done;
        }

        private int mbPerSec(long bytes, long timeInMs) {
            double bytesPerMs = (double)bytes / (double)timeInMs;
            return (int)(bytesPerMs * 1000.0 / 2072576.0);
        }
    }
}

