/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.gms.FailureDetector;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.AbstractWriteResponseHandler;
import org.apache.cassandra.service.IWriteResponseHandler;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteResponseHandler
extends AbstractWriteResponseHandler {
    protected static final Logger logger = LoggerFactory.getLogger(WriteResponseHandler.class);
    protected final AtomicInteger responses;

    protected WriteResponseHandler(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel, String table) {
        super(writeEndpoints, consistencyLevel);
        this.responses = new AtomicInteger(this.determineBlockFor(table));
    }

    protected WriteResponseHandler(InetAddress endpoint) {
        super(Arrays.asList(endpoint), ConsistencyLevel.ALL);
        this.responses = new AtomicInteger(1);
    }

    public static IWriteResponseHandler create(Collection<InetAddress> writeEndpoints, ConsistencyLevel consistencyLevel, String table) {
        return new WriteResponseHandler(writeEndpoints, consistencyLevel, table);
    }

    public static IWriteResponseHandler create(InetAddress endpoint) {
        return new WriteResponseHandler(endpoint);
    }

    @Override
    public void response(Message m) {
        if (this.responses.decrementAndGet() == 0) {
            this.condition.signal();
        }
    }

    protected int determineBlockFor(String table) {
        switch (this.consistencyLevel) {
            case ONE: {
                return 1;
            }
            case ANY: {
                return 1;
            }
            case TWO: {
                return 2;
            }
            case THREE: {
                return 3;
            }
            case QUORUM: {
                return Table.open(table).getReplicationStrategy().getReplicationFactor() / 2 + 1;
            }
            case ALL: {
                return Table.open(table).getReplicationStrategy().getReplicationFactor();
            }
        }
        throw new UnsupportedOperationException("invalid consistency level: " + this.consistencyLevel.toString());
    }

    @Override
    public void assureSufficientLiveNodes() throws UnavailableException {
        if (this.consistencyLevel == ConsistencyLevel.ANY) {
            int effectiveEndpoints;
            int n = effectiveEndpoints = this.writeEndpoints.contains(FBUtilities.getBroadcastAddress()) ? this.writeEndpoints.size() : this.writeEndpoints.size() + 1;
            if (effectiveEndpoints < this.responses.get()) {
                throw new UnavailableException();
            }
            return;
        }
        int liveNodes = 0;
        for (InetAddress destination : this.writeEndpoints) {
            if (!FailureDetector.instance.isAlive(destination)) continue;
            ++liveNodes;
        }
        if (liveNodes < this.responses.get()) {
            throw new UnavailableException();
        }
    }

    @Override
    public boolean isLatencyForSnitch() {
        return false;
    }
}

