/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.compaction.AbstractCompactionTask;
import org.apache.cassandra.db.compaction.CompactionManager;
import org.apache.cassandra.io.sstable.SSTableReader;
import org.apache.cassandra.service.StorageService;

public abstract class AbstractCompactionStrategy {
    protected final ColumnFamilyStore cfs;
    protected final Map<String, String> options;

    protected AbstractCompactionStrategy(ColumnFamilyStore cfs, Map<String, String> options) {
        assert (cfs != null);
        this.cfs = cfs;
        this.options = options;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (CompactionManager.instance.getActiveCompactions() == 0) {
                    CompactionManager.instance.submitBackground(AbstractCompactionStrategy.this.cfs);
                }
            }
        };
        StorageService.optionalTasks.schedule(runnable, 300L, TimeUnit.SECONDS);
    }

    public void shutdown() {
    }

    public abstract List<AbstractCompactionTask> getBackgroundTasks(int var1);

    public abstract List<AbstractCompactionTask> getMaximalTasks(int var1);

    public abstract AbstractCompactionTask getUserDefinedTask(Collection<SSTableReader> var1, int var2);

    public abstract int getEstimatedRemainingTasks();
}

