/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.cassandra.db.ColumnFamily;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.io.util.FastByteArrayInputStream;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadVerbHandler
implements IVerbHandler {
    private static Logger logger_ = LoggerFactory.getLogger(ReadVerbHandler.class);
    private static ThreadLocal<DataOutputBuffer> threadLocalOut = new ThreadLocal<DataOutputBuffer>(){

        @Override
        protected DataOutputBuffer initialValue() {
            return new DataOutputBuffer();
        }
    };

    @Override
    public void doVerb(Message message, String id) {
        if (StorageService.instance.isBootstrapMode()) {
            throw new RuntimeException("Cannot service reads while bootstrapping!");
        }
        try {
            FastByteArrayInputStream in = new FastByteArrayInputStream(message.getMessageBody());
            ReadCommand command = ReadCommand.serializer().deserialize(new DataInputStream(in), message.getVersion());
            Table table = Table.open(command.table);
            Row row = command.getRow(table);
            DataOutputBuffer out = threadLocalOut.get();
            out.reset();
            ReadResponse.serializer().serialize(ReadVerbHandler.getResponse(command, row), out, message.getVersion());
            byte[] bytes = new byte[out.getLength()];
            System.arraycopy(out.getData(), 0, bytes, 0, bytes.length);
            Message response = message.getReply(FBUtilities.getBroadcastAddress(), bytes, message.getVersion());
            if (logger_.isDebugEnabled()) {
                logger_.debug(String.format("Read key %s; sending response to %s@%s", ByteBufferUtil.bytesToHex(command.key), id, message.getFrom()));
            }
            MessagingService.instance().sendReply(response, id, message.getFrom());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ReadResponse getResponse(ReadCommand command, Row row) {
        if (command.isDigestQuery()) {
            if (logger_.isDebugEnabled()) {
                logger_.debug("digest is " + ByteBufferUtil.bytesToHex(ColumnFamily.digest(row.cf)));
            }
            return new ReadResponse(ColumnFamily.digest(row.cf));
        }
        return new ReadResponse(row);
    }
}

