/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.List;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.IndexScanCommand;
import org.apache.cassandra.db.RangeSliceReply;
import org.apache.cassandra.db.Row;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.db.filter.QueryFilter;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexScanVerbHandler
implements IVerbHandler {
    private static final Logger logger = LoggerFactory.getLogger(IndexScanVerbHandler.class);

    @Override
    public void doVerb(Message message, String id) {
        try {
            IndexScanCommand command = IndexScanCommand.read(message);
            ColumnFamilyStore cfs = Table.open(command.keyspace).getColumnFamilyStore(command.column_family);
            List<Row> rows = cfs.scan(command.index_clause, command.range, QueryFilter.getFilter(command.predicate, cfs.getComparator()));
            RangeSliceReply reply = new RangeSliceReply(rows);
            Message response = reply.getReply(message);
            if (logger.isDebugEnabled()) {
                logger.debug("Sending " + reply + " to " + id + "@" + message.getFrom());
            }
            MessagingService.instance().sendReply(response, id, message.getFrom());
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

