/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.AbstractEndpointSnitch;
import org.apache.cassandra.locator.AdaptiveLatencyTracker;
import org.apache.cassandra.locator.DynamicEndpointSnitchMBean;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.ILatencySubscriber;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.utils.FBUtilities;

public class DynamicEndpointSnitch
extends AbstractEndpointSnitch
implements ILatencySubscriber,
DynamicEndpointSnitchMBean {
    private static final int UPDATES_PER_INTERVAL = 10000;
    private static final int WINDOW_SIZE = 100;
    private int UPDATE_INTERVAL_IN_MS = DatabaseDescriptor.getDynamicUpdateInterval();
    private int RESET_INTERVAL_IN_MS = DatabaseDescriptor.getDynamicResetInterval();
    private double BADNESS_THRESHOLD = DatabaseDescriptor.getDynamicBadnessThreshold();
    private String mbeanName;
    private boolean registered = false;
    private final ConcurrentHashMap<InetAddress, Double> scores = new ConcurrentHashMap();
    private final ConcurrentHashMap<InetAddress, AdaptiveLatencyTracker> windows = new ConcurrentHashMap();
    private final AtomicInteger intervalupdates = new AtomicInteger(0);
    public final IEndpointSnitch subsnitch;

    public DynamicEndpointSnitch(IEndpointSnitch snitch) {
        this.mbeanName = "org.apache.cassandra.db:type=DynamicEndpointSnitch,instance=" + this.hashCode();
        this.subsnitch = snitch;
        Runnable update = new Runnable(){

            @Override
            public void run() {
                DynamicEndpointSnitch.this.updateScores();
            }
        };
        Runnable reset = new Runnable(){

            @Override
            public void run() {
                DynamicEndpointSnitch.this.reset();
            }
        };
        StorageService.scheduledTasks.scheduleWithFixedDelay(update, this.UPDATE_INTERVAL_IN_MS, this.UPDATE_INTERVAL_IN_MS, TimeUnit.MILLISECONDS);
        StorageService.scheduledTasks.scheduleWithFixedDelay(reset, this.RESET_INTERVAL_IN_MS, this.RESET_INTERVAL_IN_MS, TimeUnit.MILLISECONDS);
        this.registerMBean();
    }

    private void registerMBean() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unregisterMBean() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.unregisterMBean(new ObjectName(this.mbeanName));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void gossiperStarting() {
        this.subsnitch.gossiperStarting();
    }

    @Override
    public String getRack(InetAddress endpoint) {
        return this.subsnitch.getRack(endpoint);
    }

    @Override
    public String getDatacenter(InetAddress endpoint) {
        return this.subsnitch.getDatacenter(endpoint);
    }

    @Override
    public List<InetAddress> getSortedListByProximity(InetAddress address, Collection<InetAddress> addresses) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>(addresses);
        this.sortByProximity(address, list);
        return list;
    }

    @Override
    public void sortByProximity(InetAddress address, List<InetAddress> addresses) {
        assert (address.equals(FBUtilities.getLocalAddress()));
        if (this.BADNESS_THRESHOLD == 0.0) {
            this.sortByProximityWithScore(address, addresses);
        } else {
            this.sortByProximityWithBadness(address, addresses);
        }
    }

    private void sortByProximityWithScore(final InetAddress address, List<InetAddress> addresses) {
        Collections.sort(addresses, new Comparator<InetAddress>(){

            @Override
            public int compare(InetAddress a1, InetAddress a2) {
                return DynamicEndpointSnitch.this.compareEndpoints(address, a1, a2);
            }
        });
    }

    private void sortByProximityWithBadness(InetAddress address, List<InetAddress> addresses) {
        if (addresses.size() < 2) {
            return;
        }
        this.subsnitch.sortByProximity(address, addresses);
        Double first = this.scores.get(addresses.get(0));
        if (first == null) {
            return;
        }
        for (InetAddress addr : addresses) {
            Double next = this.scores.get(addr);
            if (next == null) {
                return;
            }
            if (!((first - next) / first > this.BADNESS_THRESHOLD)) continue;
            this.sortByProximityWithScore(address, addresses);
            return;
        }
    }

    @Override
    public int compareEndpoints(InetAddress target, InetAddress a1, InetAddress a2) {
        Double scored1 = this.scores.get(a1);
        Double scored2 = this.scores.get(a2);
        if (scored1 == null) {
            scored1 = 0.0;
            this.receiveTiming(a1, 0.0);
        }
        if (scored2 == null) {
            scored2 = 0.0;
            this.receiveTiming(a2, 0.0);
        }
        if (scored1.equals(scored2)) {
            return this.subsnitch.compareEndpoints(target, a1, a2);
        }
        if (scored1 < scored2) {
            return -1;
        }
        return 1;
    }

    @Override
    public void receiveTiming(InetAddress host, Double latency) {
        AdaptiveLatencyTracker alt;
        if (this.intervalupdates.intValue() >= 10000) {
            return;
        }
        AdaptiveLatencyTracker tracker = this.windows.get(host);
        if (tracker == null && (tracker = this.windows.putIfAbsent(host, alt = new AdaptiveLatencyTracker(100))) == null) {
            tracker = alt;
        }
        tracker.add(latency);
        this.intervalupdates.getAndIncrement();
    }

    private void updateScores() {
        if (!StorageService.instance.isInitialized()) {
            return;
        }
        if (!this.registered && MessagingService.instance() != null) {
            MessagingService.instance().register(this);
            this.registered = true;
        }
        for (Map.Entry<InetAddress, AdaptiveLatencyTracker> entry : this.windows.entrySet()) {
            this.scores.put(entry.getKey(), entry.getValue().score());
        }
        this.intervalupdates.set(0);
    }

    private void reset() {
        for (AdaptiveLatencyTracker tracker : this.windows.values()) {
            tracker.clear();
        }
    }

    @Override
    public Map<InetAddress, Double> getScores() {
        return this.scores;
    }

    @Override
    public int getUpdateInterval() {
        return this.UPDATE_INTERVAL_IN_MS;
    }

    @Override
    public int getResetInterval() {
        return this.RESET_INTERVAL_IN_MS;
    }

    @Override
    public double getBadnessThreshold() {
        return this.BADNESS_THRESHOLD;
    }

    @Override
    public String getSubsnitchClassName() {
        return this.subsnitch.getClass().getName();
    }

    @Override
    public List<Double> dumpTimings(String hostname) throws UnknownHostException {
        InetAddress host = InetAddress.getByName(hostname);
        ArrayList<Double> timings = new ArrayList<Double>();
        AdaptiveLatencyTracker window = this.windows.get(host);
        if (window != null) {
            for (double time : window) {
                timings.add(time);
            }
        }
        return timings;
    }
}

