/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.config;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.avro.util.Utf8;
import org.apache.cassandra.cache.IRowCacheProvider;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.migration.avro.ColumnDef;
import org.apache.cassandra.db.migration.avro.IndexType;
import org.apache.cassandra.io.SerDeUtils;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

public final class CFMetaData {
    public static final double DEFAULT_ROW_CACHE_SIZE = 0.0;
    public static final double DEFAULT_KEY_CACHE_SIZE = 200000.0;
    public static final double DEFAULT_READ_REPAIR_CHANCE = 1.0;
    public static final boolean DEFAULT_REPLICATE_ON_WRITE = true;
    public static final int DEFAULT_SYSTEM_MEMTABLE_THROUGHPUT_IN_MB = 8;
    public static final int DEFAULT_ROW_CACHE_SAVE_PERIOD_IN_SECONDS = 0;
    public static final int DEFAULT_KEY_CACHE_SAVE_PERIOD_IN_SECONDS = 14400;
    public static final int DEFAULT_GC_GRACE_SECONDS = 864000;
    public static final int DEFAULT_MIN_COMPACTION_THRESHOLD = 4;
    public static final int DEFAULT_MAX_COMPACTION_THRESHOLD = 32;
    public static final int DEFAULT_MEMTABLE_LIFETIME_IN_MINS = 1440;
    public static final int DEFAULT_MEMTABLE_THROUGHPUT_IN_MB = CFMetaData.sizeMemtableThroughput();
    public static final double DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS = CFMetaData.sizeMemtableOperations(DEFAULT_MEMTABLE_THROUGHPUT_IN_MB);
    public static final double DEFAULT_MERGE_SHARDS_CHANCE = 0.1;
    public static final String DEFAULT_ROW_CACHE_PROVIDER = "org.apache.cassandra.cache.ConcurrentLinkedHashCacheProvider";
    public static final ByteBuffer DEFAULT_KEY_NAME = ByteBufferUtil.bytes("KEY");
    private static final int MIN_CF_ID = 1000;
    private static final AtomicInteger idGen = new AtomicInteger(1000);
    private static final BiMap<Pair<String, String>, Integer> cfIdMap = HashBiMap.create();
    public static final CFMetaData StatusCf = CFMetaData.newSystemMetadata("LocationInfo", 0, "persistent metadata for the local node", BytesType.instance, null, 8);
    public static final CFMetaData HintsCf = CFMetaData.newSystemMetadata("HintsColumnFamily", 1, "hinted handoff data", BytesType.instance, BytesType.instance, Math.min(256, Math.max(32, DEFAULT_MEMTABLE_THROUGHPUT_IN_MB / 2)));
    public static final CFMetaData MigrationsCf = CFMetaData.newSystemMetadata("Migrations", 2, "individual schema mutations", TimeUUIDType.instance, null, 8);
    public static final CFMetaData SchemaCf = CFMetaData.newSystemMetadata("Schema", 3, "current state of the schema", UTF8Type.instance, null, 8);
    public static final CFMetaData IndexCf = CFMetaData.newSystemMetadata("IndexInfo", 5, "indexes that have been completed", UTF8Type.instance, null, 8);
    public static final CFMetaData NodeIdCf = CFMetaData.newSystemMetadata("NodeIdInfo", 6, "nodeId and their metadata", TimeUUIDType.instance, null, 8);
    public final Integer cfId;
    public final String ksName;
    public final String cfName;
    public final ColumnFamilyType cfType;
    public final AbstractType comparator;
    public final AbstractType subcolumnComparator;
    private String comment;
    private double rowCacheSize;
    private double keyCacheSize;
    private double readRepairChance;
    private boolean replicateOnWrite;
    private int gcGraceSeconds;
    private AbstractType defaultValidator;
    private AbstractType keyValidator;
    private int minCompactionThreshold;
    private int maxCompactionThreshold;
    private int rowCacheSavePeriodInSeconds;
    private int keyCacheSavePeriodInSeconds;
    private int memtableFlushAfterMins;
    private int memtableThroughputInMb;
    private double memtableOperationsInMillions;
    private double mergeShardsChance;
    private IRowCacheProvider rowCacheProvider;
    private ByteBuffer keyAlias;
    private Map<ByteBuffer, ColumnDefinition> column_metadata;

    public static int sizeMemtableThroughput() {
        return (int)(Runtime.getRuntime().maxMemory() / 0x1000000L);
    }

    public static double sizeMemtableOperations(int mem_throughput) {
        return 0.3 * (double)mem_throughput / 64.0;
    }

    public static Pair<String, String> getCF(Integer cfId) {
        return (Pair)cfIdMap.inverse().get((Object)cfId);
    }

    public static Integer getId(String ksName, String cfName) {
        return (Integer)cfIdMap.get(new Pair<String, String>(ksName, cfName));
    }

    public static void fixMaxId() {
        idGen.set(cfIdMap.size() == 0 ? 1000 : Math.max((Integer)Collections.max(cfIdMap.values()) + 1, 1000));
    }

    public static void map(CFMetaData cfm) throws ConfigurationException {
        Pair<String, String> key = new Pair<String, String>(cfm.ksName, cfm.cfName);
        if (cfIdMap.containsKey(key)) {
            throw new ConfigurationException("Attempt to assign id to existing column family.");
        }
        cfIdMap.put(key, (Object)cfm.cfId);
    }

    public CFMetaData comment(String prop) {
        this.comment = CFMetaData.enforceCommentNotNull(prop);
        return this;
    }

    public CFMetaData rowCacheSize(double prop) {
        this.rowCacheSize = prop;
        return this;
    }

    public CFMetaData keyCacheSize(double prop) {
        this.keyCacheSize = prop;
        return this;
    }

    public CFMetaData readRepairChance(double prop) {
        this.readRepairChance = prop;
        return this;
    }

    public CFMetaData replicateOnWrite(boolean prop) {
        this.replicateOnWrite = prop;
        return this;
    }

    public CFMetaData gcGraceSeconds(int prop) {
        this.gcGraceSeconds = prop;
        return this;
    }

    public CFMetaData defaultValidator(AbstractType prop) {
        this.defaultValidator = prop;
        return this;
    }

    public CFMetaData keyValidator(AbstractType prop) {
        this.keyValidator = prop;
        return this;
    }

    public CFMetaData minCompactionThreshold(int prop) {
        this.minCompactionThreshold = prop;
        return this;
    }

    public CFMetaData maxCompactionThreshold(int prop) {
        this.maxCompactionThreshold = prop;
        return this;
    }

    public CFMetaData rowCacheSavePeriod(int prop) {
        this.rowCacheSavePeriodInSeconds = prop;
        return this;
    }

    public CFMetaData keyCacheSavePeriod(int prop) {
        this.keyCacheSavePeriodInSeconds = prop;
        return this;
    }

    public CFMetaData memTime(int prop) {
        this.memtableFlushAfterMins = prop;
        return this;
    }

    public CFMetaData memSize(int prop) {
        this.memtableThroughputInMb = prop;
        return this;
    }

    public CFMetaData memOps(double prop) {
        this.memtableOperationsInMillions = prop;
        return this;
    }

    public CFMetaData mergeShardsChance(double prop) {
        this.mergeShardsChance = prop;
        return this;
    }

    public CFMetaData keyAlias(ByteBuffer prop) {
        this.keyAlias = prop;
        return this;
    }

    public CFMetaData columnMetadata(Map<ByteBuffer, ColumnDefinition> prop) {
        this.column_metadata = prop;
        return this;
    }

    public CFMetaData rowCacheProvider(IRowCacheProvider prop) {
        this.rowCacheProvider = prop;
        return this;
    }

    public CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType comp, AbstractType subcc) {
        this(keyspace, name, type, comp, subcc, CFMetaData.nextId());
    }

    private CFMetaData(String keyspace, String name, ColumnFamilyType type, AbstractType comp, AbstractType subcc, int id) {
        this.ksName = keyspace;
        this.cfName = name;
        this.cfType = type;
        this.comparator = comp;
        this.subcolumnComparator = this.enforceSubccDefault(type, subcc);
        this.cfId = id;
        this.init();
    }

    private AbstractType enforceSubccDefault(ColumnFamilyType cftype, AbstractType subcc) {
        return subcc == null && cftype == ColumnFamilyType.Super ? BytesType.instance : subcc;
    }

    private static String enforceCommentNotNull(CharSequence comment) {
        return comment == null ? "" : ((Object)comment).toString();
    }

    private void init() {
        this.rowCacheSize = 0.0;
        this.keyCacheSize = 200000.0;
        this.readRepairChance = 1.0;
        this.replicateOnWrite = true;
        this.gcGraceSeconds = 864000;
        this.minCompactionThreshold = 4;
        this.maxCompactionThreshold = 32;
        this.memtableFlushAfterMins = 1440;
        this.memtableThroughputInMb = DEFAULT_MEMTABLE_THROUGHPUT_IN_MB;
        this.memtableOperationsInMillions = DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS;
        this.mergeShardsChance = 0.1;
        try {
            this.rowCacheProvider = FBUtilities.newCacheProvider(DEFAULT_ROW_CACHE_PROVIDER);
        }
        catch (ConfigurationException e) {
            throw new AssertionError((Object)e);
        }
        this.defaultValidator = BytesType.instance;
        this.keyValidator = BytesType.instance;
        this.comment = "";
        this.keyAlias = null;
        this.column_metadata = new HashMap<ByteBuffer, ColumnDefinition>();
    }

    private static CFMetaData newSystemMetadata(String cfName, int cfId, String comment, AbstractType comparator, AbstractType subcc, int memtableThroughPutInMB) {
        ColumnFamilyType type = subcc == null ? ColumnFamilyType.Standard : ColumnFamilyType.Super;
        CFMetaData newCFMD = new CFMetaData("system", cfName, type, comparator, subcc, cfId);
        return newCFMD.comment(comment).keyCacheSize(0.01).readRepairChance(0.0).gcGraceSeconds(0).memSize(memtableThroughPutInMB).memOps(CFMetaData.sizeMemtableOperations(memtableThroughPutInMB)).mergeShardsChance(0.0).rowCacheSavePeriod(0).keyCacheSavePeriod(0);
    }

    public static CFMetaData newIndexMetadata(CFMetaData parent, ColumnDefinition info, AbstractType columnComparator) {
        return new CFMetaData(parent.ksName, parent.indexColumnFamilyName(info), ColumnFamilyType.Standard, columnComparator, null).keyCacheSize(0.0).readRepairChance(0.0).gcGraceSeconds(parent.gcGraceSeconds).minCompactionThreshold(parent.minCompactionThreshold).maxCompactionThreshold(parent.maxCompactionThreshold).memTime(parent.memtableFlushAfterMins).memSize(parent.memtableThroughputInMb).memOps(parent.memtableOperationsInMillions);
    }

    public static CFMetaData rename(CFMetaData cfm, String newName) {
        return CFMetaData.copyOpts(new CFMetaData(cfm.ksName, newName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.cfId), cfm);
    }

    public static CFMetaData renameTable(CFMetaData cfm, String ksName) {
        return CFMetaData.copyOpts(new CFMetaData(ksName, cfm.cfName, cfm.cfType, cfm.comparator, cfm.subcolumnComparator, cfm.cfId), cfm);
    }

    private static CFMetaData copyOpts(CFMetaData newCFMD, CFMetaData oldCFMD) {
        return newCFMD.comment(oldCFMD.comment).rowCacheSize(oldCFMD.rowCacheSize).keyCacheSize(oldCFMD.keyCacheSize).readRepairChance(oldCFMD.readRepairChance).replicateOnWrite(oldCFMD.replicateOnWrite).gcGraceSeconds(oldCFMD.gcGraceSeconds).defaultValidator(oldCFMD.defaultValidator).minCompactionThreshold(oldCFMD.minCompactionThreshold).maxCompactionThreshold(oldCFMD.maxCompactionThreshold).rowCacheSavePeriod(oldCFMD.rowCacheSavePeriodInSeconds).keyCacheSavePeriod(oldCFMD.keyCacheSavePeriodInSeconds).memTime(oldCFMD.memtableFlushAfterMins).memSize(oldCFMD.memtableThroughputInMb).memOps(oldCFMD.memtableOperationsInMillions).columnMetadata(oldCFMD.column_metadata);
    }

    public static void purge(CFMetaData cfm) {
        cfIdMap.remove(new Pair<String, String>(cfm.ksName, cfm.cfName));
    }

    public String indexColumnFamilyName(ColumnDefinition info) {
        return this.cfName + "." + (info.getIndexName() == null ? ByteBufferUtil.bytesToHex(info.name) : info.getIndexName());
    }

    public org.apache.cassandra.db.migration.avro.CfDef deflate() {
        org.apache.cassandra.db.migration.avro.CfDef cf = new org.apache.cassandra.db.migration.avro.CfDef();
        cf.id = this.cfId;
        cf.keyspace = new Utf8(this.ksName);
        cf.name = new Utf8(this.cfName);
        cf.column_type = new Utf8(this.cfType.name());
        cf.comparator_type = new Utf8(this.comparator.toString());
        if (this.subcolumnComparator != null) {
            cf.subcomparator_type = new Utf8(this.subcolumnComparator.toString());
        }
        cf.comment = new Utf8(this.comment);
        cf.row_cache_size = this.rowCacheSize;
        cf.key_cache_size = this.keyCacheSize;
        cf.read_repair_chance = this.readRepairChance;
        cf.replicate_on_write = this.replicateOnWrite;
        cf.gc_grace_seconds = this.gcGraceSeconds;
        cf.default_validation_class = new Utf8(this.defaultValidator.toString());
        cf.key_validation_class = new Utf8(this.keyValidator.toString());
        cf.min_compaction_threshold = this.minCompactionThreshold;
        cf.max_compaction_threshold = this.maxCompactionThreshold;
        cf.row_cache_save_period_in_seconds = this.rowCacheSavePeriodInSeconds;
        cf.key_cache_save_period_in_seconds = this.keyCacheSavePeriodInSeconds;
        cf.memtable_flush_after_mins = this.memtableFlushAfterMins;
        cf.memtable_throughput_in_mb = this.memtableThroughputInMb;
        cf.memtable_operations_in_millions = this.memtableOperationsInMillions;
        cf.merge_shards_chance = this.mergeShardsChance;
        cf.key_alias = this.keyAlias;
        cf.column_metadata = SerDeUtils.createArray(this.column_metadata.size(), ColumnDef.SCHEMA$);
        for (ColumnDefinition cd : this.column_metadata.values()) {
            cf.column_metadata.add(cd.deflate());
        }
        cf.row_cache_provider = new Utf8(this.rowCacheProvider.getClass().getName());
        return cf;
    }

    public static CFMetaData inflate(org.apache.cassandra.db.migration.avro.CfDef cf) {
        AbstractType keyValidator;
        AbstractType validator;
        AbstractType comparator;
        AbstractType subcolumnComparator = null;
        try {
            comparator = TypeParser.parse(((Object)cf.comparator_type).toString());
            if (cf.subcomparator_type != null) {
                subcolumnComparator = TypeParser.parse(cf.subcomparator_type);
            }
            validator = TypeParser.parse(cf.default_validation_class);
            keyValidator = TypeParser.parse(cf.key_validation_class);
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not inflate CFMetaData for " + (Object)((Object)cf), ex);
        }
        TreeMap<ByteBuffer, ColumnDefinition> column_metadata = new TreeMap<ByteBuffer, ColumnDefinition>(BytesType.instance);
        for (ColumnDef aColumn_metadata : cf.column_metadata) {
            ColumnDefinition cd = ColumnDefinition.inflate(aColumn_metadata);
            if (cd.getIndexType() != null && cd.getIndexName() == null) {
                cd.setIndexName(CFMetaData.getDefaultIndexName(((Object)cf.name).toString(), comparator, cd.name));
            }
            column_metadata.put(cd.name, cd);
        }
        CFMetaData newCFMD = new CFMetaData(((Object)cf.keyspace).toString(), ((Object)cf.name).toString(), ColumnFamilyType.create(((Object)cf.column_type).toString()), comparator, subcolumnComparator, cf.id);
        if (cf.min_compaction_threshold != null) {
            newCFMD.minCompactionThreshold(cf.min_compaction_threshold);
        }
        if (cf.max_compaction_threshold != null) {
            newCFMD.maxCompactionThreshold(cf.max_compaction_threshold);
        }
        if (cf.row_cache_save_period_in_seconds != null) {
            newCFMD.rowCacheSavePeriod(cf.row_cache_save_period_in_seconds);
        }
        if (cf.key_cache_save_period_in_seconds != null) {
            newCFMD.keyCacheSavePeriod(cf.key_cache_save_period_in_seconds);
        }
        if (cf.memtable_flush_after_mins != null) {
            newCFMD.memTime(cf.memtable_flush_after_mins);
        }
        if (cf.memtable_throughput_in_mb != null) {
            newCFMD.memSize(cf.memtable_throughput_in_mb);
        }
        if (cf.memtable_operations_in_millions != null) {
            newCFMD.memOps(cf.memtable_operations_in_millions);
        }
        if (cf.merge_shards_chance != null) {
            newCFMD.mergeShardsChance(cf.merge_shards_chance);
        }
        if (cf.row_cache_provider != null) {
            try {
                newCFMD.rowCacheProvider(FBUtilities.newCacheProvider(((Object)cf.row_cache_provider).toString()));
            }
            catch (ConfigurationException e) {
                throw new RuntimeException(e);
            }
        }
        if (cf.key_alias != null) {
            newCFMD.keyAlias(cf.key_alias);
        }
        return newCFMD.comment(((Object)cf.comment).toString()).rowCacheSize(cf.row_cache_size).keyCacheSize(cf.key_cache_size).readRepairChance(cf.read_repair_chance).replicateOnWrite(cf.replicate_on_write).gcGraceSeconds(cf.gc_grace_seconds).defaultValidator(validator).keyValidator(keyValidator).columnMetadata(column_metadata);
    }

    public String getComment() {
        return this.comment;
    }

    public double getRowCacheSize() {
        return this.rowCacheSize;
    }

    public double getKeyCacheSize() {
        return this.keyCacheSize;
    }

    public double getReadRepairChance() {
        return this.readRepairChance;
    }

    public double getMergeShardsChance() {
        return this.mergeShardsChance;
    }

    public boolean getReplicateOnWrite() {
        return this.replicateOnWrite;
    }

    public int getGcGraceSeconds() {
        return this.gcGraceSeconds;
    }

    public AbstractType getDefaultValidator() {
        return this.defaultValidator;
    }

    public AbstractType getKeyValidator() {
        return this.keyValidator;
    }

    public Integer getMinCompactionThreshold() {
        return this.minCompactionThreshold;
    }

    public Integer getMaxCompactionThreshold() {
        return this.maxCompactionThreshold;
    }

    public int getRowCacheSavePeriodInSeconds() {
        return this.rowCacheSavePeriodInSeconds;
    }

    public int getKeyCacheSavePeriodInSeconds() {
        return this.keyCacheSavePeriodInSeconds;
    }

    public int getMemtableFlushAfterMins() {
        return this.memtableFlushAfterMins;
    }

    public int getMemtableThroughputInMb() {
        return this.memtableThroughputInMb;
    }

    public double getMemtableOperationsInMillions() {
        return this.memtableOperationsInMillions;
    }

    public IRowCacheProvider getRowCacheProvider() {
        return this.rowCacheProvider;
    }

    public ByteBuffer getKeyName() {
        return this.keyAlias == null ? DEFAULT_KEY_NAME : this.keyAlias;
    }

    public Map<ByteBuffer, ColumnDefinition> getColumn_metadata() {
        return Collections.unmodifiableMap(this.column_metadata);
    }

    public AbstractType getComparatorFor(ByteBuffer superColumnName) {
        return superColumnName == null ? this.comparator : this.subcolumnComparator;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CFMetaData rhs = (CFMetaData)obj;
        return new EqualsBuilder().append((Object)this.ksName, (Object)rhs.ksName).append((Object)this.cfName, (Object)rhs.cfName).append((Object)this.cfType, (Object)rhs.cfType).append((Object)this.comparator, (Object)rhs.comparator).append((Object)this.subcolumnComparator, (Object)rhs.subcolumnComparator).append((Object)this.comment, (Object)rhs.comment).append(this.rowCacheSize, rhs.rowCacheSize).append(this.keyCacheSize, rhs.keyCacheSize).append(this.readRepairChance, rhs.readRepairChance).append(this.replicateOnWrite, rhs.replicateOnWrite).append(this.gcGraceSeconds, rhs.gcGraceSeconds).append((Object)this.defaultValidator, (Object)rhs.defaultValidator).append((Object)this.keyValidator, (Object)rhs.keyValidator).append(this.minCompactionThreshold, rhs.minCompactionThreshold).append(this.maxCompactionThreshold, rhs.maxCompactionThreshold).append(this.cfId.intValue(), rhs.cfId.intValue()).append(this.column_metadata, rhs.column_metadata).append(this.rowCacheSavePeriodInSeconds, rhs.rowCacheSavePeriodInSeconds).append(this.keyCacheSavePeriodInSeconds, rhs.keyCacheSavePeriodInSeconds).append(this.memtableFlushAfterMins, rhs.memtableFlushAfterMins).append(this.memtableThroughputInMb, rhs.memtableThroughputInMb).append(this.memtableOperationsInMillions, rhs.memtableOperationsInMillions).append(this.mergeShardsChance, rhs.mergeShardsChance).append((Object)this.keyAlias, (Object)rhs.keyAlias).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(29, 1597).append((Object)this.ksName).append((Object)this.cfName).append((Object)this.cfType).append((Object)this.comparator).append((Object)this.subcolumnComparator).append((Object)this.comment).append(this.rowCacheSize).append(this.keyCacheSize).append(this.readRepairChance).append(this.replicateOnWrite).append(this.gcGraceSeconds).append((Object)this.defaultValidator).append((Object)this.keyValidator).append(this.minCompactionThreshold).append(this.maxCompactionThreshold).append((Object)this.cfId).append(this.column_metadata).append(this.rowCacheSavePeriodInSeconds).append(this.keyCacheSavePeriodInSeconds).append(this.memtableFlushAfterMins).append(this.memtableThroughputInMb).append(this.memtableOperationsInMillions).append(this.mergeShardsChance).append((Object)this.keyAlias).toHashCode();
    }

    private static int nextId() {
        return idGen.getAndIncrement();
    }

    public AbstractType getValueValidator(ByteBuffer column) {
        return this.getValueValidator(this.column_metadata.get(column));
    }

    public AbstractType getValueValidator(ColumnDefinition columnDefinition) {
        return columnDefinition == null ? this.defaultValidator : columnDefinition.getValidator();
    }

    public static void applyImplicitDefaults(CfDef cf_def) {
        if (!cf_def.isSetComment()) {
            cf_def.setComment("");
        }
        if (!cf_def.isSetReplicate_on_write()) {
            cf_def.setReplicate_on_write(true);
        }
        if (!cf_def.isSetMin_compaction_threshold()) {
            cf_def.setMin_compaction_threshold(4);
        }
        if (!cf_def.isSetMax_compaction_threshold()) {
            cf_def.setMax_compaction_threshold(32);
        }
        if (!cf_def.isSetRow_cache_save_period_in_seconds()) {
            cf_def.setRow_cache_save_period_in_seconds(0);
        }
        if (!cf_def.isSetKey_cache_save_period_in_seconds()) {
            cf_def.setKey_cache_save_period_in_seconds(14400);
        }
        if (!cf_def.isSetMemtable_flush_after_mins()) {
            cf_def.setMemtable_flush_after_mins(1440);
        }
        if (!cf_def.isSetMemtable_throughput_in_mb()) {
            cf_def.setMemtable_throughput_in_mb(DEFAULT_MEMTABLE_THROUGHPUT_IN_MB);
        }
        if (!cf_def.isSetMemtable_operations_in_millions()) {
            cf_def.setMemtable_operations_in_millions(DEFAULT_MEMTABLE_OPERATIONS_IN_MILLIONS);
        }
        if (!cf_def.isSetMerge_shards_chance()) {
            cf_def.setMerge_shards_chance(0.1);
        }
        if (!cf_def.isSetRow_cache_provider()) {
            cf_def.setRow_cache_provider(DEFAULT_ROW_CACHE_PROVIDER);
        }
    }

    public static CFMetaData fromThrift(CfDef cf_def) throws InvalidRequestException, ConfigurationException {
        ColumnFamilyType cfType = ColumnFamilyType.create(cf_def.column_type);
        if (cfType == null) {
            throw new InvalidRequestException("Invalid column type " + cf_def.column_type);
        }
        CFMetaData.applyImplicitDefaults(cf_def);
        CFMetaData newCFMD = new CFMetaData(cf_def.keyspace, cf_def.name, cfType, TypeParser.parse(cf_def.comparator_type), cf_def.subcomparator_type == null ? null : TypeParser.parse(cf_def.subcomparator_type));
        if (cf_def.isSetGc_grace_seconds()) {
            newCFMD.gcGraceSeconds(cf_def.gc_grace_seconds);
        }
        if (cf_def.isSetMin_compaction_threshold()) {
            newCFMD.minCompactionThreshold(cf_def.min_compaction_threshold);
        }
        if (cf_def.isSetMax_compaction_threshold()) {
            newCFMD.maxCompactionThreshold(cf_def.max_compaction_threshold);
        }
        if (cf_def.isSetRow_cache_save_period_in_seconds()) {
            newCFMD.rowCacheSavePeriod(cf_def.row_cache_save_period_in_seconds);
        }
        if (cf_def.isSetKey_cache_save_period_in_seconds()) {
            newCFMD.keyCacheSavePeriod(cf_def.key_cache_save_period_in_seconds);
        }
        if (cf_def.isSetMemtable_flush_after_mins()) {
            newCFMD.memTime(cf_def.memtable_flush_after_mins);
        }
        if (cf_def.isSetMemtable_throughput_in_mb()) {
            newCFMD.memSize(cf_def.memtable_throughput_in_mb);
        }
        if (cf_def.isSetMemtable_operations_in_millions()) {
            newCFMD.memOps(cf_def.memtable_operations_in_millions);
        }
        if (cf_def.isSetMerge_shards_chance()) {
            newCFMD.mergeShardsChance(cf_def.merge_shards_chance);
        }
        if (cf_def.isSetRow_cache_provider()) {
            newCFMD.rowCacheProvider(FBUtilities.newCacheProvider(cf_def.row_cache_provider));
        }
        if (cf_def.isSetKey_alias()) {
            newCFMD.keyAlias(cf_def.key_alias);
        }
        if (cf_def.isSetKey_validation_class()) {
            newCFMD.keyValidator(TypeParser.parse(cf_def.key_validation_class));
        }
        return newCFMD.comment(cf_def.comment).rowCacheSize(cf_def.row_cache_size).keyCacheSize(cf_def.key_cache_size).readRepairChance(cf_def.read_repair_chance).replicateOnWrite(cf_def.replicate_on_write).defaultValidator(TypeParser.parse(cf_def.default_validation_class)).keyValidator(TypeParser.parse(cf_def.key_validation_class)).columnMetadata(ColumnDefinition.fromColumnDef(cf_def.column_metadata));
    }

    public void apply(org.apache.cassandra.db.migration.avro.CfDef cf_def) throws ConfigurationException {
        if (!((Object)cf_def.keyspace).toString().equals(this.ksName)) {
            throw new ConfigurationException(String.format("Keyspace mismatch (found %s; expected %s)", cf_def.keyspace, this.ksName));
        }
        if (!((Object)cf_def.name).toString().equals(this.cfName)) {
            throw new ConfigurationException(String.format("Column family mismatch (found %s; expected %s)", cf_def.name, this.cfName));
        }
        if (!cf_def.id.equals(this.cfId)) {
            throw new ConfigurationException(String.format("Column family ID mismatch (found %s; expected %s)", cf_def.id, this.cfId));
        }
        if (!((Object)cf_def.column_type).toString().equals(this.cfType.name())) {
            throw new ConfigurationException("types do not match.");
        }
        if (this.comparator != TypeParser.parse(cf_def.comparator_type)) {
            throw new ConfigurationException("comparators do not match.");
        }
        if (cf_def.subcomparator_type == null || cf_def.subcomparator_type.equals("") ? this.subcolumnComparator != null : this.subcolumnComparator != TypeParser.parse(cf_def.subcomparator_type)) {
            throw new ConfigurationException("subcolumncomparators do not match.");
        }
        CFMetaData.validateMinMaxCompactionThresholds(cf_def);
        CFMetaData.validateMemtableSettings(cf_def);
        this.comment = CFMetaData.enforceCommentNotNull(cf_def.comment);
        this.rowCacheSize = cf_def.row_cache_size;
        this.keyCacheSize = cf_def.key_cache_size;
        this.readRepairChance = cf_def.read_repair_chance;
        this.replicateOnWrite = cf_def.replicate_on_write;
        this.gcGraceSeconds = cf_def.gc_grace_seconds;
        this.defaultValidator = TypeParser.parse(cf_def.default_validation_class);
        this.keyValidator = TypeParser.parse(cf_def.key_validation_class);
        this.minCompactionThreshold = cf_def.min_compaction_threshold;
        this.maxCompactionThreshold = cf_def.max_compaction_threshold;
        this.rowCacheSavePeriodInSeconds = cf_def.row_cache_save_period_in_seconds;
        this.keyCacheSavePeriodInSeconds = cf_def.key_cache_save_period_in_seconds;
        this.memtableFlushAfterMins = cf_def.memtable_flush_after_mins;
        this.memtableThroughputInMb = cf_def.memtable_throughput_in_mb;
        this.memtableOperationsInMillions = cf_def.memtable_operations_in_millions;
        this.mergeShardsChance = cf_def.merge_shards_chance;
        if (cf_def.row_cache_provider != null) {
            this.rowCacheProvider = FBUtilities.newCacheProvider(((Object)cf_def.row_cache_provider).toString());
        }
        this.keyAlias = cf_def.key_alias;
        HashSet<ByteBuffer> toRemove = new HashSet<ByteBuffer>();
        HashSet<ByteBuffer> newColumns = new HashSet<ByteBuffer>();
        HashSet<ColumnDef> toAdd = new HashSet<ColumnDef>();
        for (ColumnDef def : cf_def.column_metadata) {
            newColumns.add(def.name);
            if (this.column_metadata.containsKey(def.name)) continue;
            toAdd.add(def);
        }
        for (ByteBuffer name : this.column_metadata.keySet()) {
            if (newColumns.contains(name)) continue;
            toRemove.add(name);
        }
        for (ByteBuffer indexName : toRemove) {
            this.column_metadata.remove(indexName);
        }
        for (ColumnDef def : cf_def.column_metadata) {
            ColumnDefinition oldDef = this.column_metadata.get(def.name);
            if (oldDef == null) continue;
            oldDef.setValidator(TypeParser.parse(def.validation_class));
            oldDef.setIndexType(def.index_type == null ? null : org.apache.cassandra.thrift.IndexType.valueOf((String)def.index_type.name()));
            oldDef.setIndexName(def.index_name == null ? null : ((Object)def.index_name).toString());
        }
        for (ColumnDef def : toAdd) {
            AbstractType dValidClass = TypeParser.parse(def.validation_class);
            ColumnDefinition cd = new ColumnDefinition(def.name, dValidClass, def.index_type == null ? null : org.apache.cassandra.thrift.IndexType.valueOf((String)def.index_type.toString()), def.index_name == null ? null : ((Object)def.index_name).toString());
            this.column_metadata.put(cd.name, cd);
        }
    }

    public static CfDef convertToThrift(CFMetaData cfm) {
        CfDef def = new CfDef(cfm.ksName, cfm.cfName);
        def.setId(cfm.cfId.intValue());
        def.setColumn_type(cfm.cfType.name());
        def.setComparator_type(cfm.comparator.toString());
        if (cfm.subcolumnComparator != null) {
            def.setSubcomparator_type(cfm.subcolumnComparator.toString());
            def.setColumn_type("Super");
        }
        def.setComment(CFMetaData.enforceCommentNotNull(cfm.comment));
        def.setRow_cache_size(cfm.rowCacheSize);
        def.setKey_cache_size(cfm.keyCacheSize);
        def.setRead_repair_chance(cfm.readRepairChance);
        def.setReplicate_on_write(cfm.replicateOnWrite);
        def.setGc_grace_seconds(cfm.gcGraceSeconds);
        def.setDefault_validation_class(cfm.defaultValidator.toString());
        def.setKey_validation_class(cfm.keyValidator.toString());
        def.setMin_compaction_threshold(cfm.minCompactionThreshold);
        def.setMax_compaction_threshold(cfm.maxCompactionThreshold);
        def.setRow_cache_save_period_in_seconds(cfm.rowCacheSavePeriodInSeconds);
        def.setKey_cache_save_period_in_seconds(cfm.keyCacheSavePeriodInSeconds);
        def.setMemtable_flush_after_mins(cfm.memtableFlushAfterMins);
        def.setMemtable_throughput_in_mb(cfm.memtableThroughputInMb);
        def.setMemtable_operations_in_millions(cfm.memtableOperationsInMillions);
        def.setMerge_shards_chance(cfm.mergeShardsChance);
        def.setKey_alias(cfm.getKeyName());
        ArrayList<org.apache.cassandra.thrift.ColumnDef> column_meta = new ArrayList<org.apache.cassandra.thrift.ColumnDef>(cfm.column_metadata.size());
        for (ColumnDefinition cd : cfm.column_metadata.values()) {
            org.apache.cassandra.thrift.ColumnDef tcd = new org.apache.cassandra.thrift.ColumnDef();
            tcd.setIndex_name(cd.getIndexName());
            tcd.setIndex_type(cd.getIndexType());
            tcd.setName(cd.name);
            tcd.setValidation_class(cd.getValidator().toString());
            column_meta.add(tcd);
        }
        def.setColumn_metadata(column_meta);
        return def;
    }

    public static org.apache.cassandra.db.migration.avro.CfDef convertToAvro(CFMetaData cfm) {
        org.apache.cassandra.db.migration.avro.CfDef def = new org.apache.cassandra.db.migration.avro.CfDef();
        def.name = cfm.cfName;
        def.keyspace = cfm.ksName;
        def.id = cfm.cfId;
        def.column_type = cfm.cfType.name();
        def.comparator_type = cfm.comparator.toString();
        if (cfm.subcolumnComparator != null) {
            def.subcomparator_type = cfm.subcolumnComparator.toString();
            def.column_type = "Super";
        }
        def.comment = CFMetaData.enforceCommentNotNull(cfm.comment);
        def.row_cache_size = cfm.rowCacheSize;
        def.key_cache_size = cfm.keyCacheSize;
        def.read_repair_chance = cfm.readRepairChance;
        def.replicate_on_write = cfm.replicateOnWrite;
        def.gc_grace_seconds = cfm.gcGraceSeconds;
        def.default_validation_class = cfm.defaultValidator == null ? null : cfm.defaultValidator.toString();
        def.min_compaction_threshold = cfm.minCompactionThreshold;
        def.max_compaction_threshold = cfm.maxCompactionThreshold;
        def.row_cache_save_period_in_seconds = cfm.rowCacheSavePeriodInSeconds;
        def.key_cache_save_period_in_seconds = cfm.keyCacheSavePeriodInSeconds;
        def.memtable_flush_after_mins = cfm.memtableFlushAfterMins;
        def.memtable_throughput_in_mb = cfm.memtableThroughputInMb;
        def.memtable_operations_in_millions = cfm.memtableOperationsInMillions;
        def.merge_shards_chance = cfm.mergeShardsChance;
        def.key_validation_class = cfm.keyValidator.getClass().getName();
        def.key_alias = cfm.keyAlias;
        ArrayList<ColumnDef> column_meta = new ArrayList<ColumnDef>(cfm.column_metadata.size());
        for (ColumnDefinition cd : cfm.column_metadata.values()) {
            ColumnDef tcd = new ColumnDef();
            tcd.index_name = cd.getIndexName();
            tcd.index_type = cd.getIndexType() == null ? null : IndexType.valueOf(cd.getIndexType().name());
            tcd.name = ByteBufferUtil.clone(cd.name);
            tcd.validation_class = cd.getValidator().toString();
            column_meta.add(tcd);
        }
        def.column_metadata = column_meta;
        def.row_cache_provider = new Utf8(cfm.rowCacheProvider.getClass().getName());
        return def;
    }

    public static org.apache.cassandra.db.migration.avro.CfDef convertToAvro(CfDef def) {
        org.apache.cassandra.db.migration.avro.CfDef newDef = new org.apache.cassandra.db.migration.avro.CfDef();
        newDef.keyspace = def.getKeyspace();
        newDef.name = def.getName();
        newDef.column_type = def.getColumn_type();
        newDef.comment = def.getComment();
        newDef.comparator_type = def.getComparator_type();
        newDef.default_validation_class = def.getDefault_validation_class();
        newDef.key_validation_class = def.getKey_validation_class();
        newDef.gc_grace_seconds = def.getGc_grace_seconds();
        newDef.id = def.getId();
        newDef.key_cache_save_period_in_seconds = def.getKey_cache_save_period_in_seconds();
        newDef.key_cache_size = def.getKey_cache_size();
        newDef.max_compaction_threshold = def.getMax_compaction_threshold();
        newDef.memtable_flush_after_mins = def.getMemtable_flush_after_mins();
        newDef.memtable_operations_in_millions = def.getMemtable_operations_in_millions();
        newDef.memtable_throughput_in_mb = def.getMemtable_throughput_in_mb();
        newDef.min_compaction_threshold = def.getMin_compaction_threshold();
        newDef.read_repair_chance = def.getRead_repair_chance();
        newDef.replicate_on_write = def.isReplicate_on_write();
        newDef.row_cache_save_period_in_seconds = def.getRow_cache_save_period_in_seconds();
        newDef.row_cache_size = def.getRow_cache_size();
        newDef.subcomparator_type = def.getSubcomparator_type();
        newDef.merge_shards_chance = def.getMerge_shards_chance();
        newDef.key_alias = def.key_alias;
        ArrayList<ColumnDef> columnMeta = new ArrayList<ColumnDef>();
        if (def.isSetColumn_metadata()) {
            for (org.apache.cassandra.thrift.ColumnDef cdef : def.getColumn_metadata()) {
                ColumnDef tdef = new ColumnDef();
                tdef.name = ByteBufferUtil.clone(cdef.bufferForName());
                tdef.validation_class = cdef.getValidation_class();
                tdef.index_name = cdef.getIndex_name();
                tdef.index_type = cdef.getIndex_type() == null ? null : IndexType.valueOf(cdef.getIndex_type().name());
                columnMeta.add(tdef);
            }
        }
        newDef.column_metadata = columnMeta;
        return newDef;
    }

    public static void validateMinMaxCompactionThresholds(org.apache.cassandra.db.migration.avro.CfDef cf_def) throws ConfigurationException {
        if (cf_def.min_compaction_threshold != null && cf_def.max_compaction_threshold != null) {
            if (cf_def.min_compaction_threshold > cf_def.max_compaction_threshold && cf_def.max_compaction_threshold != 0) {
                throw new ConfigurationException("min_compaction_threshold cannot be greater than max_compaction_threshold");
            }
        } else if (cf_def.min_compaction_threshold != null) {
            if (cf_def.min_compaction_threshold > 32) {
                throw new ConfigurationException("min_compaction_threshold cannot be greather than max_compaction_threshold (default 32)");
            }
        } else if (cf_def.max_compaction_threshold != null && cf_def.max_compaction_threshold < 4 && cf_def.max_compaction_threshold != 0) {
            throw new ConfigurationException("max_compaction_threshold cannot be less than min_compaction_threshold");
        }
    }

    public static void validateMemtableSettings(org.apache.cassandra.db.migration.avro.CfDef cf_def) throws ConfigurationException {
        if (cf_def.memtable_flush_after_mins != null) {
            DatabaseDescriptor.validateMemtableFlushPeriod(cf_def.memtable_flush_after_mins);
        }
        if (cf_def.memtable_throughput_in_mb != null) {
            DatabaseDescriptor.validateMemtableThroughput(cf_def.memtable_throughput_in_mb);
        }
        if (cf_def.memtable_operations_in_millions != null) {
            DatabaseDescriptor.validateMemtableOperations(cf_def.memtable_operations_in_millions);
        }
    }

    public ColumnDefinition getColumnDefinition(ByteBuffer name) {
        return this.column_metadata.get(name);
    }

    public ColumnDefinition getColumnDefinitionForIndex(String indexName) {
        for (ColumnDefinition def : this.column_metadata.values()) {
            if (!indexName.equals(def.getIndexName())) continue;
            return def;
        }
        return null;
    }

    public static void addDefaultIndexNames(CfDef cf_def) throws InvalidRequestException {
        AbstractType comparator;
        if (cf_def.column_metadata == null) {
            return;
        }
        try {
            comparator = TypeParser.parse(cf_def.comparator_type);
        }
        catch (ConfigurationException e) {
            throw new InvalidRequestException(e.getMessage());
        }
        for (org.apache.cassandra.thrift.ColumnDef column : cf_def.column_metadata) {
            if (column.index_type == null || column.index_name != null) continue;
            column.index_name = CFMetaData.getDefaultIndexName(cf_def.name, comparator, column.name);
        }
    }

    public static String getDefaultIndexName(String cfName, AbstractType comparator, ByteBuffer columnName) {
        return (cfName + "_" + comparator.getString(columnName) + "_idx").replaceAll("\\W", "");
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("cfId", (Object)this.cfId).append("ksName", (Object)this.ksName).append("cfName", (Object)this.cfName).append("cfType", (Object)this.cfType).append("comparator", (Object)this.comparator).append("subcolumncomparator", (Object)this.subcolumnComparator).append("comment", (Object)this.comment).append("rowCacheSize", this.rowCacheSize).append("keyCacheSize", this.keyCacheSize).append("readRepairChance", this.readRepairChance).append("replicateOnWrite", this.replicateOnWrite).append("gcGraceSeconds", this.gcGraceSeconds).append("defaultValidator", (Object)this.defaultValidator).append("keyValidator", (Object)this.keyValidator).append("minCompactionThreshold", this.minCompactionThreshold).append("maxCompactionThreshold", this.maxCompactionThreshold).append("rowCacheSavePeriodInSeconds", this.rowCacheSavePeriodInSeconds).append("keyCacheSavePeriodInSeconds", this.keyCacheSavePeriodInSeconds).append("memtableFlushAfterMins", this.memtableFlushAfterMins).append("memtableThroughputInMb", this.memtableThroughputInMb).append("memtableOperationsInMillions", this.memtableOperationsInMillions).append("mergeShardsChance", this.mergeShardsChance).append("keyAlias", (Object)this.keyAlias).append("column_metadata", this.column_metadata).toString();
    }
}

