/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDeliveryTask
implements Runnable {
    private static final Logger logger_ = LoggerFactory.getLogger(MessageDeliveryTask.class);
    private Message message;
    private final long constructionTime = System.currentTimeMillis();
    private final String id;

    public MessageDeliveryTask(Message message, String id) {
        assert (message != null);
        this.message = message;
        this.id = id;
    }

    @Override
    public void run() {
        StorageService.Verb verb = this.message.getVerb();
        if (MessagingService.DROPPABLE_VERBS.contains((Object)verb) && System.currentTimeMillis() > this.constructionTime + DatabaseDescriptor.getRpcTimeout()) {
            MessagingService.instance().incrementDroppedMessages(verb);
            return;
        }
        IVerbHandler verbHandler = MessagingService.instance().getVerbHandler(verb);
        if (verbHandler == null) {
            logger_.debug("Unknown verb {}", (Object)verb);
            return;
        }
        verbHandler.doVerb(this.message, this.id);
    }
}

